import { defineComponent, h } from 'vue'
import { Color } from '../props'

const CCallout = defineComponent({
  name: 'CCallout',
  props: {
    /**
     * Sets the color context of the component to one of CoreUI’s themed colors.
     *
     * @values 'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark', 'light'
     */
    color: Color,
  },
  setup(props, { slots }) {
    return () =>
      h(
        'div',
        {
          class: [
            'callout',
            {
              [`callout-${props.color}`]: props.color,
            },
          ],
        },
        slots.default && slots.default(),
      )
  },
})
export { CCallout }
