---
name: Migration to v4
description: Track and review changes to the CoreUI for Vue.js components to help you migrate from v3 to v4.
---

CoreUI for Vue is the Vue.js version of CoreUI components library, so before read this migration guide, please check also [CoreUI 3 to 4 migration guide](https://coreui.io/docs/4.0/migration/).

## Components

### CAlert

- Deprecated property `fade`.
- Deprecated property `closeButton`, use `dismissible` instead of.
- Deprecated property `show`, use `visible` instead of.

### CBadge

- Deprecated property `tag`, use `component` instead of.

### CBreadcrumb

- Deprecated property `addClasses`.
- Deprecated property `addLinkClasses`.
- Deprecated property `addLastItemClasses`.
- Deprecated property `items`.

### CButton

- Deprecated property `block`.
- Deprecated property `pressed`.

### CCard

- Deprecated property `accentColor`, use utilities `class="border-top-{#color} border-top-3"` instead of.
- Deprecated property `align`.
- Deprecated property `bodyWrapper`.
- Deprecated property `borderColor`.
- Deprecated property `tag`.

#### CCardBody

- Deprecated property `align`.
- Deprecated property `color`.
- Deprecated property `borderColor`.
- Deprecated property `tag`.
- Deprecated property `textColor`.

#### CCardFooter

- Deprecated property `align`.
- Deprecated property `color`.
- Deprecated property `borderColor`.
- Deprecated property `tag`.
- Deprecated property `textColor`.

#### CCardGroup

- Deprecated property `columns`.
- Deprecated property `deck`.
- Deprecated property `tag`.

#### CCardHeader

- Deprecated property `align`.
- Deprecated property `color`.
- Deprecated property `borderColor`.
- Deprecated property `tag`, use `component` instead of.
- Deprecated property `textColor`.

#### CCardImg

- **Component renamed to `CCardImage`**
- Deprecated property `variant`, use `orientation` instead of.

#### CCardImgOverlay

- **Component renamed to `CCardImageOverlay`**
- Deprecated property `tag`.

#### CCardSubtitle

- Deprecated property `tag`, use `component` instead of.

#### CCardText

- Deprecated property `tag`, use `component` instead of.

#### CCardTitle

- Deprecated property `tag`, use `component` instead of.

### CCarousel

- Deprecated property `animate`.
- Deprecated property `arrows`, use `controls` instead of.
- Deprecated property `indicatorClasses`.
- Deprecated property `height`.

#### CCarouselControl

- Component is depracated, use `<CCarousel controls>` instead of. 

#### CCarouselIndicators

- Component is depracated, use `<CCarousel indicators>` instead of. 

#### CCarouselInner

- Component is depracated. 

### CCollapse

- Deprecated property `duration`.
- Deprecated property `navbar`.
- Deprecated property `transition`.
- Deprecated property `show`, use `visible` instead of.

### CDropdown

- Deprecated property `addMenuClasses`.
- Deprecated property `addTogglerClasses`.
- Deprecated property `caret`.
- Deprecated property `color`.
- Deprecated property `inNav`, use `variant="nav-item"` instead of.
- Deprecated property `togglerText`.
- Deprecated property `show`, use `visible` instead of.
- Deprecated property `size`.
- Deprecated property `split`.

#### CDropdownHeader

- Deprecated property `tag`, use `component` instead of.

### CEmbed

- Component is depracated.

### CFade

- Component is depracated.

### CHeader

- Deprecated property `withSubheader`.
- Deprecated component `CHeaderNavItem`, use `CNavItem` instead of.
- Deprecated component `CHeaderNavLink`, use `CNavLink` instead of.

### CImg

- **Component renamed to `CImage`**
- Deprecated property `block`.
- Deprecated property `fluidGrow`.
- Deprecated property `placeholderColor`.
- Deprecated property `shape`.
- Deprecated property `tag`.

### CJumbotron

- Component is depracated.

### CListGroup

- Deprecated property `horizontal`, use `layout` instead of.
- Deprecated property `tag`, use `component` instead of.

#### CListGroupItem

- Deprecated property `accent`.
- Deprecated property `action`, use property `component="a"` or `component="button"` instead of. 
- Deprecated property `tag`, use `component` instead of.

### CMedia

- Component is depracated.

### CModal

- Deprecated property `addContentClass`.
- Deprecated property `borderColor`, use utilities `class="border border-{#color}"` instead of.
- Deprecated property `centered`.
- Deprecated property `closeOnBackdrop`.
- Deprecated property `fade`, use `transition` instead of.
- Deprecated property `onClosed`.
- Deprecated property `onOpened`.
- Deprecated property `show`, use `visible` instead of.

#### CModalBody

- Deprecated property `tag`.

#### CModalFooter

- Deprecated property `tag`.

#### CModalHeader

- Deprecated property `tag`.

### CNav

- Deprecated property `inCard`.
- Deprecated property `fill`, use `layout="fill"` instead of.
- Deprecated property `justified`, use `layout="justified"` instead of.

#### CNavItem

- Deprecated property `default`.

### CNavbar

- Deprecated property `expandable`, use `expand` instead of.
- Deprecated property `fixed`, use `placement="fixed-top"` instead of.
- Deprecated property `light`, use `colorScheme="light"` instead of.
- Deprecated property `sticky`, use `placement="sticky-top"` instead of.
- Deprecated property `tag`, use `component` instead of.

#### CNavbarNav

- Deprecated property `tag`, use `component` instead of.

#### CNavbarText

- Deprecated property `tag`, use `component` instead of.

### CPagination

- **The component has been split into `CPagination` and to `CSmartPagination` components.

### CPopover

- Deprecated property `header`, use `title` instead of.

### CProgress

- Deprecated property `max`.
- Deprecated property `precision`.
- Deprecated property `showPercentage`.
- Deprecated property `showValue`.
- Deprecated property `size`, use `height` instead of.
- Deprecated property `striped`, use `variant="striped"` instead of.

### CProgressBar

- Deprecated property `max`.
- Deprecated property `precision`.
- Deprecated property `showPercentage`.
- Deprecated property `showValue`.
- Deprecated property `size`, use `height` instead of.
- Deprecated property `striped`, use `variant="striped"` instead of.

### CSidebar
- Deprecated property `minimize` use `narrow` instead of.
- Deprecated property `dropdownMode`.
- Deprecated component `CSidebarForm`, use `CForm` instead of.
- Deprecated component `CSidebarNavDivider`, use `CNavDivider` instead of.
- Deprecated component `CSidebarNavDropdown`, use `CNavGroup` instead of.
- Deprecated component `CSidebarNavLink`, use `CNavLink` instead of.
- Deprecated component `CSidebarNavItem`, use `CNavItem` instead of.
- Deprecated component `CSidebarNavTitile`, use `CNavTitle` instead of.

### CSwitch

- Component is depracated, use `CFormSwitch` instead of.

### CSpinner

- Deprecated property `grow`, use `variant="grow"` instead of.
- Deprecated property `tag`, use `component` instead of.

### CTabs

- Component is depracated, use `<CNav variant="tabs" role="tablist">` instead of

#### CTabContent

- Deprecated property `fade`.

#### CTabPane

- Deprecated property `active`, use `visible` instead of.

### CToast

- Deprecated property `fade`, use `animation` instead of.
- Deprecated property `show`, use `visible` instead of.
- Deprecated property `onStateChange`.

#### CToastBody


#### CToastHeader



### CToggler

- Component is depracated.

### CTooltip

- Deprecated property `interactive`.
- Deprecated property `advancedOptions`.


## Forms

### CFormGroup

- Component is depracated.

### CInput

- **Component renamed to `CFormInput`**
- Deprecated property `plaintext`, use `plainText` instead of.

### CInputCheckbox

- Component is depracated, use `<CFormCheck>` instead of.

### CInputFile

- Component is depracated, use `<CFormInput type="file">` instead of.

### CInputRadio

- Component is depracated, use `<CFormCheck type="radio">` instead of.

### CInputGroup


#### CInputGroupAddon

- Component is depracated, use `CInputGroupText` instead of.

### CSelect

- Component is depracated, use `<CFormSelect>` instead of.

### CValidFeedback

- Component is depracated, use `<CFormFeedback valid>` instead of.

### CInvalidFeedback

- Component is depracated, use `<CCFormFeedback invalid>` instead of.

## Layout

### CContainer

- Deprecated property `tag`.

### CCol

- Deprecated property `tag`.
- Deprecated property `width`, use `xs`, `sm`, `md`, `lg`, `xl`, `xxl`.

### CRow

- Deprecated property `alignHorizontal`.
- Deprecated property `alignVertical`.
- Deprecated property `form`.
- Deprecated property `gutters`.
- Deprecated property `tag`.
- Deprecated property `width`, use `xs`, `sm`, `md`, `lg`, `xl`, `xxl`.