---
name: Columns
description: Learn how to modify columns with a handful of options for alignment, ordering, and offsetting thanks to our flexbox grid system.
menu: Layout
route: "/layout/columns"
---

## How they work

- **Columns build on the grid's flexbox architecture.** Flexbox means we have options for changing individual columns and [modifying groups of columns at the row level](./../grid#row-columns). You choose how columns grow, shrink, or otherwise change.

- **When building grid layouts, all content goes in columns.** The hierarchy of CoreUI's grid goes from [container](./../containers) to row to column to your content. On rare occasions, you may combine content and column, but be aware there can be unintended consequences.

- **CoreUI for Vue.js includes predefined components for creating fast, responsive layouts.** With [six breakpoints](./../breakpoints) and a dozen columns at each grid tier, we have dozens of components already built for you to create your desired layouts. This can be disabled via Sass if you wish.

## Alignment

Use flexbox alignment utilities to vertically and horizontally align columns.

### Vertical alignment

::: demo
<div class="docs-example-row docs-example-row-flex-cols">
  <CContainer>
    <CRow class="align-items-start">
      <CCol>
        One of three columns
      </CCol>
      <CCol>
        One of three columns
      </CCol>
      <CCol>
        One of three columns
      </CCol>
    </CRow>
    <CRow class="align-items-center">
      <CCol>
        One of three columns
      </CCol>
      <CCol>
        One of three columns
      </CCol>
      <CCol>
        One of three columns
      </CCol>
    </CRow>
    <CRow class="align-items-end">
      <CCol>
        One of three columns
      </CCol>
      <CCol>
        One of three columns
      </CCol>
      <CCol>
        One of three columns
      </CCol>
    </CRow>
  </CContainer>
</div> 
:::
```vue
<CContainer>
  <CRow class="align-items-start">
    <CCol>
      One of three columns
    </CCol>
    <CCol>
      One of three columns
    </CCol>
    <CCol>
      One of three columns
    </CCol>
  </CRow>
  <CRow class="align-items-center">
    <CCol>
      One of three columns
    </CCol>
    <CCol>
      One of three columns
    </CCol>
    <CCol>
      One of three columns
    </CCol>
  </CRow>
  <CRow class="align-items-end">
    <CCol>
      One of three columns
    </CCol>
    <CCol>
      One of three columns
    </CCol>
    <CCol>
      One of three columns
    </CCol>
  </CRow>
</CContainer>
```

::: demo
<div class="docs-example-row docs-example-row-flex-cols">
  <CContainer>
    <CRow>
      <CCol class="align-self-start">
        One of three columns
      </CCol>
      <CCol class="align-self-center">
        One of three columns
      </CCol>
      <CCol class="align-self-end">
        One of three columns
      </CCol>
    </CRow>
  </CContainer>
</div>
:::
```vue
<CContainer>
  <CRow>
    <CCol class="align-self-start">
      One of three columns
    </CCol>
    <CCol class="align-self-center">
      One of three columns
    </CCol>
    <CCol class="align-self-end">
      One of three columns
    </CCol>
  </CRow>
</CContainer>
```

### Horizontal alignment

::: demo
<div class="docs-example-row">
  <CContainer>
    <CRow class="justify-content-start">
      <CCol xs="4">
        One of two columns
      </CCol>
      <CCol xs="4">
        One of two columns
      </CCol>
    </CRow>
    <CRow class="justify-content-center">
      <CCol xs="4">
        One of two columns
      </CCol>
      <CCol xs="4">
        One of two columns
      </CCol>
    </CRow>
    <CRow class="justify-content-end">
      <CCol xs="4">
        One of two columns
      </CCol>
      <CCol xs="4">
        One of two columns
      </CCol>
    </CRow>
    <CRow class="justify-content-around">
      <CCol xs="4">
        One of two columns
      </CCol>
      <CCol xs="4">
        One of two columns
      </CCol>
    </CRow>
    <CRow class="justify-content-between">
      <CCol xs="4">
        One of two columns
      </CCol>
      <CCol xs="4">
        One of two columns
      </CCol>
    </CRow>
    <CRow class="justify-content-evenly">
      <CCol xs="4">
        One of two columns
      </CCol>
      <CCol xs="4">
        One of two columns
      </CCol>
    </CRow>
  </CContainer>
</div>
:::
```vue
<CContainer>
  <CRow class="justify-content-start">
    <CCol xs="4">
      One of two columns
    </CCol>
    <CCol xs="4">
      One of two columns
    </CCol>
  </CRow>
  <CRow class="justify-content-center">
    <CCol xs="4">
      One of two columns
    </CCol>
    <CCol xs="4">
      One of two columns
    </CCol>
  </CRow>
  <CRow class="justify-content-end">
    <CCol xs="4">
      One of two columns
    </CCol>
    <CCol xs="4">
      One of two columns
    </CCol>
  </CRow>
  <CRow class="justify-content-around">
    <CCol xs="4">
      One of two columns
    </CCol>
    <CCol xs="4">
      One of two columns
    </CCol>
  </CRow>
  <CRow class="justify-content-between">
    <CCol xs="4">
      One of two columns
    </CCol>
    <CCol xs="4">
      One of two columns
    </CCol>
  </CRow>
  <CRow class="justify-content-evenly">
    <CCol xs="4">
      One of two columns
    </CCol>
    <CCol xs="4">
      One of two columns
    </CCol>
  </CRow>
</CContainer>
```

### Column wrapping

If more than 12 columns are placed within a single row, each group of extra columns will, as one unit, wrap onto a new line.

::: demo
<div class="docs-example-row">
  <CContainer>
    <CRow>
      <CCol xs="9">.col-9</CCol>
      <CCol xs="4">.col-4<br/>Since 9 + 4 = 13 &gt; 12, this 4-column-wide div gets wrapped onto a new line as one contiguous unit.</CCol>
      <CCol xs="6">.col-6<br/>Subsequent columns continue along the new line.</CCol>
    </CRow>
  </CContainer>
</div>
:::
```vue
<CContainer>
  <CRow>
    <CCol xs="9">.col-9</CCol>
    <CCol xs="4">.col-4<br/>Since 9 + 4 = 13 &gt; 12, this 4-column-wide div gets wrapped onto a new line as one contiguous unit.</CCol>
    <CCol xs="6">.col-6<br/>Subsequent columns continue along the new line.</CCol>
  </CRow>
</CContainer>
```

### Column breaks

Breaking columns to a new line in flexbox requires a small hack: add an element with `width: 100%` wherever you want to wrap your columns to a new line. Normally this is accomplished with multiple `<CRow>`s, but not every implementation method can account for this.

::: demo
<div class="docs-example-row">
  <CContainer>
    <CRow>
      <CCol xs="6" sm="3">.col-6 .col-sm-3</CCol>
      <CCol xs="6" sm="3">.col-6 .col-sm-3</CCol>
      <div class="w-100"></div>
      <CCol xs="6" sm="3">.col-6 .col-sm-3</CCol>
      <CCol xs="6" sm="3">.col-6 .col-sm-3</CCol>
    </CRow>
  </CContainer>
</div>
:::
```vue
<CContainer>
  <CRow>
    <CCol xs="6" sm="3">.col-6 .col-sm-3</CCol>
    <CCol xs="6" sm="3">.col-6 .col-sm-3</CCol>
    <div class="w-100"></div>
    <CCol xs="6" sm="3">.col-6 .col-sm-3</CCol>
    <CCol xs="6" sm="3">.col-6 .col-sm-3</CCol>
  </CRow>
</CContainer>
```

You may also apply this break at specific breakpoints with our [responsive display utilities](https://coreui.io/docs/utilities/display).

::: demo
<div class="docs-example-row">
  <CContainer>
    <CRow>
      <CCol xs="6" sm="4">.col-6 .col-sm-4</CCol>
      <CCol xs="6" sm="4">.col-6 .col-sm-4</CCol>
      <div class="w-100 d-none d-md-block"></div>
      <CCol xs="6" sm="4">.col-6 .col-sm-4</CCol>
      <CCol xs="6" sm="4">.col-6 .col-sm-4</CCol>
    </CRow>
  </CContainer>
</div>
:::
```vue
<CContainer>
  <CRow>
    <CCol xs="6" sm="4">.col-6 .col-sm-4</CCol>
    <CCol xs="6" sm="4">.col-6 .col-sm-4</CCol>
    <div class="w-100 d-none d-md-block"></div>
    <CCol xs="6" sm="4">.col-6 .col-sm-4</CCol>
    <CCol xs="6" sm="4">.col-6 .col-sm-4</CCol>
  </CRow>
</CContainer>
```

## Reordering

### Order props

Use `xs|sm|md|lg|xl|xxl="{ order: 1-5 }"` props for controlling the **visual order** of your content. These props are responsive, so you can set the `order` by breakpoint (e.g., `xs="{ order: 1}" md="{ order: 2}"`). Includes support for `1` through `5` across all six grid tiers.

::: demo
<div class="docs-example-row">
  <CContainer>
    <CRow>
      <CCol>
        First in DOM, no order applied
      </CCol>
      <CCol xs="{ span: true, order: 5 }">
        Second in DOM, with a larger order
      </CCol>
      <CCol xs="{ span: true, order: 1 }">
        Third in DOM, with an order of 1
      </CCol>
    </CRow>
  </CContainer>
</div>
:::
```vue
<CContainer>
  <CRow>
    <CCol>
      First in DOM, no order applied
    </CCol>
    <CCol xs="{ span: true, order: 5 }">
      Second in DOM, with a larger order
    </CCol>
    <CCol xs="{ span: true, order: 1 }">
      Third in DOM, with an order of 1
    </CCol>
  </CRow>
</CContainer>
```

There are also responsive `xs|sm|md|lg|xl|xxl="{ order: 'first' }"` and `xs|sm|md|lg|xl|xxl="{ order: 'last' }"` props that change the `order` of an element by applying `order: -1` and `order: 6`, respectively. These values can also be intermixed with the numbered `xs|sm|md|lg|xl|xxl="{ order: 1-5 }"` values as needed.

::: demo
<div class="docs-example-row">
  <CContainer>
    <CRow>
      <CCol xs="{ span: true, order: 'last' }">
        First in DOM, ordered last
      </CCol>
      <CCol>
        Second in DOM, unordered
      </CCol>
      <CCol xs="{ span: true, order: 'first' }">
        Third in DOM, ordered first
      </CCol>
    </CRow>
  </CContainer>
</div>
:::
```vue
<CContainer>
  <CRow>
    <CCol xs="{ span: true, order: 'last' }">
      First in DOM, ordered last
    </CCol>
    <CCol>
      Second in DOM, unordered
    </CCol>
    <CCol xs="{ span: true, order: 'first' }">
      Third in DOM, ordered first
    </CCol>
  </CRow>
</CContainer>
```

### Offsetting columns

You can offset grid columns in two ways: our responsive `xs|sm|md|lg|xl|xxl="{ offset: 0-12 }"` grid props and our [margin utilities](https://coreui.io/docs/utilities/spacing). Grid props are sized to match columns while margins are more useful for quick layouts where the width of the offset is variable.

#### Offset prop

Move columns to the right using `md="{ offset: * }"` props. These props increase the left margin of a column by `*` columns. For example, `md="{ offset: 4 }"` moves `.col-md-4` over four columns.

::: demo
<div class="docs-example-row">
  <CContainer>
    <CRow>
      <CCol md="4">.col-md-4</CCol>
      <CCol md="{ span: 4, offset: 4 }">.col-md-4 .offset-md-4</CCol>
    </CRow>
    <CRow>
      <CCol md="{ span: 3, offset: 3 }">.col-md-3 .offset-md-3</CCol>
      <CCol md="{ span: 3, offset: 3 }">.col-md-3 .offset-md-3</CCol>
    </CRow>
    <CRow>
      <CCol md="{ span: 6, offset: 3 }">.col-md-6 .offset-md-3</CCol>
    </CRow>
  </CContainer>
</div>
:::
```vue
<CContainer>
  <CRow>
    <CCol md="4">.col-md-4</CCol>
    <CCol md="{ span: 4, offset: 4 }">.col-md-4 .offset-md-4</CCol>
  </CRow>
  <CRow>
    <CCol md="{ span: 3, offset: 3 }">.col-md-3 .offset-md-3</CCol>
    <CCol md="{ span: 3, offset: 3 }">.col-md-3 .offset-md-3</CCol>
  </CRow>
  <CRow>
    <CCol md="{ span: 6, offset: 3 }">.col-md-6 .offset-md-3</CCol>
  </CRow>
</CContainer>
```

::: demo
<div class="docs-example-row">
  <CContainer>
    <CRow>
      <CCol sm="5" md="6">.col-sm-5 .col-md-6</CCol>
      <CCol sm="{ span: 5, offset: 2 }" md="{ span: 6, offset: 0 }">.col-sm-5 .offset-sm-2 .col-md-6 .offset-md-0</CCol>
    </CRow>
    <CRow>
      <CCol sm="6" md="5" lg="6">.col-sm-6 .col-md-5 .col-lg-6</CCol>
      <CCol sm="6" md="{ span: 5, offset: 2 }" lg="{ span: 6, offset: 0 }">.col-sm-6 .col-md-5 .offset-md-2 .col-lg-6 .offset-lg-0</CCol>
    </CRow>
  </CContainer>
</div>
:::
```vue
<CContainer>
  <CRow>
    <CCol sm="5" md="6">.col-sm-5 .col-md-6</CCol>
    <CCol sm="{ span: 5, offset: 2 }" md="{ span: 6, offset: 0 }">.col-sm-5 .offset-sm-2 .col-md-6 .offset-md-0</CCol>
  </CRow>
  <CRow>
    <CCol sm="6" md="5" lg="6">.col-sm-6 .col-md-5 .col-lg-6</CCol>
    <CCol sm="6" md="{ span: 5, offset: 2 }" lg="{ span: 6, offset: 0 }">.col-sm-6 .col-md-5 .offset-md-2 .col-lg-6 .offset-lg-0</CCol>
  </CRow>
</CContainer>
```


#### Margin utilities

You can use margin utilities like `.me-auto` to force sibling columns away from one another.

::: demo
<div class="docs-example-row">
  <CContainer>
    <CRow>
      <CCol md="4">.col-md-4</CCol>
      <CCol md="4" class="ms-auto">.col-md-4 .ms-auto</CCol>
    </CRow>
    <CRow>
      <CCol md="3" class="ms-md-auto">.col-md-3 .ms-md-auto</CCol>
      <CCol md="3" class="ms-md-auto">.col-md-3 .ms-md-auto</CCol>
    </CRow>
    <CRow>
      <CCol xs="auto" class="me-auto">.col-auto .me-auto</CCol>
      <CCol xs="auto">.col-auto</CCol>
    </CRow>
  </CContainer>
</div>
:::
```vue
<CContainer>
  <CRow>
    <CCol md="4">.col-md-4</CCol>
    <CCol md="4" class="ms-auto">.col-md-4 .ms-auto</CCol>
  </CRow>
  <CRow>
    <CCol md="3" class="ms-md-auto">.col-md-3 .ms-md-auto</CCol>
    <CCol md="3" class="ms-md-auto">.col-md-3 .ms-md-auto</CCol>
  </CRow>
  <CRow>
    <CCol xs="auto" class="me-auto">.col-auto .me-auto</CCol>
    <CCol xs="auto">.col-auto</CCol>
  </CRow>
</CContainer>
```

## Standalone column component

The `<CCol>` component can also be used outside a `<CRow>` to give an element a specific width. Whenever column component are used as non direct children of a row, the paddings are omitted.

::: demo
<CCol xs="3" class="bg-light p-3 border">
  .col-3: width of 25%
</CCol>
<CCol sm="9" class="bg-light p-3 border">
  .col-sm-9: width of 75% above sm breakpoint
</CCol>
:::
```vue
<CCol xs="3" class="bg-light p-3 border">
  .col-3: width of 25%
</CCol>
<CCol sm="9" class="bg-light p-3 border">
  .col-sm-9: width of 75% above sm breakpoint
</CCol>
```

## API

!!!include(./docs/api/grid/CCol.api.md)!!!
