---
title: Vue Nav Component
name: Nav
description: Documentation and examples for how to use CoreUI's included Vue navigation components.

---

## Base nav

Navigation available in CoreUI for Vue share general markup and styles, from the base `.nav` class to the active and disabled states. Swap modifier classes to switch between each style.

The base `.nav` component is built with flexbox and provide a strong foundation for building all types of navigation components. It includes some style overrides (for working with lists), some link padding for larger hit areas, and basic disabled styling.

::: demo

  <CNav>
    <CNavItem>
      <CNavLink href="#" active>
        Active
      </CNavLink>
    </CNavItem>
    <CNavItem>
      <CNavLink href="#">Link</CNavLink>
    </CNavItem>
    <CNavItem>
      <CNavLink href="#">Link</CNavLink>
    </CNavItem>
    <CNavItem>
      <CNavLink href="#" disabled>
        Disabled
      </CNavLink>
    </CNavItem>
  </CNav>

:::
```vue

  <CNav>
    <CNavItem>
      <CNavLink href="#" active>
        Active
      </CNavLink>
    </CNavItem>
    <CNavItem>
      <CNavLink href="#">Link</CNavLink>
    </CNavItem>
    <CNavItem>
      <CNavLink href="#">Link</CNavLink>
    </CNavItem>
    <CNavItem>
      <CNavLink href="#" disabled>
        Disabled
      </CNavLink>
    </CNavItem>
  </CNav>

```

Classes are used throughout, so your markup can be super flexible. Use `<ul>`s like above, `<ol>` if the order of your items is important, or roll your own with a `<nav>` element. Because the .nav uses display: flex, the nav links behave the same as nav items would, but without the extra markup.

::: demo

  <CNav component="nav">
    <CNavLink href="#" active>
      Active
    </CNavLink>
    <CNavLink href="#">Link</CNavLink>
    <CNavLink href="#">Link</CNavLink>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNav>

:::
```vue

  <CNav component="nav">
    <CNavLink href="#" active>
      Active
    </CNavLink>
    <CNavLink href="#">Link</CNavLink>
    <CNavLink href="#">Link</CNavLink>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNav>

```

## Available styles

Change the style of `.nav`s component with modifiers and utilities. Mix and match as needed, or build your own.

### Horizontal alignment

Change the horizontal alignment of your nav with [flexbox utilities](https://coreui.io/docs/layout/grid/#horizontal-alignment). By default, navs are left-aligned, but you can easily change them to center or right aligned.

Centered with `.justify-content-center`:

::: demo
<CNav class="justify-content-center">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
:::
```vue
<CNav class="justify-content-center">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
```

Right-aligned with `.justify-content-end`:

::: demo
<CNav class="justify-content-end">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
:::
```vue
<CNav class="justify-content-end">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
```

### Vertical

Stack your navigation by changing the flex item direction with the `.flex-column` utility. Need to stack them on some viewports but not others? Use the responsive versions (e.g., `.flex-sm-column`).

::: demo
<CNav class="flex-column">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
:::
```vue
<CNav class="flex-column">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
```

### Tabs

Takes the basic nav from above and adds the `variant="tabs"` class to generate a tabbed interface

::: demo
<CNav variant="tabs">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
:::
```vue
<CNav variant="tabs">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
```

### Pills

Take that same HTML, but use `variant="pills"` instead:

::: demo
<CNav variant="pills">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
:::
```vue
<CNav variant="pills">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
```

### Fill and justify

Force your `.nav`'s contents to extend the full available width one of two modifier classes. To proportionately fill all available space with your `.nav-item`s, use `layout="fill"`. Notice that all horizontal space is occupied, but not every nav item has the same width.

::: demo
<CNav variant="pills" layout="fill">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
:::
```vue
<CNav variant="pills" layout="fill">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
```

For equal-width elements, use `layout="justified"`. All horizontal space will be occupied by nav links, but unlike the .nav-fill above, every nav item will be the same width.

::: demo
<CNav variant="pills" layout="justified">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
:::
```vue
<CNav variant="pills" layout="justified">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
```

## Working with flex utilities

If you need responsive nav variations, consider using a series of [flexbox utilities](https://coreui.io/docs/utilities/flex). While more verbose, these utilities offer greater customization across responsive breakpoints. In the example below, our nav will be stacked on the lowest breakpoint, then adapt to a horizontal layout that fills the available width starting from the small breakpoint.

::: demo
<CNav component="nav" variant="pills" class="flex-column flex-sm-row">
  <CNavLink href="#" active>
    Active
  </CNavLink>
  <CNavLink href="#">Link</CNavLink>
  <CNavLink href="#">Link</CNavLink>
  <CNavLink href="#" disabled>
    Disabled
  </CNavLink>
</CNav>
:::
```vue
<CNav component="nav" variant="pills" class="flex-column flex-sm-row">
  <CNavLink href="#" active>
    Active
  </CNavLink>
  <CNavLink href="#">Link</CNavLink>
  <CNavLink href="#">Link</CNavLink>
  <CNavLink href="#" disabled>
    Disabled
  </CNavLink>
</CNav>
```

## Regarding accessibility

If you're using navs to provide a navigation bar, be sure to add a `role="navigation"` to the most logical parent container of the `<ul>`, or wrap a `<nav>` element around the whole navigation. Do not add the role to the `<ul>` itself, as this would prevent it from being announced as an actual list by assistive technologies.

Note that navigation bars, even if visually styled as tabs with the `.nav-tabs` class, should **not** be given `role="tablist"`, `role="tab"` or `role="tabpanel"` attributes. These are only appropriate for dynamic tabbed interfaces, as described in the [<abbr title="Web Accessibility Initiative">WAI</abbr> <abbr title="Accessible Rich Internet Applications">ARIA</abbr> Authoring Practices](https://www.w3.org/TR/wai-aria-practices/#tabpanel). See [JavaScript behavior](#javascript-behavior) for dynamic tabbed interfaces in this section for an example. The `aria-current` attribute is not necessary on dynamic tabbed interfaces since our JavaScript handles the selected state by adding `aria-selected="true"` on the active tab.

## Using dropdowns

Add dropdown menus with a little extra HTML.

### Tabs with dropdowns

::: demo
<CNav>
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CDropdown variant="nav-item">
    <CDropdownToggle color="secondary">Dropdown button</CDropdownToggle>
    <CDropdownMenu>
      <CDropdownItem href="#">Action</CDropdownItem>
      <CDropdownItem href="#">Another action</CDropdownItem>
      <CDropdownItem href="#">Something else here</CDropdownItem>
    </CDropdownMenu>
  </CDropdown>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
:::
```vue
<CNav>
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CDropdown variant="nav-item">
    <CDropdownToggle color="secondary">Dropdown button</CDropdownToggle>
    <CDropdownMenu>
      <CDropdownItem href="#">Action</CDropdownItem>
      <CDropdownItem href="#">Another action</CDropdownItem>
      <CDropdownItem href="#">Something else here</CDropdownItem>
    </CDropdownMenu>
  </CDropdown>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
```

### Pills with dropdowns

::: demo
<CNav variant="pills">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CDropdown variant="nav-item">
    <CDropdownToggle color="secondary">Dropdown button</CDropdownToggle>
    <CDropdownMenu>
      <CDropdownItem href="#">Action</CDropdownItem>
      <CDropdownItem href="#">Another action</CDropdownItem>
      <CDropdownItem href="#">Something else here</CDropdownItem>
    </CDropdownMenu>
  </CDropdown>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
:::
```vue
<CNav variant="pills">
  <CNavItem>
    <CNavLink href="#" active>
      Active
    </CNavLink>
  </CNavItem>
  <CDropdown variant="nav-item">
    <CDropdownToggle color="secondary">Dropdown button</CDropdownToggle>
    <CDropdownMenu>
      <CDropdownItem href="#">Action</CDropdownItem>
      <CDropdownItem href="#">Another action</CDropdownItem>
      <CDropdownItem href="#">Something else here</CDropdownItem>
    </CDropdownMenu>
  </CDropdown>
  <CNavItem>
    <CNavLink href="#">Link</CNavLink>
  </CNavItem>
  <CNavItem>
    <CNavLink href="#" disabled>
      Disabled
    </CNavLink>
  </CNavItem>
</CNav>
```

## API

!!!include(./docs/api/nav/CNav.api.md)!!!

!!!include(./docs/api/nav/CNavGroup.api.md)!!!

!!!include(./docs/api/nav/CNavItem.api.md)!!!

`CNavItem` and `CNavLink` have the same properties. If you set the `href` property on `CNavItem` then, `CNavLink` will be generated inside `CNavItem`.

!!!include(./docs/api/nav/CNavLink.api.md)!!!