# [@coreui/angular](https://coreui.io/angular)

![angular](https://img.shields.io/badge/angular-^20.2.0-lightgrey.svg?style=flat-square&logo=angular)
[![npm package][npm-coreui-angular-badge-v2]][npm-coreui-angular]
[![npm package][npm-coreui-angular-badge-latest]][npm-coreui-angular]
[![NPM downloads][npm-coreui-angular-download]][npm-coreui-angular]  
[![@coreui coreui](https://img.shields.io/badge/@coreui%20-coreui-lightgrey.svg?style=flat-square)](https://github.com/coreui/coreui)
[![npm package][npm-coreui-badge-v2]][npm-coreui]
[![npm package][npm-coreui-badge]][npm-coreui]
[![NPM downloads][npm-coreui-download]][npm-coreui]
 

[npm-coreui-angular]: https://www.npmjs.com/package/@coreui/angular  
[npm-coreui-angular-badge-v2]: https://img.shields.io/npm/v/@coreui/angular/v2-ng20?style=flat-square&color=red
[npm-coreui-angular-badge-latest]: https://img.shields.io/npm/v/@coreui/angular/latest?style=flat-square&color=red
[npm-coreui-angular-badge-next]: https://img.shields.io/npm/v/@coreui/angular/next?style=flat-square&color=red  
[npm-coreui-angular-download]: https://img.shields.io/npm/dm/@coreui/angular.svg?style=flat-square  
[npm-coreui-angular-next]: https://img.shields.io/npm/v/@coreui/angular/next?style=flat-square
[npm-coreui]: https://www.npmjs.com/package/@coreui/coreui
[npm-coreui-badge]: https://img.shields.io/npm/v/@coreui/coreui/latest?style=flat-square
[npm-coreui-badge-v2]: https://img.shields.io/npm/v/@coreui/coreui/v2-lts?style=flat-square
[npm-coreui-download]: https://img.shields.io/npm/dm/@coreui/coreui.svg?style=flat-square

> [@coreui/angular](https://coreui.io/angular) v2 library project  
> for use with [CoreUI](https://coreui.io/angular/) v2 Bootstrap Admin Template

CoreUI is an Open Source UI Kit built on top of Bootstrap 4. CoreUI is the fastest way to build modern dashboard for any platforms, browser or device. A complete Dashboard and WebApp UI Kit that allows you to quickly build eye-catching, high-quality, high-performance responsive applications using your framework of choice.

## Table of Contents

* [Template](#template)
* [Prerequisites](#prerequisites)
* [Installation](#coreui-installation)
* [Usage](#usage)
* [What's included](#whats-included)
* [Documentation](#documentation)
* [Changelog](#changelog)
* [Frameworks](#frameworks)
* [Templates](#templates)
* [Versioning](#versioning)
* [Contributing](#contributing)
* [Creators](#creators)
* [Community](#community)
* [Support CoreUI Development](#support-coreui-development)
* [Copyright and license](#copyright-and-license)

## Template

* [CoreUI Free Angular Admin Template](https://github.com/coreui/coreui-free-angular-admin-template)
* 💪  [CoreUI Pro Angular Admin Template](https://coreui.io/angular/)


#### Prerequisites
Before you begin, make sure your development environment includes the supported version `Typescript` as well as `Node.js®` and an `npm` package manager.

###### Typescript
Angular 20 requires `Typescript` version `>=5.9.0 <6.0.0`.

- To check your version, run `tsc -v` in a terminal/console window.
- To get `Typescript`, go to [www.typescriptlang.org](https://www.typescriptlang.org/).

###### Node.js
Angular 20 requires `Node.js` version `^20.19.0 || ^22.12.0 || ^24.0.0` or newer.

- To check your version, run `node -v` in a terminal/console window.
- To get `Node.js`, go to [nodejs.org](https://nodejs.org/).

###### Angular CLI
Install the Angular CLI globally using a terminal/console window.
```bash
npm install -g @angular/cli@20
```

##### Update to Angular 20
see: [https://angular.dev/update-guide](https://angular.dev/update-guide?v=19.0-20.0&l=3)

## Installation

Several options are available:

### Clone repo

``` bash
$ git clone https://github.com/coreui/coreui-angular.git
```

### NPM

``` bash
$ npm install @coreui/angular@2.20 --save
```

## Usage

### CSS

Import scss in `src/scss/style.scss`

```scss
// Import styles
@import "@coreui/coreui/scss/coreui";
```

Or copy-paste the stylesheet `<link>` into your `<head>` before all other stylesheets to load our CSS.

``` html
<link rel="stylesheet" href="node_modules/@coreui/coreui/dist/css/coreui.min.css">
```

## What's included

Within the download you'll find the following directories and files, logically grouping common assets and providing both compiled and minified variations. You'll see something like this:

```
coreui/
├── build/
├── dist/
├── projects/
└── src/
```

## Documentation

The documentation for the CoreUI & CoreUI PRO is hosted at our website [CoreUI for Angular](https://coreui.io/angular/docs/)

### Changelog

See the GitHub [release history](https://github.com/coreui/coreui-angular/releases).

## Frameworks

CoreUI supports most popular frameworks.

- [CoreUI for Bootstap(Vanilla JS)](https://github.com/coreui/coreui)
- [CoreUI for React](https://github.com/coreui/coreui-react)
- [CoreUI for Vue](https://github.com/coreui/coreui-vue)

## Templates

Fully featured, out-of-the-box, templates for your application based on CoreUI.

- [Angular Admin Template](https://coreui.io/angular)
- [Bootstrap Admin Template](https://coreui.io/)
- [React Admin Template](https://coreui.io/react)
- [Vue Admin Template](https://coreui.io/vue)

## Contributing

Please read through our [contributing guidelines](https://github.com/coreui/coreui-angular/blob/main/.github/CONTRIBUTING.md). Included are directions for opening issues, coding standards, and notes on development.

Editor preferences are available in the [editor config](https://github.com/coreui/coreui-angular/blob/main/.editorconfig) for easy use in common text editors. Read more and download plugins at <https://editorconfig.org/>.

## Creators

**Łukasz Holeczek**

* <https://twitter.com/lukaszholeczek>
* <https://github.com/mrholek>

**Andrzej Kopański**

* <https://github.com/xidedix>

**The CoreUI Team**

- <https://github.com/orgs/coreui/people>

## Community

Stay up to date on the development of CoreUI and reach out to the community with these helpful resources.

- Read and subscribe to [The Official CoreUI Blog](https://blog.coreui.io/).
- You can also follow [@core_ui on Twitter](https://twitter.com/core_ui).

## Support CoreUI Development

CoreUI is an MIT-licensed open source project and is completely free to use. However, the amount of effort needed to maintain and develop new features for the project is not sustainable without proper financial backing. You can support development by buying the [CoreUI PRO](https://coreui.io/pricing/) or by becoming a sponsor via [Open Collective](https://opencollective.com/coreui/).

<!--- StartOpenCollectiveBackers -->

### Platinum Sponsors

Support this project by [becoming a Platinum Sponsor](https://opencollective.com/coreui/contribute/platinum-sponsor-40959/). A large company logo will be added here with a link to your website.

<a href="https://opencollective.com/coreui/contribute/platinum-sponsor-40959/checkout"><img src="https://opencollective.com/coreui/tiers/platinum-sponsor/0/avatar.svg?avatarHeight=100"></a>

### Gold Sponsors

Support this project by [becoming a Gold Sponsor](https://opencollective.com/coreui/contribute/gold-sponsor-40960/). A big company logo will be added here with a link to your website.

<a href="https://opencollective.com/coreui/contribute/gold-sponsor-40960/checkout"><img src="https://opencollective.com/coreui/tiers/gold-sponsor/0/avatar.svg?avatarHeight=100"></a>

### Silver Sponsors

Support this project by [becoming a Silver Sponsor](https://opencollective.com/coreui/contribute/silver-sponsor-40967/). A medium company logo will be added here with a link to your website.

<a href="https://opencollective.com/coreui/contribute/silver-sponsor-40967/checkout"><img src="https://opencollective.com/coreui/tiers/gold-sponsor/0/avatar.svg?avatarHeight=100"></a>

### Bronze Sponsors

Support this project by [becoming a Bronze Sponsor](https://opencollective.com/coreui/contribute/bronze-sponsor-40966/). The company avatar will show up here with a link to your OpenCollective Profile.

<a href="https://opencollective.com/coreui/contribute/bronze-sponsor-40966/checkout"><img src="https://opencollective.com/coreui/tiers/bronze-sponsor/0/avatar.svg?avatarHeight=100"></a>

### Backers

Thanks to all the backers and sponsors! Support this project by [becoming a backer](https://opencollective.com/coreui/contribute/backer-40965/).

<a href="https://opencollective.com/coreui/contribute/backer-40965/checkout" target="_blank" rel="noopener"><img src="https://opencollective.com/coreui/backers.svg?width=890"></a>

<!--- EndOpenCollectiveBackers -->

## Copyright and license

Copyright 2025 creativeLabs Łukasz Holeczek. Code released under the [MIT License](https://github.com/coreui/coreui-angular/blob/main/LICENSE). Docs released under [Creative Commons](https://creativecommons.org/licenses/by/3.0/).
