"""
Centralized error and UI messages for Contentstack Management SDK.

This module contains all user-facing messages used throughout the SDK
to ensure consistency and easy maintenance.
"""

# General messages
REQUEST_HEADERS_INVALID = "Request headers are invalid. Provide valid headers and try again."

# Alias messages
ALIAS_UID_REQUIRED = "Alias UID is required. Provide a valid Alias UID and try again."

# Asset messages
ASSET_UID_REQUIRED = "Asset UID is required. Provide a valid Asset UID and try again."
ASSET_TYPE_REQUIRED = "Asset Type is required. Provide a valid Asset Type and try again."
ASSET_VERSION_NUMBER_REQUIRED = "Version Number is required. Provide a valid Version Number and try again."

# Audit log messages
LOG_ITEM_UID_REQUIRED = "Log Item UID is required. Provide a valid Log Item UID and try again."

# Branch messages
BRANCH_UID_REQUIRED = "Branch UID is required. Provide a valid Branch UID and try again."

# Bulk operation messages
JOB_UID_REQUIRED = "Job UID is required. Provide a valid Job UID and try again."

# Content type messages
CONTENT_TYPE_UID_REQUIRED = "Content Type UID is required. Provide a valid Content Type UID and try again."

# Delivery token messages
DELIVERY_TOKEN_UID_REQUIRED = "Delivery Token UID is required. Provide a valid Delivery Token UID and try again."

# Entry messages
ENTRY_UID_REQUIRED = "Entry UID is required. Provide a valid Entry UID and try again."
ENTRY_VERSION_NUMBER_REQUIRED = "Version Number is required. Provide a valid Version Number and try again."
ENTRY_BODY_REQUIRED = "Body is required. Provide a valid Body value and try again."
ENTRY_FILE_PATH_REQUIRED = "File Path is required. Provide a valid File Path and try again."

# Entry variant messages
ENTRY_VARIANT_CONTENT_TYPE_UID_REQUIRED = "Content Type UID is required. Provide a valid Content Type UID and try again."
ENTRY_VARIANT_ENTRY_UID_REQUIRED = "Entry UID is required. Provide a valid Entry UID and try again."
ENTRY_VARIANT_UID_REQUIRED = "Variant UID is required. Provide a valid Variant UID and try again."

# Environment messages
ENVIRONMENT_UID_REQUIRED = "Environment UID is required. Provide a valid Environment UID and try again."

# Extension messages
EXTENSION_UID_REQUIRED = "Extension UID is required. Provide a valid Extension UID and try again."

# Global field messages
GLOBAL_FIELD_UID_REQUIRED = "Global Field UID is required. Provide a valid Global Field UID and try again."

# Label messages
LABEL_UID_REQUIRED = "Label UID is required. Provide a valid Label UID and try again."

# Locale messages
LOCALE_CODE_REQUIRED = "Locale Code is required. Provide a valid Locale Code and try again."

# Management token messages
MANAGEMENT_TOKEN_UID_REQUIRED = "Management Token UID is required. Provide a valid Management Token UID and try again."

# Metadata messages
METADATA_UID_REQUIRED = "Metadata UID is required. Provide a valid Metadata UID and try again."

# OAuth messages
OAUTH_ACCESS_TOKEN_EXPIRED = "Access token expired. Refreshing the token."
OAUTH_ACCESS_TOKEN_NOT_AVAILABLE = "Access token is not available. Authenticate to continue."
OAUTH_TOKENS_NOT_AVAILABLE = "OAuth tokens are not available. Please authenticate first."
OAUTH_REFRESH_TOKEN_NOT_AVAILABLE = "Refresh token is not available. Please authenticate to get a new token."
OAUTH_NOT_CONFIGURED = "OAuth is not configured. Set up OAuth to continue."
OAUTH_AUTHORIZATION_CODE_NOT_FOUND = "Authorization code was not found in the redirect URL. Provide a valid code and try again."
OAUTH_TOKEN_EXCHANGE_FAILED = "Token exchange failed. Please try authenticating again."
OAUTH_TOKEN_REFRESH_FAILED = "Token refresh failed due to {error}. Review the error and try again."
OAUTH_BASE_URL_NOT_SET = "OAuth Base URL is not set. Provide a valid OAuth Base URL and try again."
OAUTH_AUTHORIZING = "Authorizing using app ID {app_id} and client ID {client_id}."
OAUTH_AUTHORIZATION_URL_GENERATED = "OAuth handler generated the final authorization URL at {final_url}."
OAUTH_AUTHORIZATION_URL_GENERATION_FAILED = "Authorization URL generation failed due to {error}. Review the error and try again."
OAUTH_AUTHORIZATION_CODE_EMPTY = "Authorization code is required. Provide a valid code and try again."
OAUTH_TOKEN_EXCHANGE_ERROR = "Token exchange failed due to {error}. Review the error and try again."
OAUTH_TOKEN_REFRESH_ERROR = "Token refresh failed due to {error}. Review the error and try again."
OAUTH_TOKEN_REFRESH_FAILED_AFTER_401 = "Token refresh failed after a 401 response due to {error}. Review the error and try again."
OAUTH_VISIT_URL_TO_AUTHORIZE = "Visit {auth_url} to authorize."

# Organization messages
ORGANIZATION_UID_REQUIRED = "Organization UID is required. Provide a valid Organization UID and try again."

# Publish queue messages
PUBLISH_QUEUE_UID_REQUIRED = "Publish Queue UID is required. Provide a valid Publish Queue UID and try again."

# Release messages
RELEASE_UID_REQUIRED = "Release UID is required. Provide a valid Release UID and try again."

# Role messages
ROLE_UID_REQUIRED = "Role UID is required. Provide a valid Release UID and try again."

# Stack messages
API_KEY_REQUIRED = "API Key is required. Provide a valid API Key and try again."
USER_ID_REQUIRED = "User ID is required. Provide a valid User ID and try again."
OWNERSHIP_TOKEN_REQUIRED = "Ownership Token is required. Provide a valid Ownership Token and try again."

# Taxonomy messages
TAXONOMY_UID_REQUIRED = "Taxonomy UID is required. Provide a valid Taxonomy UID and try again."

# Terms messages
TERMS_UID_REQUIRED = "Terms UID is required. Provide a valid Terms UID and try again."
TERM_STRING_REQUIRED = "Term String is required. Provide a valid Term String and try again."

# User session messages
EMAIL_ID_REQUIRED = "Email ID is required. Provide a valid Email ID and try again."
PASSWORD_REQUIRED = "Password is required. Provide a valid Password and try again."

# Variant group messages
VARIANT_GROUP_UID_REQUIRED = "Variant Group UID is required. Provide a valid Variant Group UID and try again."

# Variant messages
VARIANT_UIDS_NON_EMPTY_LIST_REQUIRED = "Variant UIDs must be a non-empty list. Provide at least one Variant UID and try again."
VARIANT_UID_REQUIRED = "Variant UID is required. Provide a valid Variant UID and try again."

# Webhook messages
WEBHOOK_UID_REQUIRED = "Webhook UID is required. Provide a valid Webhook UID and try again."
WEBHOOK_FILE_PATH_REQUIRED = "File Path is required. Provide a valid File Path and try again."
WEBHOOK_EXECUTION_UID_REQUIRED = "Execution UID is required. Provide a valid Execution UID and try again."

# Workflow messages
WORKFLOW_UID_REQUIRED = "Workflow UID is required. Provide a valid Workflow UID and try again."
WORKFLOW_CONTENT_TYPE_UID_REQUIRED = "Content Type UID is required. Provide a valid Content Type UID and try again."
WORKFLOW_ENTRY_UID_REQUIRED = "Entry UID is required. Provide a valid Entry UID and try again."
WORKFLOW_RULE_UID_REQUIRED = "Rule UID is required. Provide a valid Rule UID and try again."


