package com.coder.toolbox.views

import com.coder.toolbox.cli.CoderCLIManager
import com.coder.toolbox.sdk.v2.models.Workspace
import com.coder.toolbox.sdk.v2.models.WorkspaceAgent
import com.jetbrains.toolbox.api.remoteDev.environments.SshEnvironmentContentsView
import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo
import java.net.URL

/**
 * A view for a single environment.  It displays the projects and IDEs.
 *
 * This just delegates to the SSH view provided by Toolbox, all we have to do is
 * provide the host name.
 *
 * SSH must be configured before this will work.
 */
class EnvironmentView(
    private val url: URL,
    private val cli: CoderCLIManager,
    private val workspace: Workspace,
    private val agent: WorkspaceAgent,
) : SshEnvironmentContentsView {
    override suspend fun getConnectionInfo(): SshConnectionInfo = WorkspaceSshConnectionInfo(url, cli, workspace, agent)
}

private class WorkspaceSshConnectionInfo(
    url: URL,
    cli: CoderCLIManager,
    private val workspace: Workspace,
    private val agent: WorkspaceAgent,
) : SshConnectionInfo {
    /**
     * The host name generated by the cli manager for this workspace.
     */
    override val host: String = cli.getHostname(url, workspace, agent)

    /**
     * The port is ignored by the Coder proxy command.
     */
    override val port: Int = 22

    /**
     * The username is ignored by the Coder proxy command.
     */
    override val userName: String? = null

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as WorkspaceSshConnectionInfo

        if (port != other.port) return false
        if (workspace.name != other.workspace.name) return false
        if (agent.name != other.agent.name) return false
        if (host != other.host) return false

        return true
    }

    override fun hashCode(): Int {
        var result = port
        result = 31 * result + workspace.name.hashCode()
        result = 31 * result + agent.name.hashCode()
        result = 31 * result + host.hashCode()
        return result
    }


}