---
page_title: "codefresh_gitops_environment Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
    An environment in Codefresh GitOps is a logical grouping of one or more Kubernetes clusters and namespaces, representing a deployment context for your Argo CD applications. See official documentation https://codefresh.io/docs/gitops/environments/environments-overview/ for more information.
---

# codefresh_gitops_environment (Resource)

An environment in Codefresh GitOps is a logical grouping of one or more Kubernetes clusters and namespaces, representing a deployment context for your Argo CD applications. See [official documentation](https://codefresh.io/docs/gitops/environments/environments-overview/) for more information.

## Example Usage

```hcl
resource "codefresh_gitops_environment" "example" {
  name        = "test-gitops-env"
  kind        = "NON_PROD"

  cluster {
    name         = "test-cluster"
    server       = "https://kubernetes.default.svc"
    runtime_name = "test-runtime"
    namespaces   = ["test-ns-1", "test-ns-2"]
  }

  label_pairs = [
    "codefresh.io/environment=test-gitops-env",
    "codefresh.io/environment-1=test-gitops-env1"
  ]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `cluster` (Block List, Min: 1) (see [below for nested schema](#nestedblock--cluster))
- `kind` (String) The type of environment. Possible values: NON_PROD, PROD
- `name` (String) The name of the environment. Must be unique per account

### Optional

- `id` (String) Environment ID
- `label_pairs` (List of String) List of labels and values in the format label=value that can be used to assign applications to the environment. Example: ['codefresh.io/environment=prod']

<a id="nestedblock--cluster"></a>
### Nested Schema for `cluster`

Required:

- `name` (String) Target cluster name
- `namespaces` (List of String) List of namespaces in the target cluster
- `runtime_name` (String) Runtime name where the target cluster is registered

## Import

```sh
terraform import codefresh_gitops_environment.example <environment_id>
```
