---
page_title: "codefresh_account_gitops_settings Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Codefresh account gitops setting - such as git provider, API URL for the git provider and internal shared config repository
---

# codefresh_account_gitops_settings (Resource)

Codefresh account gitops setting - such as git provider, API URL for the git provider and internal shared config repository

## Example usage
```hcl
resource "codefresh_account_gitops_settings" "gitops-settings" {
  git_provider = "GITHUB"
  shared_config_repository = "https://github.com/example-org/codefresh-internal-shared-config.git?ref=main"
}
```
```hcl
resource "codefresh_account_gitops_settings" "gitops-settings" {
  git_provider = "BITBUCKET_SERVER"
  git_provider_api_url = https://bitbucket.example.com/rest/api/1.0
  shared_config_repository = "http://example-bitbucket.com/scm/proj/codefresh-internal-shared-config.git"
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `git_provider` (String) Git provider name - currently supported values are: GITHUB ,GERRIT ,GITLAB ,BITBUCKET ,BITBUCKET_SERVER
- `shared_config_repository` (String) Shared config repository url. Must be a valid git url which contains `.git`. May also include path and branch references

### Optional

- `git_provider_api_url` (String) Git provider API url. If not provided can automatically be set for known SaaS git providers. For example - for github it will be set to https://api.github.com

### Read-Only

- `id` (String) Account Id
- `name` (String) Account name for active account

~>
Once internal config repository is cloned successfully by one or more runtimes it can no longer be changed and all attempted updates will fail.
If you need to change the repository please contact Codefresh support.

## Import
```sh
terraform import codefresh_account_gitops_settings.test <account id>
```
