---
page_title: "codefresh_pipeline_cron_trigger Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  This resource is used to create cron-based triggers for pipeilnes.
---

# codefresh_pipeline_cron_trigger (Resource)

This resource is used to create cron-based triggers for pipeilnes.

See the [documentation](https://codefresh.io/docs/docs/configure-ci-cd-pipeline/triggers/cron-triggers/).

~> **DEPRECATED:** This resource is being deprecated in favor of the `cron_trigger` attribute of the [codefresh_pipeline](https://registry.terraform.io/providers/codefresh-io/codefresh/latest/docs/resources/pipeline) resource.

## Example usage

```hcl
resource "codefresh_project" "test" {
  name = "myproject"
}

resource "codefresh_pipeline" "test" {

  name    = "${codefresh_project.test.name}/react-sample-app"

  ...
}

resource "codefresh_pipeline_cron_trigger" "test" {
	pipeline_id =  codefresh_pipeline.test.id
	expression  = "*/1 * * * *"
	message     = "Example Cron Trigger"
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `expression` (String)
- `message` (String)
- `pipeline_id` (String)

### Read-Only

- `id` (String) The ID of this resource.