---
page_title: "codefresh_pipeline Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  The central component of the Codefresh Platform. Pipelines are workflows that contain individual steps. Each step is responsible for a specific action in the process.
---

# codefresh_pipeline (Resource)

The central component of the Codefresh Platform. Pipelines are workflows that contain individual steps. Each step is responsible for a specific action in the process.

See the [documentation](https://codefresh.io/docs/docs/configure-ci-cd-pipeline/introduction-to-codefresh-pipelines/) for the details.

~> **NOTE:** `cron_trigger` conflicts with the deprecated [codefresh_pipeline_cron_trigger](https://registry.terraform.io/providers/codefresh-io/codefresh/latest/docs/resources/pipeline_cron_trigger) resource.

~> **v1.0 Changed behavior:** Previously, `permit_restart_from_failed_steps = false` resulted in “Permit restart from failed step: Use account settings”.
From now on, setting `permit_restart_from_failed_steps = false` will result in “Permit restart from failed step: Forbid”. To keep previous behavior, set `permit_restart_from_failed_steps_use_account_settings = true`.

## Example Usage

```hcl
resource "codefresh_project" "test" {
  name = "myproject"
}

resource "codefresh_pipeline" "test" {

  lifecycle {
    ignore_changes = [
      revision
    ]
  }

  name    = "${codefresh_project.test.name}/react-sample-app"

  tags = [
    "production",
    "docker",
  ]

  spec {
    concurrency         = 1
    branch_concurrency  = 1
    trigger_concurrency = 1

    priority    = 5

    spec_template {
      repo        = "codefresh-contrib/react-sample-app"
      path        = "./codefresh.yml"
      revision    = "master"
      context     = "git"
    }

    contexts = [
      "context1-name",
      "context2-name",
    ]

    trigger {
      branch_regex  = "/.*/gi"
      context       = "git"
      description   = "Trigger for commits"
      disabled      = false
      events        = [
        "push.heads"
      ]
      modified_files_glob = ""
      name                = "commits"
      provider            = "github"
      repo                = "codefresh-contrib/react-sample-app"
      type                = "git"
    }

    trigger {
      branch_regex  = "/.*/gi"
      context       = "git"
      description   = "Trigger for tags"
      disabled      = false
      events        = [
        "push.tags"
      ]
      modified_files_glob = ""
      commit_status_title = "tags-trigger"
      name                = "tags"
      provider            = "github"
      repo                = "codefresh-contrib/react-sample-app"
      type                = "git"
    }

    variables = {
      MY_PIP_VAR      = "value"
      ANOTHER_PIP_VAR = "another_value"
    }
  }
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `name` (String) The display name for the pipeline.

### Optional

- `is_public` (Boolean) Boolean that specifies if the build logs are publicly accessible (default: `false`).
- `original_yaml_string` (String) A string with original yaml pipeline.

For example:

<code>original_yaml_string = "version: \\"1.0\\"\nsteps:\n	test:\n	image: alpine:latest\n	commands:\n	- echo \\"ACC tests\\"</code>

Or: <code>original_yaml_string = file("/path/to/my/codefresh.yml")</code>
- `spec` (Block List, Max: 1) The pipeline's specs. (see [below for nested schema](#nestedblock--spec))
- `tags` (Set of String) A list of tags to mark a project for easy management and access control.

### Read-Only

- `id` (String) The ID of this resource.
- `project_id` (String) The ID of the project that the pipeline belongs to.
- `revision` (Number) The pipeline's revision. Should be added to the **lifecycle/ignore_changes** or incremented mannually each update.

<a id="nestedblock--spec"></a>
### Nested Schema for `spec`

Optional:

- `branch_concurrency` (Number) The maximum amount of concurrent builds that may run for each branch. Zero is unlimited (default: `0`).
- `concurrency` (Number) The maximum amount of concurrent builds. Zero is unlimited (default: `0`).
- `contexts` (List of String) A list of strings representing the contexts ([shared_configuration](https://codefresh.io/docs/docs/configure-ci-cd-pipeline/shared-configuration/)) to be configured for the pipeline.
- `cron_trigger` (Block List) The pipeline's cron triggers. Conflicts with the deprecated [codefresh_pipeline_cron_trigger](https://registry.terraform.io/providers/codefresh-io/codefresh/latest/docs/resources/pipeline_cron_trigger) resource. (see [below for nested schema](#nestedblock--spec--cron_trigger))
- `encrypted_variables` (Map of String) Pipeline level encrypted variables. Please note that drift will not be detected for encrypted variables
- `external_resource` (Block List) (see [below for nested schema](#nestedblock--spec--external_resource))
- `options` (Block List, Max: 1) The options for the pipeline. (see [below for nested schema](#nestedblock--spec--options))
- `pack_id` (String) SAAS pack (`5cd1746617313f468d669013` for Small; `5cd1746717313f468d669014` for Medium; `5cd1746817313f468d669015` for Large; `5cd1746817313f468d669017` for XL; `5cd1746817313f468d669018` for XXL); `5cd1746817313f468d669020` for 4XL).
- `permit_restart_from_failed_steps` (Boolean) Defines whether it is permitted to restart builds in this pipeline from failed step (default: `true`).
- `permit_restart_from_failed_steps_use_account_settings` (Boolean) Defines whether `permit_restart_from_failed_steps` should be set to “Use account settings” (default: `false`). If set, `permit_restart_from_failed_steps` will be ignored.
- `priority` (Number) Helps to organize the order of builds execution in case of reaching the concurrency limit (default: `0`).
- `required_available_storage` (String) Minimum disk space required for build filesystem ( unit Gi is required).
- `runtime_environment` (Block List) The runtime environment for the pipeline. (see [below for nested schema](#nestedblock--spec--runtime_environment))
- `spec_template` (Block List) The pipeline's spec template. (see [below for nested schema](#nestedblock--spec--spec_template))
- `termination_policy` (Block List, Max: 1) The termination policy for the pipeline. (see [below for nested schema](#nestedblock--spec--termination_policy))
- `trigger` (Block List) The pipeline's triggers (currently the only nested trigger supported is git; for other trigger types, use the `codefresh_pipeline_*_trigger` resources). (see [below for nested schema](#nestedblock--spec--trigger))
- `trigger_concurrency` (Number) The maximum amount of concurrent builds that may run for each trigger (default: `0`).
- `variables` (Map of String) The pipeline's variables.

<a id="nestedblock--spec--cron_trigger"></a>
### Nested Schema for `spec.cron_trigger`

Required:

- `expression` (String)
- `message` (String)
- `name` (String) The name of the cron trigger.

Optional:

- `branch` (String) Branch that should be passed for build triggered by this cron trigger.
- `disabled` (Boolean) Flag to disable the trigger.
- `encrypted_variables` (Map of String) Trigger level encrypted variables. Please note that drift will not be detected for encrypted variables
- `git_trigger_id` (String) Related git-trigger id. Will by used to take all possible git information by branch.
- `options` (Block List) The trigger's options. (see [below for nested schema](#nestedblock--spec--cron_trigger--options))
- `runtime_environment` (Block List) The runtime environment for the trigger. (see [below for nested schema](#nestedblock--spec--cron_trigger--runtime_environment))
- `type` (String) The type of the trigger (default: `cron`; see notes above).
- `variables` (Map of String) Trigger variables.

<a id="nestedblock--spec--cron_trigger--options"></a>
### Nested Schema for `spec.cron_trigger.options`

Optional:

- `enable_notifications` (Boolean) If false the pipeline will not send notifications to Slack and status updates back to the Git provider.
- `no_cache` (Boolean) If true, docker layer cache is disabled.
- `no_cf_cache` (Boolean) If true, extra Codefresh caching is disabled.
- `reset_volume` (Boolean) If true, all files on volume will be deleted before each execution.


<a id="nestedblock--spec--cron_trigger--runtime_environment"></a>
### Nested Schema for `spec.cron_trigger.runtime_environment`

Optional:

- `cpu` (String) The CPU allocated to the runtime environment.
- `dind_storage` (String) The storage allocated to the runtime environment.
- `memory` (String) The memory allocated to the runtime environment.
- `name` (String) The name of the runtime environment.
- `required_available_storage` (String) Minimum disk space required for build filesystem ( unit Gi is required).



<a id="nestedblock--spec--external_resource"></a>
### Nested Schema for `spec.external_resource`

Required:

- `context` (String) Context name for the git repository
- `repo` (String) git repository url
- `revision` (String) Revision/branch in the git repository
- `source_path` (String) The source folder in the repository (use relative path)
- `target_path` (String) The target folder in the pipeline workspace where the file/folder will be copied to (use absolute path)

Optional:

- `is_folder` (Boolean) Whether or not the resource specified in source_path is a folder
- `type` (String) Type of the external resource. Currently only 'git' is supported

Read-Only:

- `id` (String)


<a id="nestedblock--spec--options"></a>
### Nested Schema for `spec.options`

Optional:

- `enable_notifications` (Boolean)
- `keep_pvcs_for_pending_approval` (Boolean) When build enters 'Pending Approval' state, volume should:
	* Default (attribute not specified): "Use Setting accounts"
	* true: "Remain (build remains active)"
	* false: "Be removed"
- `pending_approval_concurrency_applied` (Boolean) Pipeline concurrency policy: Builds on 'Pending Approval' state should be:
	* Default (attribute not specified): "Use Setting accounts"
	* true: "Included in concurrency"
	* false: "Not included in concurrency"


<a id="nestedblock--spec--runtime_environment"></a>
### Nested Schema for `spec.runtime_environment`

Optional:

- `cpu` (String) The CPU allocated to the runtime environment.
- `dind_storage` (String) The storage allocated to the runtime environment.
- `memory` (String) The memory allocated to the runtime environment.
- `name` (String) The name of the runtime environment.
- `required_available_storage` (String) Minimum disk space required for build filesystem ( unit Gi is required).


<a id="nestedblock--spec--spec_template"></a>
### Nested Schema for `spec.spec_template`

Required:

- `path` (String) The relative path to the Codefresh pipeline file.
- `repo` (String) The repository of the spec template (owner/repo).
- `revision` (String) The git revision of the spec template. Possible values: '', *name of branch*. Use '' to autoselect a branch.

Optional:

- `context` (String) The Codefresh git context (default: `github`).
- `location` (String) The location of the spec template (default: `git`).


<a id="nestedblock--spec--termination_policy"></a>
### Nested Schema for `spec.termination_policy`

Optional:

- `on_create_branch` (Block List, Max: 1) The following table presents how to configure this block based on the options available in the UI:

| Option Description                                                            | Value Selected           | on_create_branch | branch_name | ignore_trigger | ignore_branch |
| ----------------------------------------------------------------------------- |:------------------------:|:----------------:|:-----------:|---------------:| -------------:|
| Once a build is created terminate previous builds from the same branch        | Disabled                 |        Omit      |     N/A     |       N/A      |      N/A      |
| Once a build is created terminate previous builds from the same branch        | From the SAME trigger    |       Defined    |     N/A     |      false     |      N/A      |
| Once a build is created terminate previous builds from the same branch        | From ANY trigger         |       Defined    |     N/A     |      true      |      N/A      |
| Once a build is created terminate previous builds only from a specific branch | Disabled                 |        Omit      |     N/A     |       N/A      |      N/A      |
| Once a build is created terminate previous builds only from a specific branch | From the SAME trigger    |       Defined    |    Regex    |      false     |      N/A      |
| Once a build is created terminate previous builds only from a specific branch | From ANY trigger         |       Defined    |    Regex    |      true      |      N/A      |
| Once a build is created, terminate all other running builds                   | Disabled                 |        Omit      |     N/A     |       N/A      |      N/A      |
| Once a build is created, terminate all other running builds                   | From the SAME trigger    |       Defined    |     N/A     |      false     |      true     |
| Once a build is created, terminate all other running builds                   | From ANY trigger         |       Defined    |     N/A     |      true      |      true     | (see [below for nested schema](#nestedblock--spec--termination_policy--on_create_branch))
- `on_terminate_annotation` (Boolean) Enables the policy `Once a build is terminated, terminate all child builds initiated from it`.

<a id="nestedblock--spec--termination_policy--on_create_branch"></a>
### Nested Schema for `spec.termination_policy.on_create_branch`

Optional:

- `branch_name` (String) A regular expression to filter the branches on with the termination policy applies.
- `ignore_branch` (Boolean) Whether to ignore the branch.
- `ignore_trigger` (Boolean) Whether to ignore the trigger.



<a id="nestedblock--spec--trigger"></a>
### Nested Schema for `spec.trigger`

Optional:

- `branch_regex` (String) A regular expression and will only trigger for branches that match this naming pattern (default: `/.*/gi`).
- `branch_regex_input` (String) Flag to manage how the `branch_regex` field is interpreted. Possible values: `multiselect-exclude`, `multiselect`, `regex` (default: `regex`).
- `comment_regex` (String) A regular expression and will only trigger for pull requests where a comment matches this naming pattern (default: `/.*/gi`).
- `commit_status_title` (String) The commit status title pushed to the git provider.
- `context` (String) The Codefresh git context.
- `contexts` (List of String) A list of strings representing the contexts ([shared_configuration](https://codefresh.io/docs/docs/configure-ci-cd-pipeline/shared-configuration/)) to be loaded when the trigger is executed.
- `description` (String) The description of the trigger.
- `disabled` (Boolean) Flag to disable the trigger.
- `encrypted_variables` (Map of String) Trigger level encrypted variables. Please note that drift will not be detected for encrypted variables
- `events` (List of String) A list of GitHub events for which a Pipeline is triggered.
- `modified_files_glob` (String) Allows to constrain the build and trigger it only if the modified files from the commit match this glob expression (default: `""`).
- `name` (String) The name of the trigger.
- `options` (Block List) The trigger's options. (see [below for nested schema](#nestedblock--spec--trigger--options))
- `provider` (String) The git provider tied to the trigger.
- `pull_request_allow_fork_events` (Boolean) If this trigger is also applicable to git forks.
- `pull_request_target_branch_regex` (String) A regular expression and will only trigger for pull requests to branches that match this naming pattern.
- `repo` (String) The repository name, (owner/repo)
- `runtime_environment` (Block List) The runtime environment for the trigger. (see [below for nested schema](#nestedblock--spec--trigger--runtime_environment))
- `type` (String) The type of the trigger (default: `git`; see notes above).
- `variables` (Map of String) Trigger variables.

<a id="nestedblock--spec--trigger--options"></a>
### Nested Schema for `spec.trigger.options`

Optional:

- `enable_notifications` (Boolean) If false the pipeline will not send notifications to Slack and status updates back to the Git provider.
- `no_cache` (Boolean) If true, docker layer cache is disabled
- `no_cf_cache` (Boolean) If true, extra Codefresh caching is disabled.
- `reset_volume` (Boolean) If true, all files on volume will be deleted before each execution.


<a id="nestedblock--spec--trigger--runtime_environment"></a>
### Nested Schema for `spec.trigger.runtime_environment`

Optional:

- `cpu` (String) The CPU allocated to the runtime environment.
- `dind_storage` (String) The storage allocated to the runtime environment.
- `memory` (String) The memory allocated to the runtime environment.
- `name` (String) The name of the runtime environment.
- `required_available_storage` (String) Minimum disk space required for build filesystem ( unit Gi is required).

## Import

```sh
terraform import codefresh_pipeline.test xxxxxxxxxxxxxxxxxxx
```
