---
page_title: "codefresh_account_admins Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Use this resource to set a list of admins for any account. Requires a Codefresh admin token and applies only to Codefresh on-premises installations.
---

# codefresh_account_admins (Resource)

Use this resource to set a list of admins for any account. Requires a Codefresh admin token and applies only to Codefresh on-premises installations.

## Example usage

#### Example 1

```hcl
resource "codefresh_account_admins" "test" {

  account_id = <ACCOUNT ID>

  users = [
    <USER ID>,
  ]
}
```

#### Example 2

```hcl
resource "codefresh_account" "test" {

  name = "mynewaccount"

  limits {
    collaborators = 25
    data_retention_weeks = 5
  }

  build {
    parallel = 2
  }

}

data "codefresh_user" "admin" {
  email = "<EXISTING USER EMAIL>"
}

resource "codefresh_account_admins" "test" {

  account_id = codefresh_account.test.id

  users = [
    data.codefresh_user.admin.user_id
  ]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `account_id` (String) The account ID for which to set up the list of admins.
- `users` (Set of String) A list of users to set up as account admins.

### Read-Only

- `id` (String) The ID of this resource.

## Import

```sh
terraform import codefresh_account_admins.test xxxxxxxxxxxxxxxxxxx
```