---
page_title: "codefresh_idp_accounts Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  This resource adds the list of provided account IDs to the IDP.
  Because of the current Codefresh API limitation it's impossible to remove account from IDP, thus deletion is not supported.
---

# codefresh_idp_accounts (Resource)

This resource adds the list of provided account IDs to the IDP.
Because of the current Codefresh API limitation it's impossible to remove account from IDP, thus deletion is not supported.

## Example usage

```hcl
resource "codefresh_account" "test" {
  name = "<MY ACCOUNT NAME>"
}

resource "codefresh_idp_accounts" "test" {

  idp = "azure"

  accounts = [
    codefresh_account.test.id,
    "<ANY ACCOUNT ID>"
  ]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `account_ids` (Set of String) A list of account IDs to add to the IdP.
- `idp_id` (String) The IdP name.

### Read-Only

- `id` (String) The ID of this resource.

## Import

```sh
terraform import codefresh_idp_accounts.test xxxxxxxxxxxxxxxxxxx
```
