---
page_title: "codefresh_user Data Source - terraform-provider-codefresh"
subcategory: ""
description: |-
  This data source retrieves a user by email. Requires a Codefresh admin token and applies only to Codefresh on-premises installations.
---

# codefresh_user (Data Source)

This data source retrieves a user by email. Requires a Codefresh admin token and applies only to Codefresh on-premises installations.

## Example usage

```hcl
data "codefresh_user" "admin" {
  email = "admin@codefresh.io"
}

resource "codefresh_team" "admins" {

  name = "testsuperteam123"

  users = [
    data.codefresh_user.admin.user_id,
    "<ANY USER ID>",
  ]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `email` (String)

### Read-Only

- `id` (String) The ID of this resource.
- `logins` (List of Object) (see [below for nested schema](#nestedatt--logins))
- `personal` (List of Object) (see [below for nested schema](#nestedatt--personal))
- `roles` (Set of String)
- `short_profile` (List of Object) (see [below for nested schema](#nestedatt--short_profile))
- `status` (String)
- `user_id` (String)
- `user_name` (String)

<a id="nestedatt--logins"></a>
### Nested Schema for `logins`

Read-Only:

- `credentials` (List of Object) (see [below for nested schema](#nestedobjatt--logins--credentials))
- `idp` (List of Object) (see [below for nested schema](#nestedobjatt--logins--idp))

<a id="nestedobjatt--logins--credentials"></a>
### Nested Schema for `logins.credentials`

Read-Only:

- `permissions` (Set of String)


<a id="nestedobjatt--logins--idp"></a>
### Nested Schema for `logins.idp`

Read-Only:

- `client_type` (String)
- `id` (String)



<a id="nestedatt--personal"></a>
### Nested Schema for `personal`

Read-Only:

- `company_name` (String)
- `country` (String)
- `first_name` (String)
- `last_name` (String)
- `phone_number` (String)


<a id="nestedatt--short_profile"></a>
### Nested Schema for `short_profile`

Read-Only:

- `user_name` (String)