---
page_title: "codefresh_service_account Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  A service account is an identity that provides automated processes, applications, and services with the necessary permissions to interact securely with the Codefresh platform
---

# codefresh_service_account (Resource)

A service account is an identity that provides automated processes, applications, and services with the necessary permissions to interact securely with the Codefresh platform

For more information about service accounts in Codefresh see [official documentation](https://codefresh.io/docs/docs/administration/account-user-management/service-accounts).

It is also possible to generate API tokens for service accounts, see the documentation for `codefresh_api_key` resource for usage example.

## Example Usage

```hcl
data "codefresh_team" "serviceaccounts" {
  name = "service-accounts"
}

resource "codefresh_service_account" "example" {
    name = "tf-test1"
    assign_admin_role = true
    assigned_teams = [data.codefresh_team.serviceaccounts.id]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `name` (String) Service account display name

### Optional

- `assign_admin_role` (Boolean) Whether or not to assign account admin role to the service account
- `assigned_teams` (Set of String) A list of team IDs the service account is be assigned to

### Read-Only

- `id` (String) The ID of this resource.

## Import

```sh
terraform import codefresh_service_account.test xxxxxxxxxxxxxxxxxxx
```
