---
page_title: "codefresh_permission Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Permissions are used to set up access control and define which teams have access to which clusters and pipelines based on tags.
---

# codefresh_permission (Resource)

Permissions are used to set up access control and define which teams have access to which clusters and pipelines based on tags.

See the [Access Control documentation](https://codefresh.io/docs/docs/administration/account-user-management/access-control/).

## Example usage

```hcl
resource "codefresh_team" "developers" {
  name = "developers"

  users = [
      "5efc3cb6355c6647041b6e49",
      "59009221c102763beda7cf04"
    ]
}

resource "codefresh_permission" "developers" {

  team = codefresh_team.developers.id
  resource = "pipeline"
  action = "run"
  tags = [
      "demo",
      "test"
    ]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `action` (String) Action to be allowed. Possible values:
	* create
	* read (For runtime-environment resource, 'read' means 'assign')
	* update
	* delete
	* run (Only valid for pipeline resource)
	* approve (Only valid for pipeline resource)
	* debug (Only valid for pipeline resource)
- `resource` (String) The type of resources the permission applies to. Possible values:
	* pipeline
	* cluster
	* project
	* runtime-environment
- `team` (String) The Id of the team the permissions apply to.

### Optional

- `_id` (String) The permission ID.
- `related_resource` (String) Specifies the resource to use when evaluating the tags. Possible values:
	* project
- `tags` (Set of String) The tags for which to apply the permission. Supports two custom tags:
	* untagged:  Apply to all resources without tags
  * (asterisk): Apply to all resources with any tag

### Read-Only

- `id` (String) The ID of this resource.