---
page_title: "codefresh_account_user_association Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Associates a user with the account which the provider is authenticated against. If the user is not present in the system, an invitation will be sent to the specified email address.
---

# codefresh_account_user_association (Resource)

Associates a user with the account which the provider is authenticated against. If the user is not present in the system, an invitation will be sent to the specified email address.

See the [documentation](https://codefresh.io/docs/docs/administration/account-user-management/add-users/#users-in-codefresh).

## Example usage

```hcl
locals {
	users = {
		ed = {
			email = "ed@rethink.io",
			admin = true,	
		}
		edd = {
			email = "edd@rethink.io",
			admin = true,	
		}
		eddy = {
			email = "eddy@rethink.io",
			admin = false,	
		}
	}
}

resource "codefresh_account_user_association" "users" {
	for_each = local.users,
	email 	 = each.value.email,
	admin 	 = each.value.admin,
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `email` (String) The email of the user to associate with the specified account.
				If the user is not present in the system, an invitation will be sent to this email.
				This field can only be changed when 'status' is 'pending'.

### Optional

- `admin` (Boolean) Whether to make this user an account admin.

### Read-Only

- `id` (String) The ID of this resource.
- `status` (String) The status of the association.
- `username` (String) The username of the associated user.

## Import

An existing account user association can be imported via the user ID:

```sh
terraform import codefresh_account_user_association.test_user xxxxxxxxxxxxxxxxxxx
```