---
page_title: "codefresh_step_types Data Source - terraform-provider-codefresh"
subcategory: ""
description: |-
  This data source allows to retrieve the published versions of step-types.
---

# codefresh_step_types (Data Source)

This data source allows to retrieve the published versions of step-types.

## Example Usage

```hcl
data "codefresh_step_types" "freestyle" {
    name = "freestyle"
}

local {
  freestyle_map = { for step_definition in data.codefresh_step_types.freestyle.version: step_definition.version_number => step_definition }
}

output "test" {
  # Value is return as YAML
  value = local.freestyle_map[keys(local.freestyle_map)[0]].version_number
}

```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `name` (String)

### Read-Only

- `id` (String) The ID of this resource.
- `version` (Set of Object) (see [below for nested schema](#nestedatt--version))

<a id="nestedatt--version"></a>
### Nested Schema for `version`

Read-Only:

- `step_types_yaml` (String)
- `version_number` (String)