---
layout: "codefresh"
page_title: "Provider: Codefresh"
sidebar_current: "docs-codefresh-index"
description: |-
  The Codefresh provider is used to manage Codefresh resources.
---

# Codefresh Provider

The Codefresh Provider can be used to configure [Codefresh](https://codefresh.io/) resources - pipelines, projects, accounts, etc using the [Codefresh API](https://codefresh.io/docs/docs/integrations/codefresh-api/).

## Authenticating to Codefresh

The Codefresh API requires the [authentication key](https://codefresh.io/docs/docs/integrations/codefresh-api/#authentication-instructions) to authenticate.
The key can be passed either as the provider's attribute or as environment variable - `CODEFRESH_API_KEY`.

<!-- schema generated by tfplugindocs -->
## Schema

### Optional

- `api_url` (String) The Codefresh API URL. Defaults to `https://g.codefresh.io/api`. Can also be set using the `CODEFRESH_API_URL` environment variable.
- `api_url_v2` (String) The Codefresh gitops API URL. Defaults to `https://g.codefresh.io/2.0/api/graphql`. Can also be set using the `CODEFRESH_API2_URL` environment variable.
- `token` (String) The Codefresh API token. Can also be set using the `CODEFRESH_API_KEY` environment variable.

## Managing Resources Across Different Accounts

The Codefresh API only allows one to operate with the entities in the account tied to the API Key the provider is configured for.

To be able to operate with entities in different accounts, you should create a new key in the relevant account and use providers [aliases](https://www.terraform.io/docs/configuration/providers.html#alias-multiple-provider-instances).

For example:

```hcl
provider "codefresh" {
  api_key = "..."
}
provider "codefresh" {
  api_key = "..."
  alias   = "acme-dev"
}

resource "codefresh_pipeline" "pipeline" {
  ... # Omited for brevity
}

resource "codefresh_pipeline" "pipeline-dev" {
  provider = codefresh.acme-dev
  ... # Omited for brevity
}
```
