---
page_title: "codefresh_abac_rules Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Gitops Abac Rules are used to setup access control and allow to define which teams have access to which resources based on tags and attributes.
---

# codefresh_abac_rules (Resource)

Gitops Abac Rules are used to setup access control and allow to define which teams have access to which resources based on tags and attributes.

See the [Access Control documentation](https://codefresh.io/docs/docs/administration/account-user-management/access-control/).

## Example usage

```hcl
resource "codefresh_team" "developers" {
  name = "developers"

  users = [
      "5efc3cb6355c6647041b6e49",
      "59009221c102763beda7cf04"
    ]
}

resource "codefresh_abac_rules" "app_rule" {
  entity_type = "gitopsApplications"
  teams       = [data.codefresh_team.developers.id]
  actions     = ["REFRESH", "SYNC", "TERMINATE_SYNC", "APP_ROLLBACK"]

  attribute {
    name = "LABEL"
    key = "KEY"
    value = "VALUE"
  }
}

```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `actions` (Set of String) Action to be allowed. Possible values:
	* REFRESH
	* SYNC
	* TERMINATE_SYNC
	* VIEW_POD_LOGS
	* APP_ROLLBACK
- `entity_type` (String) The type of resources the abac rules applies to. Possible values:
	* gitopsApplications
- `teams` (Set of String) The Ids of teams the abac rules apply to.

### Optional

- `attribute` (Block List) Resource attribute that need to be validated (see [below for nested schema](#nestedblock--attribute))
- `id` (String) The abac rule ID.
- `tags` (Set of String) The effective tags to apply the permission. It supports 2 custom tags:
	* untagged is a “tag” which refers to all resources that don't have any tag.
	* (the star character) means all tags.

<a id="nestedblock--attribute"></a>
### Nested Schema for `attribute`

Required:

- `name` (String)
- `value` (String)

Optional:

- `key` (String)