---
page_title: "codefresh_team Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Teams are groups of users that are used to enforce access control.
---

# codefresh_team (Resource)

Teams are groups of users that are used to enforce access control.

See the [documentation](https://codefresh.io/docs/docs/administration/access-control/).

## Example usage

```hcl
resource "codefresh_team" "developers" {

  name = "developers"

  users = [
      "5efc3cb6355c6647041b6e49",
      "59009221c102763beda7cf04"
    ]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `name` (String) The name of the team.

### Optional

- `account_id` (String) The account id where to create the team.
- `tags` (Set of String) The tags of the team.
- `type` (String) The type of the team. Possible values:
	* __default__
	* __admin__
- `users` (Set of String) A list of user IDs that should be in the team.

### Read-Only

- `id` (String) The ID of this resource.