---
page_title: "codefresh_api_key Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Manages an API Key tied to an Account and a User.
---

# codefresh_api_key (Resource)

Manages an API Key tied to an Account and a User.

terraform-provider-codefresh itself uses an API key, passed as provider's attribute, but it's possible to use that API Key to generate a new one.  



## Example usage

```hcl
provider "codefresh" {
  api_url = "my API URL"
  token = "my init API token"
}

resource "codefresh_account" "test" {
  name = "my new account"
}

resource "random_string" "random" {
  length = 16
  special = false
}

resource "codefresh_api_key" "new" {
  account_id = codefresh_account.test.id
  user_id = data.codefresh_account.test_account_user.user_id
  name = "tfkey_${random_string.random.result}"

  scopes = [
    "agent",
    "agents",
    "audit",
    "build",
    "cluster",
    "clusters",
    "environments-v2",
    "github-action",
    "helm",
    "kubernetes",
    "pipeline",
    "project",
    "repos",
    "runner-installation",
    "step-type",
    "step-types",
    "view",
    "workflow",
  ]
}

provider "codefresh" {
  alias = "new_account"
  api_url = "my API URL"
  token = codefresh_api_key.new.token
}


resource "codefresh_team" "team_1" {

  provider = codefresh.new_account

  name = "team name"
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `account_id` (String) The ID of account in which the API key will be created.
- `name` (String) The display name for the API key.
- `user_id` (String) The ID of a user within the referenced `account_id` that will own the API key.

### Optional

- `scopes` (Set of String) A list of access scopes for the API key. The possible values:
	* agent
	* agents
	* audit
	* build
	* cluster
	* clusters
	* environments-v2
	* github-action
	* helm
	* kubernetes
	* pipeline
	* project
	* repos
	* runner-installation
	* step-type
	* step-types
	* view
	* workflow

### Read-Only

- `id` (String) The ID of this resource.
- `token` (String, Sensitive) The resulting API key.