---
page_title: "codefresh_account Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  By creating different accounts for different teams within the same company a customer can achieve complete segregation of assets between the teams.
---

# codefresh_account (Resource)

By creating different accounts for different teams within the same company a customer can achieve complete segregation of assets between the teams.

See the [documentation](https://codefresh.io/docs/docs/administration/account-user-management/).

## Example usage

```hcl
resource "codefresh_account" "test" {
  name = "my_account_name"

  limits {
    collaborators = 25
    data_retention_weeks = 5
  }

  build {
    parallel = 27
  }

  features = {
    OfflineLogging = true,
    ssoManagement = true,
    teamsManagement = true,
    abac = true,
    customKubernetesCluster = true,
    launchDarklyManagement = false,
  }
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `name` (String) The display name for the account.

### Optional

- `build` (Block List) Build limits for this account. (see [below for nested schema](#nestedblock--build))
- `features` (Map of Boolean) Features toggles for this account. Default:

OfflineLogging: true
ssoManagement: true
teamsManagement: true
abac: true
customKubernetesCluster: true
- `limits` (Block List) Limits for this account. (see [below for nested schema](#nestedblock--limits))

### Read-Only

- `id` (String) The ID of this resource.

<a id="nestedblock--build"></a>
### Nested Schema for `build`

Required:

- `parallel` (Number) The number of parallel builds allowed for this account.

Optional:

- `nodes` (Number) The number of nodes allowed for this account (default: `1`).


<a id="nestedblock--limits"></a>
### Nested Schema for `limits`

Required:

- `collaborators` (Number) The number of collaborators allowed for this account.

Optional:

- `data_retention_weeks` (Number) Specifies how long, in weeks, the builds be stored (default: `5`).

## Import
```sh
terraform import codefresh_account.test xxxxxxxxxxxxxxxxxxx
```