---
page_title: "codefresh_idps Data Source - terraform-provider-codefresh"
subcategory: ""
description: |-
  This data source retrieves all Identity Providers (IdPs) in the system.
---

# codefresh_idps (Data Source)

This data source retrieves all Identity Providers (IdPs) in the system.

## Example Usage

```hcl
data "codefresh_idps" "idp_azure" {
  display_name = "codefresh-onprem-tst-2"
  # client_name = "2222"
  # _id = "5df234543"
  client_type = "azure"
}

data "codefresh_idps" "local" {
  display_name = "local"
}

resource "codefresh_account" "acc" {
  name = "acc1"

  features = var.accountFeatures

  limits {
    collaborators = 25
    data_retention_weeks = 5
  }

  build {
    parallel = 25
    nodes = 7
  }

}

resource "codefresh_user" "user1" {
  email = "user1@example.com"
  user_name = "user1"

  activate = true

  roles = [
    "Admin",
    "User"
  ]

  login {
      idp_id = data.codefresh_idps.idp_azure.id
      sso = true
  }
  
  login  {
      idp_id = data.codefresh_idps.local.id
      //sso = false
  }

  personal {
    first_name = "John"
    last_name = "Smith"
  }

  accounts = [
    codefresh_account.acc.id
  ]
}

resource "codefresh_idp_accounts" "acc_idp" {
  idp_id = data.codefresh_idps.idp_azure.id
  account_ids = [codefresh_account.acc.id]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Optional

- `_id` (String)
- `client_name` (String)
- `client_type` (String)
- `display_name` (String)

### Read-Only

- `access_token` (String)
- `accounts` (Set of String)
- `app_id` (String)
- `client_host` (String)
- `client_id` (String)
- `client_secret` (String)
- `cookie_iv` (String)
- `cookie_key` (String)
- `id` (String) The ID of this resource.
- `scopes` (Set of String)
- `tenant` (String)