---
page_title: "codefresh_registry Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Registry is the configuration that Codefresh uses to push/pull container images.
---

# codefresh_registry (Resource)

Registry is the configuration that Codefresh uses to push/pull container images.

For more details see the [Codefresh Docker Registries](https://codefresh.io/docs/docs/integrations/docker-registries/)


## Concurrency Limitation 

Codefresh Registry API was not designed initially to handle concurrent modifications on `registry` entity.
Thus, you need to take one of the following approaches to avoid **errors** and **non-expected behavior**:

1) run terraform write operations with `-parallelism=1` option
```shell
terraform apply -parallelism=1
terraform destroy -parallelism=1
```

2) make each registry resource `depend_on` each other - so the CRUD operations will be performed for each registry **sequentially**
```hcl
resource "codefresh_registry" "dockerhub" {
    name = "dockerhub"
  
    spec {
        dockerhub {
          # some specific fields here
        }
    }
}

# this registry will depend on the "dockerhub" registry
resource "codefresh_registry" "gcr" {
    name = "gcr"
    
    depends_on = [codefresh_registry.dockerhub]    
    spec {
        gcr {
          # some specific fields here
        }
    }
}
```

## Supported Registry Providers

Currently, Codefresh supports the following registry providers:
* dockerhub - [Docker Hub](https://codefresh.io/docs/docs/integrations/docker-registries/docker-hub/)
* acr - [Azure Container Registry](https://codefresh.io/docs/docs/integrations/docker-registries/azure-docker-registry)
* gcr - [Google Container Registry](https://codefresh.io/docs/docs/integrations/docker-registries/google-container-registry)
* gar - [Google Artifact Registry](https://codefresh.io/docs/docs/integrations/docker-registries/google-artifact-registry)
* ecr - [Amazon EC2 Container Registry](https://codefresh.io/docs/docs/integrations/docker-registries/amazon-ec2-container-registry)
* bintray - [Bintray / Artifactory](https://codefresh.io/docs/docs/integrations/docker-registries/bintray-io)
* other - any other provider including [Quay](https://codefresh.io/docs/docs/integrations/docker-registries/quay-io) and [Github Container Registry](https://codefresh.io/docs/docs/integrations/docker-registries/github-container-registry). See the [docs](https://codefresh.io/docs/docs/integrations/docker-registries/other-registries).

### Resource Spec

Each registry resource have some common fields and specific ones stored under the `spec`. Here is the template:

```hcl
resource "codefresh_registry" "some_registry" {
    name = "some_name"
    default = false
    primary = true
    fallback_registry = codefresh_registry.some_other_registry.id
  
    spec {
        <provider_name> {
          # some specific fields here
        }
    }
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `name` (String) The display name for the registry.
- `spec` (Block List, Min: 1, Max: 1) The registry's specs. (see [below for nested schema](#nestedblock--spec))

### Optional

- `default` (Boolean) Whether this registry is the default registry (default: `false`).
- `fallback_registry` (String) The name of the fallback registry.
- `primary` (Boolean) Whether this registry is the primary registry (default: `true`).

### Read-Only

- `id` (String) The ID of this resource.
- `kind` (String) The kind of registry.

<a id="nestedblock--spec"></a>
### Nested Schema for `spec`

Optional:

- `acr` (Block List, Max: 1) An `acr` block as documented below ([Azure Container Registry](https://codefresh.io/docs/docs/integrations/docker-registries/azure-docker-registry)). (see [below for nested schema](#nestedblock--spec--acr))
- `bintray` (Block List, Max: 1) A `bintray` block as documented below ([Bintray / Artifactory](https://codefresh.io/docs/docs/integrations/docker-registries/bintray-io)). (see [below for nested schema](#nestedblock--spec--bintray))
- `dockerhub` (Block List, Max: 1) A `dockerhub` block as documented below ([Docker Hub Registry](https://codefresh.io/docs/docs/integrations/docker-registries/docker-hub/)). (see [below for nested schema](#nestedblock--spec--dockerhub))
- `ecr` (Block List, Max: 1) An `ecr` block as documented below ([Amazon EC2 Container Registry](https://codefresh.io/docs/docs/integrations/docker-registries/amazon-ec2-container-registry)). (see [below for nested schema](#nestedblock--spec--ecr))
- `gar` (Block List, Max: 1) A `gar` block as documented below ([Google Artifact Registry](https://codefresh.io/docs/docs/integrations/docker-registries/google-artifact-registry)). (see [below for nested schema](#nestedblock--spec--gar))
- `gcr` (Block List, Max: 1) [Google Container Registry](https://codefresh.io/docs/docs/integrations/docker-registries/google-container-registry). (see [below for nested schema](#nestedblock--spec--gcr))
- `other` (Block List, Max: 1) `other` provider block described below ([Other Providers](https://codefresh.io/docs/docs/integrations/docker-registries/other-registries)). (see [below for nested schema](#nestedblock--spec--other))

<a id="nestedblock--spec--acr"></a>
### Nested Schema for `spec.acr`

Required:

- `client_id` (String) The Client ID.
- `client_secret` (String, Sensitive) The Client Secret.
- `domain` (String) The ACR registry domain.

Optional:

- `repository_prefix` (String) See the [docs](https://codefresh.io/docs/docs/integrations/docker-registries/#using-an-optional-repository-prefix).


<a id="nestedblock--spec--bintray"></a>
### Nested Schema for `spec.bintray`

Required:

- `domain` (String) The Bintray domain.
- `token` (String, Sensitive) The Bintray token.
- `username` (String) The Bintray username.

Optional:

- `repository_prefix` (String) See the [docs](https://codefresh.io/docs/docs/integrations/docker-registries/#using-an-optional-repository-prefix).


<a id="nestedblock--spec--dockerhub"></a>
### Nested Schema for `spec.dockerhub`

Required:

- `password` (String, Sensitive) The DockerHub password.
- `username` (String) The DockerHub username.


<a id="nestedblock--spec--ecr"></a>
### Nested Schema for `spec.ecr`

Required:

- `access_key_id` (String) The AWS access key ID.
- `region` (String) The AWS region.
- `secret_access_key` (String, Sensitive) The AWS secret access key.

Optional:

- `repository_prefix` (String) See the [docs](https://codefresh.io/docs/docs/integrations/docker-registries/#using-an-optional-repository-prefix).


<a id="nestedblock--spec--gar"></a>
### Nested Schema for `spec.gar`

Required:

- `keyfile` (String, Sensitive) The serviceaccount json file contents.
- `location` (String) The GAR location.

Optional:

- `repository_prefix` (String) See the [docs](https://codefresh.io/docs/docs/integrations/docker-registries/#using-an-optional-repository-prefix).


<a id="nestedblock--spec--gcr"></a>
### Nested Schema for `spec.gcr`

Required:

- `domain` (String) The GCR registry domain.
- `keyfile` (String, Sensitive) The serviceaccount json file contents.

Optional:

- `repository_prefix` (String) See the [docs](https://codefresh.io/docs/docs/integrations/docker-registries/#using-an-optional-repository-prefix).


<a id="nestedblock--spec--other"></a>
### Nested Schema for `spec.other`

Required:

- `domain` (String) The domain.
- `password` (String, Sensitive) The password.
- `username` (String) The username.

Optional:

- `behind_firewall` (Boolean) See the [docs](https://codefresh.io/docs/docs/administration/behind-the-firewall/#accessing-an-internal-docker-registry).
- `repository_prefix` (String) See the [docs](https://codefresh.io/docs/docs/integrations/docker-registries/#using-an-optional-repository-prefix).

```sh
terraform import codefresh_registry.test xxxxxxxxxxxxxxxxxxx
```