---
page_title: "codefresh_permission Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Permission are used to setup access control and allow to define which teams have access to which clusters and pipelines based on tags.
---

# codefresh_permission (Resource)

Permission are used to setup access control and allow to define which teams have access to which clusters and pipelines based on tags.

See the [Access Control documentation](https://codefresh.io/docs/docs/administration/account-user-management/access-control/).

## Example usage

```hcl
resource "codefresh_team" "developers" {
  name = "developers"

  users = [
      "5efc3cb6355c6647041b6e49",
      "59009221c102763beda7cf04"
    ]
}

resource "codefresh_permission" "developers" {

  team = codefresh_team.developers.id
  resource = "pipeline"
  action = "run"
  tags = [
      "demo",
      "test"
    ]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `action` (String) Action to be allowed. Possible values:
	* create
	* read
	* update
	* delete
	* run (Only valid for pipeline resource)
	* approve (Only valid for pipeline resource)
	* debug (Only valid for pipeline resource)
- `resource` (String) The type of resources the permission applies to. Possible values:
	* pipeline
	* cluster
- `team` (String) The Id of the team the permissions apply to.

### Optional

- `_id` (String) The permission ID.
- `tags` (Set of String) The effective tags to apply the permission. It supports 2 custom tags:
	* untagged is a “tag” which refers to all clusters that don't have any tag.
	* (the star character) means all tags.

### Read-Only

- `id` (String) The ID of this resource.