---
page_title: "codefresh_registry Data Source - terraform-provider-codefresh"
subcategory: ""
description: |-
  This data source allows retrieving information on any existing registry.
---

# codefresh_registry (Data Source)

This data source allows retrieving information on any existing registry.

## Example Usage

```hcl
# some pre-existing registry
data "codefresh_registry" "dockerhub" {
  name = "dockerhub"
}

# example with using data reference to existing registry, not managed by terraform
# "dockerhub" registry will be used as fallback for "dockerhub1"
resource "codefresh_registry" "dockerhub1" {
  name              = "dockerhub1"
  primary           = !data.codefresh_registry.dockerhub.primary

  spec {
    dockerhub {
      username = "test"
      password = "test"
    }
  }
  fallback_registry = data.codefresh_registry.dockerhub.id
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `name` (String)

### Read-Only

- `default` (Boolean)
- `domain` (String)
- `fallback_registry` (String)
- `id` (String) The ID of this resource.
- `kind` (String)
- `primary` (Boolean)
- `registry_provider` (String)
- `repository_prefix` (String)
