---
page_title: "codefresh_current_account Data Source - terraform-provider-codefresh"
subcategory: ""
description: |-
  Returns the current account (owner of the token) and its users.
---

# codefresh_current_account (Data Source)

Returns the current account (owner of the token) and its users.

## Example Usage

```hcl
provider "codefresh" {
  api_url =  var.api_url 
  token = var.token 
}

data "codefresh_current_account" "acc" {
  
}


output "current_ac" {
  value = data.codefresh_current_account.acc
}
```

The output example: 
```
Outputs:

current_ac = {
  "_id" = "5f1fd9044d0fc94ddff0d745"
  "id" = "5f1fd9044d0fc94ddff0d745"
  "name" = "acc1"
  "users" = [
    {
      "email" = "kosta@codefresh.io"
      "id" = "5f1fd9094d0fc9c656f0d75a"
      "name" = "user1"
    },
    {
      "email" = "kosta@sysadmiral.io"
      "id" = "5f1fd9094d0fc93b52f0d75c"
      "name" = "user3"
    },
  ]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Optional

- `_id` (String)
- `name` (String)
- `users` (Block List) (see [below for nested schema](#nestedblock--users))

### Read-Only

- `id` (String) The ID of this resource.

<a id="nestedblock--users"></a>
### Nested Schema for `users`

Required:

- `email` (String)
- `name` (String)

Read-Only:

- `id` (String) The ID of this resource.