---
page_title: "codefresh_context Data Source - terraform-provider-codefresh"
subcategory: ""
description: |-
  This data source allows to retrieve information on any defined context.
---

# codefresh_context (Data Source)

This data source allows to retrieve information on any defined context.

## Example Usage

```hcl
# Assuming runtimes-list is a context of type "config" with the following values
# runtime_a: dev
# runtime_b: test
# runtime_c: prod

data "codefresh_context" "runtimes_list" {
  name = "runtimes-list"
}

resource "codefresh_project" "test" {
  name = "myproject"
}

resource "codefresh_pipeline" "test" {

  lifecycle {
    ignore_changes = [
      revision
    ]
  }

  name    = "${codefresh_project.test.name}/react-sample-app"

  runtime_environment {
    name = yamldecode(data.codefresh_context.runtimes_list.data).runtime_a
  }

  spec {

    spec_template {
      repo        = "codefresh-contrib/react-sample-app"
      path        = "./codefresh.yml"
      revision    = "master"
      context     = "git"
    }
  }
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `name` (String)

### Read-Only

- `data` (String)
- `id` (String) The ID of this resource.
- `type` (String)