---
page_title: "codefresh_context Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  A Context is an authentication/configuration resource used by the Codefresh system and engine.
---

# codefresh_context (Resource)

A Context is an authentication/configuration resource used by the Codefresh system and engine.

## Supported types

Codefresh supports multiple types of Contexts, all of which share the following components:

* `Name`: A unique identifier for the context
* `Type`: A string representing the type of context
* `Data`: A data structure that provides the information related to the Context. This differs based on the type of Context selected.

For more details of the Context spec, please refer to the [official Codefresh CLI documentation](https://codefresh-io.github.io/cli/contexts/spec/)

Currently the provider supports the following types of Context:

* `config` (Shared Config)
* `secret` (Shared Secret)
* `yaml` (YAML Configuration Context)
* `secret-yaml` (Secret YAML Configuration Context)

### Shared Configuration
A Shared Configuration is the entity in Codefresh where you can create values in a centralized location, and then consume in pipelines to keep them [DRY](https://en.wikipedia.org/wiki/Don%27t_repeat_yourself).
More details in the official [Shared Configuration documentation](https://codefresh.io/docs/docs/configure-ci-cd-pipeline/shared-configuration/)

### Example Usage

#### Shared Config

```hcl
resource "codefresh_context" "test-config" {
    name = "my-shared-config"
    spec {
        config {
            data = {
                var1 = "value1"
                var2 = "value2"
            }
        }
    }
}
```

#### Shared Secret

```hcl
resource "codefresh_context" "test-secret" {
    name = "my-shared-secret"
    spec {
        secret {
            data = {
                var1 = "value1"
                var2 = "value2"
            }
        }
    }
}
```

#### YAML Configuration Context

```hcl
resource "codefresh_context" "test-yaml" {
    name = "my-shared-yaml"
    spec {
        # NOTE: you can also load the yaml from a file with `yaml = file("PATH-TO-FILE.yaml")`
        yaml = <<YAML
test:
  nested_value: value1
  list:
    - test2
    - test3
another_element: value
YAML
    }
}
```

#### Secret YAML Configuration Context

```hcl
resource "codefresh_context" "test-secret-yaml" {
    name = "my-shared-secret-yaml"
    decrypt_spec = false
    spec {
        # NOTE: The `-` from secret-yaml is stripped because the character is not allowed in Field name
        # File passed MUST be a valid YAML
        secretyaml = file("test.yaml")
    }
}
```

#### AWS S3 storage context

```hcl
resource "codefresh_context" "test-s3" {
    name = "my-s3-context"

    decrypt_spec = false

    spec {
        storages3 {
            data {
                auth {
                    type = "basic"
                    json_config = {accessKeyId = "key", secretAccessKey = "secret"}
                }
            }
        }
    }
}
```

#### Azure file storage context

```hcl
resource "codefresh_context" "test-azure" {
    name = "my-azure-file-context"

    decrypt_spec = false

    spec {
        storageazuref {
            data {
                auth {
                    type = "basic"
                    account_name = "account"
                    account_key = "key"
                }
            }
        }
    }
}
```

#### Google cloud storage context

```hcl
resource "codefresh_context" "test-google-cloud-storage" {
    name = "my-gcs-context"

    spec {
        storagegc {
            data {
                auth {
                    type = "basic"
                    json_config  = jsondecode(<<EOF
                    {
                    "type": "service_account",
                    "project_id": "PROJECT_ID",
                    "private_key_id": "KEY_ID",
                    "private_key": "-----BEGIN PRIVATE KEY-----\nPRIVATE_KEY\n-----END PRIVATE KEY-----\n",
                    "client_email": "SERVICE_ACCOUNT_EMAIL",
                    "client_id": "CLIENT_ID",
                    "auth_uri": "https://accounts.google.com/o/oauth2/auth",
                    "token_uri": "https://accounts.google.com/o/oauth2/token",
                    "auth_provider_x509_cert_url": "https://www.googleapis.com/oauth2/v1/certs",
                    "client_x509_cert_url": "https://www.googleapis.com/robot/v1/metadata/x509/SERVICE_ACCOUNT_EMAIL"
                    }
                    EOF
                    )
                }
            }
        }
    }
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `name` (String) The display name for the context.
- `spec` (Block List, Min: 1, Max: 1) The context's specs. (see [below for nested schema](#nestedblock--spec))

### Read-Only

- `id` (String) The ID of this resource.

<a id="nestedblock--spec"></a>
### Nested Schema for `spec`

Optional:

- `config` (Block List, Max: 1) (see [below for nested schema](#nestedblock--spec--config))
- `secret` (Block List, Max: 1) (see [below for nested schema](#nestedblock--spec--secret))
- `secretyaml` (Block List, Max: 1) (see [below for nested schema](#nestedblock--spec--secretyaml))
- `storageazuref` (Block List, Max: 1) (see [below for nested schema](#nestedblock--spec--storageazuref))
- `storagegc` (Block List, Max: 1) (see [below for nested schema](#nestedblock--spec--storagegc))
- `storages3` (Block List, Max: 1) (see [below for nested schema](#nestedblock--spec--storages3))
- `yaml` (Block List, Max: 1) (see [below for nested schema](#nestedblock--spec--yaml))

<a id="nestedblock--spec--config"></a>
### Nested Schema for `spec.config`

Required:

- `data` (Map of String) The map of variables representing the shared config.


<a id="nestedblock--spec--secret"></a>
### Nested Schema for `spec.secret`

Required:

- `data` (Map of String, Sensitive) The map of variables representing the shared config (secret).


<a id="nestedblock--spec--secretyaml"></a>
### Nested Schema for `spec.secretyaml`

Required:

- `data` (String, Sensitive) The YAML string representing the shared config (secret).


<a id="nestedblock--spec--storageazuref"></a>
### Nested Schema for `spec.storageazuref`

Required:

- `data` (Block List, Min: 1, Max: 1) (see [below for nested schema](#nestedblock--spec--storageazuref--data))

<a id="nestedblock--spec--storageazuref--data"></a>
### Nested Schema for `spec.storageazuref.data`

Required:

- `auth` (Block List, Min: 1, Max: 1) (see [below for nested schema](#nestedblock--spec--storageazuref--data--auth))

<a id="nestedblock--spec--storageazuref--data--auth"></a>
### Nested Schema for `spec.storageazuref.data.auth`

Required:

- `account_key` (String)
- `account_name` (String)
- `type` (String)




<a id="nestedblock--spec--storagegc"></a>
### Nested Schema for `spec.storagegc`

Required:

- `data` (Block List, Min: 1, Max: 1) (see [below for nested schema](#nestedblock--spec--storagegc--data))

<a id="nestedblock--spec--storagegc--data"></a>
### Nested Schema for `spec.storagegc.data`

Required:

- `auth` (Block List, Min: 1, Max: 1) (see [below for nested schema](#nestedblock--spec--storagegc--data--auth))

<a id="nestedblock--spec--storagegc--data--auth"></a>
### Nested Schema for `spec.storagegc.data.auth`

Required:

- `json_config` (Map of String)
- `type` (String)




<a id="nestedblock--spec--storages3"></a>
### Nested Schema for `spec.storages3`

Required:

- `data` (Block List, Min: 1, Max: 1) (see [below for nested schema](#nestedblock--spec--storages3--data))

<a id="nestedblock--spec--storages3--data"></a>
### Nested Schema for `spec.storages3.data`

Required:

- `auth` (Block List, Min: 1, Max: 1) (see [below for nested schema](#nestedblock--spec--storages3--data--auth))

<a id="nestedblock--spec--storages3--data--auth"></a>
### Nested Schema for `spec.storages3.data.auth`

Required:

- `json_config` (Map of String)
- `type` (String)




<a id="nestedblock--spec--yaml"></a>
### Nested Schema for `spec.yaml`

Required:

- `data` (String) The YAML string representing the shared config.
