---
page_title: "codefresh_api_key Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Manages an API Key tied to a user within an account or a service account within the current account.
      On the Codefresh SaaS platfrom this resource is only usable for service accounts.
      Management of API keys for users in other accounts requires admin priveleges and hence can only be done on Codefresh on-premises installations.
---

# codefresh_api_key (Resource)

Manages an API Key tied to a user within an account or a service account within the current account.
		On the Codefresh SaaS platfrom this resource is only usable for service accounts.
		Management of API keys for users in other accounts requires admin priveleges and hence can only be done on Codefresh on-premises installations.

terraform-provider-codefresh itself uses an API key, passed as provider's attribute, but it's possible to use that API Key to generate a new one.

## Example usage

### With service accounts

```hcl
provider "codefresh" {
  api_url = "my API URL"
  token = "my init API token"
}

resource "codefresh_service_account" "example" {
    name = "example-service-account"
}

resource "codefresh_api_key" "example" {
  service_account_id = codefresh_service_account.example.id
  name = "example-token"
  scopes = [
    "project"
  ]
}

provider "codefresh" {
  alias = "project_creator_sa"
  api_url = "my API URL"
  token = codefresh_api_key.example.token
}

resource "codefresh_project" "example" {

  provider = codefresh.project_creator_sa

  name = "myproject"

  tags = [
    "team_1"
  ]
}
```

### With user and account combination (on-premise only)
```hcl
provider "codefresh" {
  api_url = "my API URL"
  token = "my init API token"
}

resource "codefresh_account" "test" {
  name = "my new account"
}

resource "random_string" "random" {
  length = 16
  special = false
}

resource "codefresh_api_key" "new" {
  account_id = codefresh_account.test.id
  user_id = data.codefresh_account.test_account_user.user_id
  name = "tfkey_${random_string.random.result}"

  scopes = [
    "agent",
    "agents",
    "audit",
    "build",
    "cluster",
    "clusters",
    "environments-v2",
    "github-action",
    "helm",
    "kubernetes",
    "pipeline",
    "project",
    "repos",
    "runner-installation",
    "step-type",
    "step-types",
    "view",
    "workflow",
  ]
}

provider "codefresh" {
  alias = "new_account"
  api_url = "my API URL"
  token = codefresh_api_key.new.token
}


resource "codefresh_team" "team_1" {

  provider = codefresh.new_account

  name = "team name"
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `name` (String) The display name for the API key.

### Optional

- `account_id` (String) The ID of account in which the API key will be created. Required if user_id is set.
- `scopes` (Set of String) A list of access scopes for the API key. The possible values:
	* agent
	* agents
	* audit
	* build
	* cluster
	* clusters
	* environments-v2
	* github-action
	* helm
	* kubernetes
	* pipeline
	* project
	* repos
	* runner-installation
	* step-type
	* step-types
	* view
	* workflow
- `service_account_id` (String) The ID of the service account to create the API key for.
- `user_id` (String) The ID of a user within the referenced `account_id` that will own the API key. Requires a Codefresh admin token and can be used only in Codefresh on-premises installations.

### Read-Only

- `id` (String) The ID of this resource.
- `token` (String, Sensitive) The resulting API key.
