---
page_title: "codefresh_account Data Source - terraform-provider-codefresh"
subcategory: ""
description: |-
  This data source retrieves an account by _id or name. Requires a Codefresh admin token and applies only to Codefresh on-premises installations.
---

# codefresh_account (Data Source)

This data source retrieves an account by _id or name. Requires a Codefresh admin token and applies only to Codefresh on-premises installations.

## Example Usage

```hcl
data "codefresh_account" "acc" {
  name = "acc1"
}

resource "codefresh_user" "user1" {
  email = "user1@example.com"
  user_name = "user1"

  accounts = [
    data.codefresh_account.acc.id
  ]

  activate = true

  roles = [
    "Admin",
    "User"
  ]

  login {
      idp_id = data.codefresh_idps.idp_azure.id
      sso = true
  }
  
  login  {
      idp_id = data.codefresh_idps.local.id
      //sso = false
  }


  personal {
    first_name = "John"
    last_name = "Smith"
  }
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Optional

- `_id` (String)
- `admins` (List of String)
- `name` (String)

### Read-Only

- `id` (String) The ID of this resource.