---
page_title: "codefresh_abac_rules Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  Gitops ABAC Rules are used to setup access control and allow to define which teams have access to which resources based on tags and attributes.
---

# codefresh_abac_rules (Resource)

Gitops ABAC Rules are used to setup access control and allow to define which teams have access to which resources based on tags and attributes.

See the [GitOps Access Control documentation](https://codefresh.io/docs/docs/administration/account-user-management/gitops-abac/).

## Example usage

```hcl
resource "codefresh_team" "developers" {
  name = "developers"

  users = [
      "5efc3cb6355c6647041b6e49",
      "59009221c102763beda7cf04"
    ]
}

resource "codefresh_abac_rules" "app_rule" {
  entity_type = "gitopsApplications"
  teams       = [data.codefresh_team.developers.id]
  actions     = ["REFRESH", "SYNC", "TERMINATE_SYNC", "APP_ROLLBACK"]

  attribute {
    name = "LABEL"
    key = "KEY"
    value = "VALUE"
  }
}

```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `actions` (Set of String) Action to be allowed. Possible values:
	* REFRESH
	* SYNC
	* TERMINATE_SYNC
	* VIEW_POD_LOGS
	* APP_ROLLBACK
	* TRIGGER_PROMOTION
	* RETRY_RELEASE
	* PROMOTE_TO
- `entity_type` (String) The type of resources the ABAC rules applies to. Possible values:
	* gitopsApplications
	* promotionFlows
	* products
	* environments
- `teams` (Set of String) The IDs of the teams the ABAC rules apply to.

### Optional

- `attribute` (Block List) Resource attribute that need to be validated (see [below for nested schema](#nestedblock--attribute))
- `id` (String) The abac rule ID.
- `tags` (Set of String) The effective tags of the resource to apply the permission to. There are two special tags:
	* untagged: Apply to all resources without tags.
	* * (asterisk): Apply to all resources with any tag.

<a id="nestedblock--attribute"></a>
### Nested Schema for `attribute`

Required:

- `name` (String)
- `value` (String)

Optional:

- `key` (String)
