---
page_title: "codefresh_team Data Source - terraform-provider-codefresh"
subcategory: ""
description: |-
  This data source retrieves a team by its ID or name.
---

# codefresh_team (Data Source)

This data source retrieves a team by its ID or name.

## Example Usage

```hcl
data "codefresh_team" "admin" {
  provider = codefresh.acc1
  name = "users"
}

resource "codefresh_permission" "permission2" {
  provider = codefresh.acc1
  team = data.codefresh_team.admin.id
  action = "create"
  resource = "pipeline"
  tags = ["frontend"]
}

```

<!-- schema generated by tfplugindocs -->
## Schema

### Optional

- `_id` (String)
- `account_id` (String)
- `name` (String)
- `tags` (List of String)
- `type` (String)
- `users` (List of String)

### Read-Only

- `id` (String) The ID of this resource.