---
page_title: "codefresh_user Resource - terraform-provider-codefresh"
subcategory: ""
description: |-
  This resource is used to manage a Codefresh user.
---

# codefresh_user (Resource)

This resource is used to manage a Codefresh user.



## Example usage

```hcl
resource "codefresh_account" "test" {

  name = "mynewaccount"

  limits {
    collaborators = 25
    data_retention_weeks = 5
  }

  build {
    parallel = 2
  }
}

resource "codefresh_user" "new" {
  email = "<EMAIL>"
  user_name = "<USER>"

  activate = true

  roles = [
    "Admin",
    "User"
  ]

  login {
      idp_id = data.codefresh_idps.idp_azure.id
      sso = true
  }
  
  login  {
      idp_id = data.codefresh_idps.local.id
      //sso = false
  }


  personal {
    first_name = "John"
    last_name = "Smith"
  }

  accounts = [
    codefresh_account.test.id,
    "59009117c102763beda7ce71",
  ]
}
```

<!-- schema generated by tfplugindocs -->
## Schema

### Required

- `accounts` (Set of String) A list of accounts IDs to assign the user to.
- `email` (String) The email of the user.
- `user_name` (String) The username of the user.

### Optional

- `activate` (Boolean) Whether to activate the user or to leave it as `pending`.
- `login` (Block Set) Login settings for the user. (see [below for nested schema](#nestedblock--login))
- `password` (String, Sensitive) Password - for users without SSO.
- `personal` (Block List, Max: 1) Personal information about the user. (see [below for nested schema](#nestedblock--personal))
- `roles` (Set of String) The roles of the user.

### Read-Only

- `has_password` (Boolean) Whether the user has a local password.
- `id` (String) The ID of this resource.
- `short_profile` (List of Object) The computed short profile of the user. (see [below for nested schema](#nestedatt--short_profile))
- `status` (String) The status of the user (e.g. `new`, `pending`).

<a id="nestedblock--login"></a>
### Nested Schema for `login`

Optional:

- `idp_id` (String) The IdP ID for the user's login.
- `sso` (Boolean) Whether to enforce SSO for the user.


<a id="nestedblock--personal"></a>
### Nested Schema for `personal`

Optional:

- `company_name` (String) The company name of the user.
- `country` (String) The country of the user.
- `first_name` (String) The first name of the user.
- `last_name` (String) The last name of the user.
- `phone_number` (String) The phone number of the user.


<a id="nestedatt--short_profile"></a>
### Nested Schema for `short_profile`

Read-Only:

- `user_name` (String)

## Import

```sh
terraform import codefresh_user.new xxxxxxxxxxxxxxxxxxx
```

