
# Contributing
Thank you so much for your interest in contributing! All types of contributions are encouraged and valued. The Project Team looks forward to your contributions.

## Filing issues
When in doubt, file an issue. We'd rather close a few duplicate issues than let a problem go unnoticed.
Similarly, if you support a particular feature request, please let us know by commenting on the issue or [subscribing](https://help.github.com/articles/subscribing-to-conversations/) to the issue.

If you are reporting a bug, please help speed up problem diagnosis by providing as much information as possible. Ideally, that would include a small sample project (or gist) that reproduces the problem.


## Contributing code
We actively welcome your pull requests. You can find instructions on building the project in [README.md](https://github.com/canopas/rich-editor-swiftui).
1. Fork the repo and create your branch from `main`.  
2. If you've added code that should be tested, add tests  
4. Make sure your code lints.  

## Labels
Labels on issues are managed by contributors, you don't have to worry about them. Here's a list of what they mean:

 * **bug**: feature that should work, but doesn't
 * **enhancement**: minor tweak/addition to existing behaviour
 * **feature**: new behaviour, bigger than enhancement
 * **question**: no need of any fix, usually a usage problem
 * **reproducible**: has enough information to very easily reproduce, mostly in the form of a small project in a GitHub repo
 * **repro-needed**: we need some code to be able to reproduce and debug locally, otherwise there's not much we can do
 * **duplicate**: there's another issue which already covers/tracks this
 * **wontfix**: working as intended, or won't be fixed due to compatibility or other reasons
 * **invalid**: there isn't enough information to make a verdict, or unrelated
 * **non-library**: issue is not in the core library code, but rather in documentation, samples, build process, releases

 ## License
 By contributing to RichEditorSwiftUI, you agree that your contributions will be licensed under its Apache License, Version 2.0. See LICENSE file for details.
