import { HUFFMAN_EOF } from "./huffman";

export const defaultHuffmanTree = [
    { value: 0x00, codeLen: 2, code: 0x0003 }, //  11
    { value: 0x01, codeLen: 3, code: 0x0005 }, //  101
    { value: 0x02, codeLen: 4, code: 0x0009 }, //  1001
    { value: 0x03, codeLen: 5, code: 0x0011 }, //  10001
    { value: 0x04, codeLen: 5, code: 0x0010 }, //  10000
    { value: 0x50, codeLen: 5, code: 0x000f }, //  01111
    { value: 0x05, codeLen: 6, code: 0x001d }, //  011101
    { value: 0x06, codeLen: 6, code: 0x001c }, //  011100
    { value: 0x07, codeLen: 6, code: 0x001b }, //  011011
    { value: 0x08, codeLen: 6, code: 0x001a }, //  011010
    { value: 0x10, codeLen: 6, code: 0x0019 }, //  011001
    { value: 0x09, codeLen: 7, code: 0x0031 }, //  0110001
    { value: 0x0a, codeLen: 7, code: 0x0030 }, //  0110000
    { value: 0x0b, codeLen: 7, code: 0x002f }, //  0101111
    { value: 0x0c, codeLen: 7, code: 0x002e }, //  0101110
    { value: 0x0d, codeLen: 7, code: 0x002d }, //  0101101
    { value: 0x0e, codeLen: 7, code: 0x002c }, //  0101100
    { value: 0x0f, codeLen: 7, code: 0x002b }, //  0101011
    { value: 0x11, codeLen: 7, code: 0x002a }, //  0101010
    { value: 0x12, codeLen: 7, code: 0x0029 }, //  0101001
    { value: 0x13, codeLen: 8, code: 0x0051 }, //  01010001
    { value: 0x14, codeLen: 8, code: 0x0050 }, //  01010000
    { value: 0x15, codeLen: 8, code: 0x004f }, //  01001111
    { value: 0x16, codeLen: 8, code: 0x004e }, //  01001110
    { value: 0x17, codeLen: 8, code: 0x004d }, //  01001101
    { value: 0x18, codeLen: 8, code: 0x004c }, //  01001100
    { value: 0x19, codeLen: 8, code: 0x004b }, //  01001011
    { value: 0x1a, codeLen: 8, code: 0x004a }, //  01001010
    { value: 0x1b, codeLen: 8, code: 0x0049 }, //  01001001
    { value: 0x1c, codeLen: 8, code: 0x0048 }, //  01001000
    { value: 0x1d, codeLen: 8, code: 0x0047 }, //  01000111
    { value: 0x1e, codeLen: 8, code: 0x0046 }, //  01000110
    { value: 0x1f, codeLen: 8, code: 0x0045 }, //  01000101
    { value: 0x20, codeLen: 8, code: 0x0044 }, //  01000100
    { value: 0x21, codeLen: 8, code: 0x0043 }, //  01000011
    { value: 0x22, codeLen: 8, code: 0x0042 }, //  01000010
    { value: 0x23, codeLen: 8, code: 0x0041 }, //  01000001
    { value: 0x24, codeLen: 8, code: 0x0040 }, //  01000000
    { value: 0x30, codeLen: 8, code: 0x003f }, //  00111111
    { value: 0x40, codeLen: 8, code: 0x003e }, //  00111110
    { value: 0xf0, codeLen: 8, code: 0x003d }, //  00111101
    { value: 0x25, codeLen: 9, code: 0x0079 }, //  001111001
    { value: 0x26, codeLen: 9, code: 0x0078 }, //  001111000
    { value: 0x27, codeLen: 9, code: 0x0077 }, //  001110111
    { value: 0x28, codeLen: 9, code: 0x0076 }, //  001110110
    { value: 0x29, codeLen: 9, code: 0x0075 }, //  001110101
    { value: 0x2a, codeLen: 9, code: 0x0074 }, //  001110100
    { value: 0x2b, codeLen: 9, code: 0x0073 }, //  001110011
    { value: 0x2c, codeLen: 9, code: 0x0072 }, //  001110010
    { value: 0x2d, codeLen: 9, code: 0x0071 }, //  001110001
    { value: 0x2e, codeLen: 9, code: 0x0070 }, //  001110000
    { value: 0x2f, codeLen: 9, code: 0x006f }, //  001101111
    { value: 0x31, codeLen: 9, code: 0x006e }, //  001101110
    { value: 0x32, codeLen: 9, code: 0x006d }, //  001101101
    { value: 0x33, codeLen: 9, code: 0x006c }, //  001101100
    { value: 0x34, codeLen: 9, code: 0x006b }, //  001101011
    { value: 0x35, codeLen: 9, code: 0x006a }, //  001101010
    { value: 0x36, codeLen: 9, code: 0x0069 }, //  001101001
    { value: 0x37, codeLen: 9, code: 0x0068 }, //  001101000
    { value: 0x38, codeLen: 9, code: 0x0067 }, //  001100111
    { value: 0x39, codeLen: 9, code: 0x0066 }, //  001100110
    { value: 0x3a, codeLen: 9, code: 0x0065 }, //  001100101
    { value: 0x3b, codeLen: 9, code: 0x0064 }, //  001100100
    { value: 0x3c, codeLen: 9, code: 0x0063 }, //  001100011
    { value: 0x3d, codeLen: 9, code: 0x0062 }, //  001100010
    { value: 0x3e, codeLen: 9, code: 0x0061 }, //  001100001
    { value: 0x3f, codeLen: 9, code: 0x0060 }, //  001100000
    { value: 0x41, codeLen: 9, code: 0x005f }, //  001011111
    { value: 0x42, codeLen: 9, code: 0x005e }, //  001011110
    { value: 0x43, codeLen: 9, code: 0x005d }, //  001011101
    { value: 0x44, codeLen: 9, code: 0x005c }, //  001011100
    { value: 0x45, codeLen: 9, code: 0x005b }, //  001011011
    { value: 0x46, codeLen: 9, code: 0x005a }, //  001011010
    { value: 0x47, codeLen: 9, code: 0x0059 }, //  001011001
    { value: 0x48, codeLen: 9, code: 0x0058 }, //  001011000
    { value: 0x49, codeLen: 9, code: 0x0057 }, //  001010111
    { value: 0x4c, codeLen: 9, code: 0x0056 }, //  001010110
    { value: 0x4f, codeLen: 9, code: 0x0055 }, //  001010101
    { value: 0x51, codeLen: 9, code: 0x0054 }, //  001010100
    { value: 0x80, codeLen: 9, code: 0x0053 }, //  001010011
    { value: 0xe0, codeLen: 9, code: 0x0052 }, //  001010010
    { value: 0xf1, codeLen: 9, code: 0x0051 }, //  001010001
    { value: 0xff, codeLen: 9, code: 0x0050 }, //  001010000
    { value: 0x4a, codeLen: 10, code: 0x009f }, //  0010011111
    { value: 0x4b, codeLen: 10, code: 0x009e }, //  0010011110
    { value: 0x4d, codeLen: 10, code: 0x009d }, //  0010011101
    { value: 0x4e, codeLen: 10, code: 0x009c }, //  0010011100
    { value: 0x52, codeLen: 10, code: 0x009b }, //  0010011011
    { value: 0x53, codeLen: 10, code: 0x009a }, //  0010011010
    { value: 0x54, codeLen: 10, code: 0x0099 }, //  0010011001
    { value: 0x55, codeLen: 10, code: 0x0098 }, //  0010011000
    { value: 0x56, codeLen: 10, code: 0x0097 }, //  0010010111
    { value: 0x57, codeLen: 10, code: 0x0096 }, //  0010010110
    { value: 0x58, codeLen: 10, code: 0x0095 }, //  0010010101
    { value: 0x59, codeLen: 10, code: 0x0094 }, //  0010010100
    { value: 0x5a, codeLen: 10, code: 0x0093 }, //  0010010011
    { value: 0x5b, codeLen: 10, code: 0x0092 }, //  0010010010
    { value: 0x5c, codeLen: 10, code: 0x0091 }, //  0010010001
    { value: 0x5d, codeLen: 10, code: 0x0090 }, //  0010010000
    { value: 0x5e, codeLen: 10, code: 0x008f }, //  0010001111
    { value: 0x5f, codeLen: 10, code: 0x008e }, //  0010001110
    { value: 0x60, codeLen: 10, code: 0x008d }, //  0010001101
    { value: 0x61, codeLen: 10, code: 0x008c }, //  0010001100
    { value: 0x62, codeLen: 10, code: 0x008b }, //  0010001011
    { value: 0x63, codeLen: 10, code: 0x008a }, //  0010001010
    { value: 0x64, codeLen: 10, code: 0x0089 }, //  0010001001
    { value: 0x65, codeLen: 10, code: 0x0088 }, //  0010001000
    { value: 0x66, codeLen: 10, code: 0x0087 }, //  0010000111
    { value: 0x67, codeLen: 10, code: 0x0086 }, //  0010000110
    { value: 0x68, codeLen: 10, code: 0x0085 }, //  0010000101
    { value: 0x69, codeLen: 10, code: 0x0084 }, //  0010000100
    { value: 0x6a, codeLen: 10, code: 0x0083 }, //  0010000011
    { value: 0x6b, codeLen: 10, code: 0x0082 }, //  0010000010
    { value: 0x6c, codeLen: 10, code: 0x0081 }, //  0010000001
    { value: 0x6d, codeLen: 10, code: 0x0080 }, //  0010000000
    { value: 0x6e, codeLen: 10, code: 0x007f }, //  0001111111
    { value: 0x6f, codeLen: 10, code: 0x007e }, //  0001111110
    { value: 0x70, codeLen: 10, code: 0x007d }, //  0001111101
    { value: 0x71, codeLen: 10, code: 0x007c }, //  0001111100
    { value: 0x72, codeLen: 10, code: 0x007b }, //  0001111011
    { value: 0x73, codeLen: 10, code: 0x007a }, //  0001111010
    { value: 0x74, codeLen: 10, code: 0x0079 }, //  0001111001
    { value: 0x75, codeLen: 10, code: 0x0078 }, //  0001111000
    { value: 0x76, codeLen: 10, code: 0x0077 }, //  0001110111
    { value: 0x77, codeLen: 10, code: 0x0076 }, //  0001110110
    { value: 0x78, codeLen: 10, code: 0x0075 }, //  0001110101
    { value: 0x79, codeLen: 10, code: 0x0074 }, //  0001110100
    { value: 0x7a, codeLen: 10, code: 0x0073 }, //  0001110011
    { value: 0x7b, codeLen: 10, code: 0x0072 }, //  0001110010
    { value: 0x7c, codeLen: 10, code: 0x0071 }, //  0001110001
    { value: 0x7d, codeLen: 10, code: 0x0070 }, //  0001110000
    { value: 0x7e, codeLen: 10, code: 0x006f }, //  0001101111
    { value: 0x7f, codeLen: 10, code: 0x006e }, //  0001101110
    { value: 0x81, codeLen: 10, code: 0x006d }, //  0001101101
    { value: 0x82, codeLen: 10, code: 0x006c }, //  0001101100
    { value: 0x83, codeLen: 10, code: 0x006b }, //  0001101011
    { value: 0x84, codeLen: 10, code: 0x006a }, //  0001101010
    { value: 0x85, codeLen: 10, code: 0x0069 }, //  0001101001
    { value: 0x86, codeLen: 10, code: 0x0068 }, //  0001101000
    { value: 0x87, codeLen: 10, code: 0x0067 }, //  0001100111
    { value: 0x88, codeLen: 10, code: 0x0066 }, //  0001100110
    { value: 0x89, codeLen: 10, code: 0x0065 }, //  0001100101
    { value: 0x8a, codeLen: 10, code: 0x0064 }, //  0001100100
    { value: 0x8b, codeLen: 10, code: 0x0063 }, //  0001100011
    { value: 0x8c, codeLen: 10, code: 0x0062 }, //  0001100010
    { value: 0x8d, codeLen: 10, code: 0x0061 }, //  0001100001
    { value: 0x8e, codeLen: 10, code: 0x0060 }, //  0001100000
    { value: 0x8f, codeLen: 10, code: 0x005f }, //  0001011111
    { value: 0x90, codeLen: 10, code: 0x005e }, //  0001011110
    { value: 0x91, codeLen: 10, code: 0x005d }, //  0001011101
    { value: 0x92, codeLen: 10, code: 0x005c }, //  0001011100
    { value: 0x93, codeLen: 10, code: 0x005b }, //  0001011011
    { value: 0x94, codeLen: 10, code: 0x005a }, //  0001011010
    { value: 0x95, codeLen: 10, code: 0x0059 }, //  0001011001
    { value: 0x96, codeLen: 10, code: 0x0058 }, //  0001011000
    { value: 0x97, codeLen: 10, code: 0x0057 }, //  0001010111
    { value: 0x98, codeLen: 10, code: 0x0056 }, //  0001010110
    { value: 0x99, codeLen: 10, code: 0x0055 }, //  0001010101
    { value: 0x9a, codeLen: 10, code: 0x0054 }, //  0001010100
    { value: 0x9b, codeLen: 10, code: 0x0053 }, //  0001010011
    { value: 0x9c, codeLen: 10, code: 0x0052 }, //  0001010010
    { value: 0x9d, codeLen: 10, code: 0x0051 }, //  0001010001
    { value: 0x9e, codeLen: 10, code: 0x0050 }, //  0001010000
    { value: 0x9f, codeLen: 10, code: 0x004f }, //  0001001111
    { value: 0xa0, codeLen: 10, code: 0x004e }, //  0001001110
    { value: 0xa1, codeLen: 10, code: 0x004d }, //  0001001101
    { value: 0xa2, codeLen: 10, code: 0x004c }, //  0001001100
    { value: 0xa3, codeLen: 10, code: 0x004b }, //  0001001011
    { value: 0xa4, codeLen: 10, code: 0x004a }, //  0001001010
    { value: 0xa5, codeLen: 10, code: 0x0049 }, //  0001001001
    { value: 0xa6, codeLen: 10, code: 0x0048 }, //  0001001000
    { value: 0xa7, codeLen: 10, code: 0x0047 }, //  0001000111
    { value: 0xa8, codeLen: 10, code: 0x0046 }, //  0001000110
    { value: 0xa9, codeLen: 10, code: 0x0045 }, //  0001000101
    { value: 0xaa, codeLen: 10, code: 0x0044 }, //  0001000100
    { value: 0xab, codeLen: 10, code: 0x0043 }, //  0001000011
    { value: 0xac, codeLen: 10, code: 0x0042 }, //  0001000010
    { value: 0xad, codeLen: 10, code: 0x0041 }, //  0001000001
    { value: 0xae, codeLen: 10, code: 0x0040 }, //  0001000000
    { value: 0xaf, codeLen: 10, code: 0x003f }, //  0000111111
    { value: 0xb0, codeLen: 10, code: 0x003e }, //  0000111110
    { value: 0xb1, codeLen: 10, code: 0x003d }, //  0000111101
    { value: 0xb2, codeLen: 10, code: 0x003c }, //  0000111100
    { value: 0xb3, codeLen: 10, code: 0x003b }, //  0000111011
    { value: 0xb4, codeLen: 10, code: 0x003a }, //  0000111010
    { value: 0xb5, codeLen: 10, code: 0x0039 }, //  0000111001
    { value: 0xb6, codeLen: 10, code: 0x0038 }, //  0000111000
    { value: 0xb7, codeLen: 10, code: 0x0037 }, //  0000110111
    { value: 0xb8, codeLen: 10, code: 0x0036 }, //  0000110110
    { value: 0xb9, codeLen: 10, code: 0x0035 }, //  0000110101
    { value: 0xba, codeLen: 10, code: 0x0034 }, //  0000110100
    { value: 0xbb, codeLen: 10, code: 0x0033 }, //  0000110011
    { value: 0xbc, codeLen: 10, code: 0x0032 }, //  0000110010
    { value: 0xbd, codeLen: 10, code: 0x0031 }, //  0000110001
    { value: 0xbe, codeLen: 10, code: 0x0030 }, //  0000110000
    { value: 0xbf, codeLen: 10, code: 0x002f }, //  0000101111
    { value: 0xc0, codeLen: 10, code: 0x002e }, //  0000101110
    { value: 0xc1, codeLen: 10, code: 0x002d }, //  0000101101
    { value: 0xc2, codeLen: 10, code: 0x002c }, //  0000101100
    { value: 0xc3, codeLen: 10, code: 0x002b }, //  0000101011
    { value: 0xc4, codeLen: 10, code: 0x002a }, //  0000101010
    { value: 0xc5, codeLen: 10, code: 0x0029 }, //  0000101001
    { value: 0xc6, codeLen: 10, code: 0x0028 }, //  0000101000
    { value: 0xc7, codeLen: 10, code: 0x0027 }, //  0000100111
    { value: 0xc8, codeLen: 10, code: 0x0026 }, //  0000100110
    { value: 0xc9, codeLen: 10, code: 0x0025 }, //  0000100101
    { value: 0xca, codeLen: 10, code: 0x0024 }, //  0000100100
    { value: 0xcb, codeLen: 10, code: 0x0023 }, //  0000100011
    { value: 0xcc, codeLen: 10, code: 0x0022 }, //  0000100010
    { value: 0xcd, codeLen: 10, code: 0x0021 }, //  0000100001
    { value: 0xce, codeLen: 10, code: 0x0020 }, //  0000100000
    { value: 0xcf, codeLen: 10, code: 0x001f }, //  0000011111
    { value: 0xd0, codeLen: 10, code: 0x001e }, //  0000011110
    { value: 0xd1, codeLen: 10, code: 0x001d }, //  0000011101
    { value: 0xd2, codeLen: 10, code: 0x001c }, //  0000011100
    { value: 0xd3, codeLen: 10, code: 0x001b }, //  0000011011
    { value: 0xd4, codeLen: 10, code: 0x001a }, //  0000011010
    { value: 0xd6, codeLen: 10, code: 0x0019 }, //  0000011001
    { value: 0xd7, codeLen: 10, code: 0x0018 }, //  0000011000
    { value: 0xd8, codeLen: 10, code: 0x0017 }, //  0000010111
    { value: 0xd9, codeLen: 10, code: 0x0016 }, //  0000010110
    { value: 0xda, codeLen: 10, code: 0x0015 }, //  0000010101
    { value: 0xdb, codeLen: 10, code: 0x0014 }, //  0000010100
    { value: 0xdc, codeLen: 10, code: 0x0013 }, //  0000010011
    { value: 0xde, codeLen: 10, code: 0x0012 }, //  0000010010
    { value: 0xdf, codeLen: 10, code: 0x0011 }, //  0000010001
    { value: 0xe1, codeLen: 10, code: 0x0010 }, //  0000010000
    { value: 0xe2, codeLen: 10, code: 0x000f }, //  0000001111
    { value: 0xe4, codeLen: 10, code: 0x000e }, //  0000001110
    { value: 0xef, codeLen: 10, code: 0x000d }, //  0000001101
    { value: 0xd5, codeLen: 11, code: 0x0019 }, //  00000011001
    { value: 0xdd, codeLen: 11, code: 0x0018 }, //  00000011000
    { value: 0xe3, codeLen: 11, code: 0x0017 }, //  00000010111
    { value: 0xe5, codeLen: 11, code: 0x0016 }, //  00000010110
    { value: 0xe6, codeLen: 11, code: 0x0015 }, //  00000010101
    { value: 0xe7, codeLen: 11, code: 0x0014 }, //  00000010100
    { value: 0xe8, codeLen: 11, code: 0x0013 }, //  00000010011
    { value: 0xe9, codeLen: 11, code: 0x0012 }, //  00000010010
    { value: 0xea, codeLen: 11, code: 0x0011 }, //  00000010001
    { value: 0xeb, codeLen: 11, code: 0x0010 }, //  00000010000
    { value: 0xec, codeLen: 11, code: 0x000f }, //  00000001111
    { value: 0xed, codeLen: 11, code: 0x000e }, //  00000001110
    { value: 0xee, codeLen: 11, code: 0x000d }, //  00000001101
    { value: 0xf2, codeLen: 11, code: 0x000c }, //  00000001100
    { value: 0xf3, codeLen: 11, code: 0x000b }, //  00000001011
    { value: 0xf4, codeLen: 11, code: 0x000a }, //  00000001010
    { value: 0xf5, codeLen: 11, code: 0x0009 }, //  00000001001
    { value: 0xf6, codeLen: 11, code: 0x0008 }, //  00000001000
    { value: 0xf7, codeLen: 11, code: 0x0007 }, //  00000000111
    { value: 0xf8, codeLen: 11, code: 0x0006 }, //  00000000110
    { value: 0xfa, codeLen: 11, code: 0x0005 }, //  00000000101
    { value: 0xfb, codeLen: 11, code: 0x0004 }, //  00000000100
    { value: 0xfc, codeLen: 11, code: 0x0003 }, //  00000000011
    { value: 0xfd, codeLen: 11, code: 0x0002 }, //  00000000010
    { value: 0xfe, codeLen: 11, code: 0x0001 }, //  00000000001
    { value: 0xf9, codeLen: 12, code: 0x0001 }, //  000000000001
    { value: HUFFMAN_EOF, codeLen: 12, code: 0x0000 }, //  000000000000
];

export const defaultHuffmanLenIndex = (function () {
    const result = Array(defaultHuffmanTree.length).fill(-1);

    for (let i = 0; i < defaultHuffmanTree.length; ++i) {
        if (result[defaultHuffmanTree[i].codeLen] === -1) {
            result[defaultHuffmanTree[i].codeLen] = i;
        }
    }

    return result;
})();
