import Foundation

/// Defines a set of targets that packages exposes.
public enum PackageExposedTargets: Codable, Equatable {
    
    /// Package defines an explicit list of targets. This is a 'traditional' way of exposing targets. 
    case targetNames([String])
    
    /// A list of exposed targets can be generated by a `package-gen`.
    case generated
    
    public static let generatedStringRep = "generated"
    
    private enum CodingKeys: CodingKey {
        case targetNames
        case generated
    }
    
    public init(from decoder: Decoder) throws {
        let container = try decoder.singleValueContainer()
        do {
            let stringRep = try container.decode(String.self)
            guard stringRep == PackageExposedTargets.generatedStringRep else {
                fatalError("The value must be '\(PackageExposedTargets.generatedStringRep)', but found '\(stringRep)'")
            }
            self = .generated
        } catch {
            self = .targetNames(try container.decode([String].self))
        }
    }
    
    public func encode(to encoder: Encoder) throws {
        var container = encoder.singleValueContainer()
        switch self {
        case .generated:
            try container.encode(PackageExposedTargets.generatedStringRep)
        case let .targetNames(value):
            try container.encode(value)
        }
    }
}
