// Code generated by goa v3.16.1, DO NOT EDIT.
//
// tools HTTP client types
//
// Command:
// $ goa gen github.com/arduino/arduino-create-agent/design

package client

import (
	tools "github.com/arduino/arduino-create-agent/gen/tools"
	toolsviews "github.com/arduino/arduino-create-agent/gen/tools/views"
	goa "goa.design/goa/v3/pkg"
)

// InstallRequestBody is the type of the "tools" service "install" endpoint
// HTTP request body.
type InstallRequestBody struct {
	// The name of the tool
	Name string `form:"name" json:"name" xml:"name"`
	// The version of the tool
	Version string `form:"version" json:"version" xml:"version"`
	// The packager of the tool
	Packager string `form:"packager" json:"packager" xml:"packager"`
	// The url where the package can be found. Optional.
	// If present checksum must also be present.
	URL *string `form:"url,omitempty" json:"url,omitempty" xml:"url,omitempty"`
	// A checksum of the archive. Mandatory when url is present.
	// This ensures that the package is downloaded correcly.
	Checksum *string `form:"checksum,omitempty" json:"checksum,omitempty" xml:"checksum,omitempty"`
	// The signature used to sign the url. Mandatory when url is present.
	// This ensure the security of the file downloaded
	Signature *string `form:"signature,omitempty" json:"signature,omitempty" xml:"signature,omitempty"`
}

// RemoveRequestBody is the type of the "tools" service "remove" endpoint HTTP
// request body.
type RemoveRequestBody struct {
	// The url where the package can be found. Optional.
	// If present checksum must also be present.
	URL *string `form:"url,omitempty" json:"url,omitempty" xml:"url,omitempty"`
	// A checksum of the archive. Mandatory when url is present.
	// This ensures that the package is downloaded correcly.
	Checksum *string `form:"checksum,omitempty" json:"checksum,omitempty" xml:"checksum,omitempty"`
	// The signature used to sign the url. Mandatory when url is present.
	// This ensure the security of the file downloaded
	Signature *string `form:"signature,omitempty" json:"signature,omitempty" xml:"signature,omitempty"`
}

// AvailableResponseBody is the type of the "tools" service "available"
// endpoint HTTP response body.
type AvailableResponseBody []*ToolResponse

// InstalledResponseBody is the type of the "tools" service "installed"
// endpoint HTTP response body.
type InstalledResponseBody []*ToolResponse

// InstallResponseBody is the type of the "tools" service "install" endpoint
// HTTP response body.
type InstallResponseBody struct {
	// The status of the operation
	Status *string `form:"status,omitempty" json:"status,omitempty" xml:"status,omitempty"`
}

// RemoveResponseBody is the type of the "tools" service "remove" endpoint HTTP
// response body.
type RemoveResponseBody struct {
	// The status of the operation
	Status *string `form:"status,omitempty" json:"status,omitempty" xml:"status,omitempty"`
}

// ToolResponse is used to define fields on response body types.
type ToolResponse struct {
	// The name of the tool
	Name *string `form:"name,omitempty" json:"name,omitempty" xml:"name,omitempty"`
	// The version of the tool
	Version *string `form:"version,omitempty" json:"version,omitempty" xml:"version,omitempty"`
	// The packager of the tool
	Packager *string `form:"packager,omitempty" json:"packager,omitempty" xml:"packager,omitempty"`
}

// NewInstallRequestBody builds the HTTP request body from the payload of the
// "install" endpoint of the "tools" service.
func NewInstallRequestBody(p *tools.ToolPayload) *InstallRequestBody {
	body := &InstallRequestBody{
		Name:      p.Name,
		Version:   p.Version,
		Packager:  p.Packager,
		URL:       p.URL,
		Checksum:  p.Checksum,
		Signature: p.Signature,
	}
	return body
}

// NewRemoveRequestBody builds the HTTP request body from the payload of the
// "remove" endpoint of the "tools" service.
func NewRemoveRequestBody(p *tools.ToolPayload) *RemoveRequestBody {
	body := &RemoveRequestBody{
		URL:       p.URL,
		Checksum:  p.Checksum,
		Signature: p.Signature,
	}
	return body
}

// NewAvailableToolCollectionOK builds a "tools" service "available" endpoint
// result from a HTTP "OK" response.
func NewAvailableToolCollectionOK(body AvailableResponseBody) toolsviews.ToolCollectionView {
	v := make([]*toolsviews.ToolView, len(body))
	for i, val := range body {
		v[i] = unmarshalToolResponseToToolsviewsToolView(val)
	}

	return v
}

// NewInstalledToolCollectionOK builds a "tools" service "installed" endpoint
// result from a HTTP "OK" response.
func NewInstalledToolCollectionOK(body InstalledResponseBody) toolsviews.ToolCollectionView {
	v := make([]*toolsviews.ToolView, len(body))
	for i, val := range body {
		v[i] = unmarshalToolResponseToToolsviewsToolView(val)
	}

	return v
}

// NewInstallOperationOK builds a "tools" service "install" endpoint result
// from a HTTP "OK" response.
func NewInstallOperationOK(body *InstallResponseBody) *toolsviews.OperationView {
	v := &toolsviews.OperationView{
		Status: body.Status,
	}

	return v
}

// NewRemoveOperationOK builds a "tools" service "remove" endpoint result from
// a HTTP "OK" response.
func NewRemoveOperationOK(body *RemoveResponseBody) *toolsviews.OperationView {
	v := &toolsviews.OperationView{
		Status: body.Status,
	}

	return v
}

// ValidateToolResponse runs the validations defined on ToolResponse
func ValidateToolResponse(body *ToolResponse) (err error) {
	if body.Name == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("name", "body"))
	}
	if body.Version == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("version", "body"))
	}
	if body.Packager == nil {
		err = goa.MergeErrors(err, goa.MissingFieldError("packager", "body"))
	}
	return
}
