// Code generated by goa v3.14.6, DO NOT EDIT.
//
// tools endpoints
//
// Command:
// $ goa gen github.com/arduino/arduino-create-agent/design

package tools

import (
	"context"

	goa "goa.design/goa/v3/pkg"
)

// Endpoints wraps the "tools" service endpoints.
type Endpoints struct {
	Available     goa.Endpoint
	Installedhead goa.Endpoint
	Installed     goa.Endpoint
	Install       goa.Endpoint
	Remove        goa.Endpoint
}

// NewEndpoints wraps the methods of the "tools" service with endpoints.
func NewEndpoints(s Service) *Endpoints {
	return &Endpoints{
		Available:     NewAvailableEndpoint(s),
		Installedhead: NewInstalledheadEndpoint(s),
		Installed:     NewInstalledEndpoint(s),
		Install:       NewInstallEndpoint(s),
		Remove:        NewRemoveEndpoint(s),
	}
}

// Use applies the given middleware to all the "tools" service endpoints.
func (e *Endpoints) Use(m func(goa.Endpoint) goa.Endpoint) {
	e.Available = m(e.Available)
	e.Installedhead = m(e.Installedhead)
	e.Installed = m(e.Installed)
	e.Install = m(e.Install)
	e.Remove = m(e.Remove)
}

// NewAvailableEndpoint returns an endpoint function that calls the method
// "available" of service "tools".
func NewAvailableEndpoint(s Service) goa.Endpoint {
	return func(ctx context.Context, req any) (any, error) {
		res, err := s.Available(ctx)
		if err != nil {
			return nil, err
		}
		vres := NewViewedToolCollection(res, "default")
		return vres, nil
	}
}

// NewInstalledheadEndpoint returns an endpoint function that calls the method
// "installedhead" of service "tools".
func NewInstalledheadEndpoint(s Service) goa.Endpoint {
	return func(ctx context.Context, req any) (any, error) {
		return nil, s.Installedhead(ctx)
	}
}

// NewInstalledEndpoint returns an endpoint function that calls the method
// "installed" of service "tools".
func NewInstalledEndpoint(s Service) goa.Endpoint {
	return func(ctx context.Context, req any) (any, error) {
		res, err := s.Installed(ctx)
		if err != nil {
			return nil, err
		}
		vres := NewViewedToolCollection(res, "default")
		return vres, nil
	}
}

// NewInstallEndpoint returns an endpoint function that calls the method
// "install" of service "tools".
func NewInstallEndpoint(s Service) goa.Endpoint {
	return func(ctx context.Context, req any) (any, error) {
		p := req.(*ToolPayload)
		res, err := s.Install(ctx, p)
		if err != nil {
			return nil, err
		}
		vres := NewViewedOperation(res, "default")
		return vres, nil
	}
}

// NewRemoveEndpoint returns an endpoint function that calls the method
// "remove" of service "tools".
func NewRemoveEndpoint(s Service) goa.Endpoint {
	return func(ctx context.Context, req any) (any, error) {
		p := req.(*ToolPayload)
		res, err := s.Remove(ctx, p)
		if err != nil {
			return nil, err
		}
		vres := NewViewedOperation(res, "default")
		return vres, nil
	}
}
