// Code generated by goa v3.12.4, DO NOT EDIT.
//
// indexes HTTP client encoders and decoders
//
// Command:
// $ goa gen github.com/arduino/arduino-create-agent/design

package client

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"

	indexes "github.com/arduino/arduino-create-agent/gen/indexes"
	indexesviews "github.com/arduino/arduino-create-agent/gen/indexes/views"
	goahttp "goa.design/goa/v3/http"
)

// BuildListRequest instantiates a HTTP request object with method and path set
// to call the "indexes" service "list" endpoint
func (c *Client) BuildListRequest(ctx context.Context, v any) (*http.Request, error) {
	u := &url.URL{Scheme: c.scheme, Host: c.host, Path: ListIndexesPath()}
	req, err := http.NewRequest("GET", u.String(), nil)
	if err != nil {
		return nil, goahttp.ErrInvalidURL("indexes", "list", u.String(), err)
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}

	return req, nil
}

// DecodeListResponse returns a decoder for responses returned by the indexes
// list endpoint. restoreBody controls whether the response body should be
// restored after having been read.
// DecodeListResponse may return the following errors:
//   - "invalid_url" (type *goa.ServiceError): http.StatusBadRequest
//   - error: internal error
func DecodeListResponse(decoder func(*http.Response) goahttp.Decoder, restoreBody bool) func(*http.Response) (any, error) {
	return func(resp *http.Response) (any, error) {
		if restoreBody {
			b, err := io.ReadAll(resp.Body)
			if err != nil {
				return nil, err
			}
			resp.Body = io.NopCloser(bytes.NewBuffer(b))
			defer func() {
				resp.Body = io.NopCloser(bytes.NewBuffer(b))
			}()
		} else {
			defer resp.Body.Close()
		}
		switch resp.StatusCode {
		case http.StatusOK:
			var (
				body []string
				err  error
			)
			err = decoder(resp).Decode(&body)
			if err != nil {
				return nil, goahttp.ErrDecodingError("indexes", "list", err)
			}
			return body, nil
		case http.StatusBadRequest:
			var (
				body ListInvalidURLResponseBody
				err  error
			)
			err = decoder(resp).Decode(&body)
			if err != nil {
				return nil, goahttp.ErrDecodingError("indexes", "list", err)
			}
			err = ValidateListInvalidURLResponseBody(&body)
			if err != nil {
				return nil, goahttp.ErrValidationError("indexes", "list", err)
			}
			return nil, NewListInvalidURL(&body)
		default:
			body, _ := io.ReadAll(resp.Body)
			return nil, goahttp.ErrInvalidResponse("indexes", "list", resp.StatusCode, string(body))
		}
	}
}

// BuildAddRequest instantiates a HTTP request object with method and path set
// to call the "indexes" service "add" endpoint
func (c *Client) BuildAddRequest(ctx context.Context, v any) (*http.Request, error) {
	u := &url.URL{Scheme: c.scheme, Host: c.host, Path: AddIndexesPath()}
	req, err := http.NewRequest("POST", u.String(), nil)
	if err != nil {
		return nil, goahttp.ErrInvalidURL("indexes", "add", u.String(), err)
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}

	return req, nil
}

// EncodeAddRequest returns an encoder for requests sent to the indexes add
// server.
func EncodeAddRequest(encoder func(*http.Request) goahttp.Encoder) func(*http.Request, any) error {
	return func(req *http.Request, v any) error {
		p, ok := v.(*indexes.IndexPayload)
		if !ok {
			return goahttp.ErrInvalidType("indexes", "add", "*indexes.IndexPayload", v)
		}
		body := NewAddRequestBody(p)
		if err := encoder(req).Encode(&body); err != nil {
			return goahttp.ErrEncodingError("indexes", "add", err)
		}
		return nil
	}
}

// DecodeAddResponse returns a decoder for responses returned by the indexes
// add endpoint. restoreBody controls whether the response body should be
// restored after having been read.
// DecodeAddResponse may return the following errors:
//   - "invalid_url" (type *goa.ServiceError): http.StatusBadRequest
//   - error: internal error
func DecodeAddResponse(decoder func(*http.Response) goahttp.Decoder, restoreBody bool) func(*http.Response) (any, error) {
	return func(resp *http.Response) (any, error) {
		if restoreBody {
			b, err := io.ReadAll(resp.Body)
			if err != nil {
				return nil, err
			}
			resp.Body = io.NopCloser(bytes.NewBuffer(b))
			defer func() {
				resp.Body = io.NopCloser(bytes.NewBuffer(b))
			}()
		} else {
			defer resp.Body.Close()
		}
		switch resp.StatusCode {
		case http.StatusOK:
			var (
				body AddResponseBody
				err  error
			)
			err = decoder(resp).Decode(&body)
			if err != nil {
				return nil, goahttp.ErrDecodingError("indexes", "add", err)
			}
			p := NewAddOperationOK(&body)
			view := "default"
			vres := &indexesviews.Operation{Projected: p, View: view}
			if err = indexesviews.ValidateOperation(vres); err != nil {
				return nil, goahttp.ErrValidationError("indexes", "add", err)
			}
			res := indexes.NewOperation(vres)
			return res, nil
		case http.StatusBadRequest:
			var (
				body AddInvalidURLResponseBody
				err  error
			)
			err = decoder(resp).Decode(&body)
			if err != nil {
				return nil, goahttp.ErrDecodingError("indexes", "add", err)
			}
			err = ValidateAddInvalidURLResponseBody(&body)
			if err != nil {
				return nil, goahttp.ErrValidationError("indexes", "add", err)
			}
			return nil, NewAddInvalidURL(&body)
		default:
			body, _ := io.ReadAll(resp.Body)
			return nil, goahttp.ErrInvalidResponse("indexes", "add", resp.StatusCode, string(body))
		}
	}
}

// BuildRemoveRequest instantiates a HTTP request object with method and path
// set to call the "indexes" service "remove" endpoint
func (c *Client) BuildRemoveRequest(ctx context.Context, v any) (*http.Request, error) {
	u := &url.URL{Scheme: c.scheme, Host: c.host, Path: RemoveIndexesPath()}
	req, err := http.NewRequest("POST", u.String(), nil)
	if err != nil {
		return nil, goahttp.ErrInvalidURL("indexes", "remove", u.String(), err)
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}

	return req, nil
}

// EncodeRemoveRequest returns an encoder for requests sent to the indexes
// remove server.
func EncodeRemoveRequest(encoder func(*http.Request) goahttp.Encoder) func(*http.Request, any) error {
	return func(req *http.Request, v any) error {
		p, ok := v.(*indexes.IndexPayload)
		if !ok {
			return goahttp.ErrInvalidType("indexes", "remove", "*indexes.IndexPayload", v)
		}
		body := NewRemoveRequestBody(p)
		if err := encoder(req).Encode(&body); err != nil {
			return goahttp.ErrEncodingError("indexes", "remove", err)
		}
		return nil
	}
}

// DecodeRemoveResponse returns a decoder for responses returned by the indexes
// remove endpoint. restoreBody controls whether the response body should be
// restored after having been read.
// DecodeRemoveResponse may return the following errors:
//   - "invalid_url" (type *goa.ServiceError): http.StatusBadRequest
//   - error: internal error
func DecodeRemoveResponse(decoder func(*http.Response) goahttp.Decoder, restoreBody bool) func(*http.Response) (any, error) {
	return func(resp *http.Response) (any, error) {
		if restoreBody {
			b, err := io.ReadAll(resp.Body)
			if err != nil {
				return nil, err
			}
			resp.Body = io.NopCloser(bytes.NewBuffer(b))
			defer func() {
				resp.Body = io.NopCloser(bytes.NewBuffer(b))
			}()
		} else {
			defer resp.Body.Close()
		}
		switch resp.StatusCode {
		case http.StatusOK:
			var (
				body RemoveResponseBody
				err  error
			)
			err = decoder(resp).Decode(&body)
			if err != nil {
				return nil, goahttp.ErrDecodingError("indexes", "remove", err)
			}
			p := NewRemoveOperationOK(&body)
			view := "default"
			vres := &indexesviews.Operation{Projected: p, View: view}
			if err = indexesviews.ValidateOperation(vres); err != nil {
				return nil, goahttp.ErrValidationError("indexes", "remove", err)
			}
			res := indexes.NewOperation(vres)
			return res, nil
		case http.StatusBadRequest:
			var (
				body RemoveInvalidURLResponseBody
				err  error
			)
			err = decoder(resp).Decode(&body)
			if err != nil {
				return nil, goahttp.ErrDecodingError("indexes", "remove", err)
			}
			err = ValidateRemoveInvalidURLResponseBody(&body)
			if err != nil {
				return nil, goahttp.ErrValidationError("indexes", "remove", err)
			}
			return nil, NewRemoveInvalidURL(&body)
		default:
			body, _ := io.ReadAll(resp.Body)
			return nil, goahttp.ErrInvalidResponse("indexes", "remove", resp.StatusCode, string(body))
		}
	}
}
