// Code generated by goa v2.0.0-wip, DO NOT EDIT.
//
// tools HTTP server
//
// Command:
// $ goa gen github.com/arduino/arduino-create-agent/design

package server

import (
	"context"
	"net/http"

	tools "github.com/arduino/arduino-create-agent/gen/tools"
	goa "goa.design/goa"
	goahttp "goa.design/goa/http"
)

// Server lists the tools service endpoint HTTP handlers.
type Server struct {
	Mounts    []*MountPoint
	Available http.Handler
	Installed http.Handler
	Install   http.Handler
	Remove    http.Handler
}

// ErrorNamer is an interface implemented by generated error structs that
// exposes the name of the error as defined in the design.
type ErrorNamer interface {
	ErrorName() string
}

// MountPoint holds information about the mounted endpoints.
type MountPoint struct {
	// Method is the name of the service method served by the mounted HTTP handler.
	Method string
	// Verb is the HTTP method used to match requests to the mounted handler.
	Verb string
	// Pattern is the HTTP request path pattern used to match requests to the
	// mounted handler.
	Pattern string
}

// New instantiates HTTP handlers for all the tools service endpoints.
func New(
	e *tools.Endpoints,
	mux goahttp.Muxer,
	dec func(*http.Request) goahttp.Decoder,
	enc func(context.Context, http.ResponseWriter) goahttp.Encoder,
	eh func(context.Context, http.ResponseWriter, error),
) *Server {
	return &Server{
		Mounts: []*MountPoint{
			{"Available", "GET", "/v2/pkgs/tools/available"},
			{"Installed", "GET", "/v2/pkgs/tools/installed"},
			{"Install", "POST", "/v2/pkgs/tools/installed"},
			{"Remove", "DELETE", "/v2/pkgs/tools/installed/{packager}/{name}/{version}"},
		},
		Available: NewAvailableHandler(e.Available, mux, dec, enc, eh),
		Installed: NewInstalledHandler(e.Installed, mux, dec, enc, eh),
		Install:   NewInstallHandler(e.Install, mux, dec, enc, eh),
		Remove:    NewRemoveHandler(e.Remove, mux, dec, enc, eh),
	}
}

// Service returns the name of the service served.
func (s *Server) Service() string { return "tools" }

// Use wraps the server handlers with the given middleware.
func (s *Server) Use(m func(http.Handler) http.Handler) {
	s.Available = m(s.Available)
	s.Installed = m(s.Installed)
	s.Install = m(s.Install)
	s.Remove = m(s.Remove)
}

// Mount configures the mux to serve the tools endpoints.
func Mount(mux goahttp.Muxer, h *Server) {
	MountAvailableHandler(mux, h.Available)
	MountInstalledHandler(mux, h.Installed)
	MountInstallHandler(mux, h.Install)
	MountRemoveHandler(mux, h.Remove)
}

// MountAvailableHandler configures the mux to serve the "tools" service
// "available" endpoint.
func MountAvailableHandler(mux goahttp.Muxer, h http.Handler) {
	f, ok := h.(http.HandlerFunc)
	if !ok {
		f = func(w http.ResponseWriter, r *http.Request) {
			h.ServeHTTP(w, r)
		}
	}
	mux.Handle("GET", "/v2/pkgs/tools/available", f)
}

// NewAvailableHandler creates a HTTP handler which loads the HTTP request and
// calls the "tools" service "available" endpoint.
func NewAvailableHandler(
	endpoint goa.Endpoint,
	mux goahttp.Muxer,
	dec func(*http.Request) goahttp.Decoder,
	enc func(context.Context, http.ResponseWriter) goahttp.Encoder,
	eh func(context.Context, http.ResponseWriter, error),
) http.Handler {
	var (
		encodeResponse = EncodeAvailableResponse(enc)
		encodeError    = goahttp.ErrorEncoder(enc)
	)
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		ctx := context.WithValue(r.Context(), goahttp.AcceptTypeKey, r.Header.Get("Accept"))
		ctx = context.WithValue(ctx, goa.MethodKey, "available")
		ctx = context.WithValue(ctx, goa.ServiceKey, "tools")

		res, err := endpoint(ctx, nil)

		if err != nil {
			if err := encodeError(ctx, w, err); err != nil {
				eh(ctx, w, err)
			}
			return
		}
		if err := encodeResponse(ctx, w, res); err != nil {
			eh(ctx, w, err)
		}
	})
}

// MountInstalledHandler configures the mux to serve the "tools" service
// "installed" endpoint.
func MountInstalledHandler(mux goahttp.Muxer, h http.Handler) {
	f, ok := h.(http.HandlerFunc)
	if !ok {
		f = func(w http.ResponseWriter, r *http.Request) {
			h.ServeHTTP(w, r)
		}
	}
	mux.Handle("GET", "/v2/pkgs/tools/installed", f)
}

// NewInstalledHandler creates a HTTP handler which loads the HTTP request and
// calls the "tools" service "installed" endpoint.
func NewInstalledHandler(
	endpoint goa.Endpoint,
	mux goahttp.Muxer,
	dec func(*http.Request) goahttp.Decoder,
	enc func(context.Context, http.ResponseWriter) goahttp.Encoder,
	eh func(context.Context, http.ResponseWriter, error),
) http.Handler {
	var (
		encodeResponse = EncodeInstalledResponse(enc)
		encodeError    = goahttp.ErrorEncoder(enc)
	)
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		ctx := context.WithValue(r.Context(), goahttp.AcceptTypeKey, r.Header.Get("Accept"))
		ctx = context.WithValue(ctx, goa.MethodKey, "installed")
		ctx = context.WithValue(ctx, goa.ServiceKey, "tools")

		res, err := endpoint(ctx, nil)

		if err != nil {
			if err := encodeError(ctx, w, err); err != nil {
				eh(ctx, w, err)
			}
			return
		}
		if err := encodeResponse(ctx, w, res); err != nil {
			eh(ctx, w, err)
		}
	})
}

// MountInstallHandler configures the mux to serve the "tools" service
// "install" endpoint.
func MountInstallHandler(mux goahttp.Muxer, h http.Handler) {
	f, ok := h.(http.HandlerFunc)
	if !ok {
		f = func(w http.ResponseWriter, r *http.Request) {
			h.ServeHTTP(w, r)
		}
	}
	mux.Handle("POST", "/v2/pkgs/tools/installed", f)
}

// NewInstallHandler creates a HTTP handler which loads the HTTP request and
// calls the "tools" service "install" endpoint.
func NewInstallHandler(
	endpoint goa.Endpoint,
	mux goahttp.Muxer,
	dec func(*http.Request) goahttp.Decoder,
	enc func(context.Context, http.ResponseWriter) goahttp.Encoder,
	eh func(context.Context, http.ResponseWriter, error),
) http.Handler {
	var (
		decodeRequest  = DecodeInstallRequest(mux, dec)
		encodeResponse = EncodeInstallResponse(enc)
		encodeError    = goahttp.ErrorEncoder(enc)
	)
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		ctx := context.WithValue(r.Context(), goahttp.AcceptTypeKey, r.Header.Get("Accept"))
		ctx = context.WithValue(ctx, goa.MethodKey, "install")
		ctx = context.WithValue(ctx, goa.ServiceKey, "tools")
		payload, err := decodeRequest(r)
		if err != nil {
			if err := encodeError(ctx, w, err); err != nil {
				eh(ctx, w, err)
			}
			return
		}

		res, err := endpoint(ctx, payload)

		if err != nil {
			if err := encodeError(ctx, w, err); err != nil {
				eh(ctx, w, err)
			}
			return
		}
		if err := encodeResponse(ctx, w, res); err != nil {
			eh(ctx, w, err)
		}
	})
}

// MountRemoveHandler configures the mux to serve the "tools" service "remove"
// endpoint.
func MountRemoveHandler(mux goahttp.Muxer, h http.Handler) {
	f, ok := h.(http.HandlerFunc)
	if !ok {
		f = func(w http.ResponseWriter, r *http.Request) {
			h.ServeHTTP(w, r)
		}
	}
	mux.Handle("DELETE", "/v2/pkgs/tools/installed/{packager}/{name}/{version}", f)
}

// NewRemoveHandler creates a HTTP handler which loads the HTTP request and
// calls the "tools" service "remove" endpoint.
func NewRemoveHandler(
	endpoint goa.Endpoint,
	mux goahttp.Muxer,
	dec func(*http.Request) goahttp.Decoder,
	enc func(context.Context, http.ResponseWriter) goahttp.Encoder,
	eh func(context.Context, http.ResponseWriter, error),
) http.Handler {
	var (
		decodeRequest  = DecodeRemoveRequest(mux, dec)
		encodeResponse = EncodeRemoveResponse(enc)
		encodeError    = goahttp.ErrorEncoder(enc)
	)
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		ctx := context.WithValue(r.Context(), goahttp.AcceptTypeKey, r.Header.Get("Accept"))
		ctx = context.WithValue(ctx, goa.MethodKey, "remove")
		ctx = context.WithValue(ctx, goa.ServiceKey, "tools")
		payload, err := decodeRequest(r)
		if err != nil {
			if err := encodeError(ctx, w, err); err != nil {
				eh(ctx, w, err)
			}
			return
		}

		res, err := endpoint(ctx, payload)

		if err != nil {
			if err := encodeError(ctx, w, err); err != nil {
				eh(ctx, w, err)
			}
			return
		}
		if err := encodeResponse(ctx, w, res); err != nil {
			eh(ctx, w, err)
		}
	})
}
