// Code generated by goa v2.0.0-wip, DO NOT EDIT.
//
// arduino-create-agent HTTP client CLI support package
//
// Command:
// $ goa gen github.com/arduino/arduino-create-agent/design

package cli

import (
	"flag"
	"fmt"
	"net/http"
	"os"

	indexesc "github.com/arduino/arduino-create-agent/gen/http/indexes/client"
	toolsc "github.com/arduino/arduino-create-agent/gen/http/tools/client"
	goa "goa.design/goa"
	goahttp "goa.design/goa/http"
)

// UsageCommands returns the set of commands and sub-commands using the format
//
//    command (subcommand1|subcommand2|...)
//
func UsageCommands() string {
	return `indexes (list|add|remove)
tools (available|installed|install|remove)
`
}

// UsageExamples produces an example of a valid invocation of the CLI tool.
func UsageExamples() string {
	return os.Args[0] + ` indexes list` + "\n" +
		os.Args[0] + ` tools available` + "\n" +
		""
}

// ParseEndpoint returns the endpoint and payload as specified on the command
// line.
func ParseEndpoint(
	scheme, host string,
	doer goahttp.Doer,
	enc func(*http.Request) goahttp.Encoder,
	dec func(*http.Response) goahttp.Decoder,
	restore bool,
) (goa.Endpoint, interface{}, error) {
	var (
		indexesFlags = flag.NewFlagSet("indexes", flag.ContinueOnError)

		indexesListFlags = flag.NewFlagSet("list", flag.ExitOnError)

		indexesAddFlags    = flag.NewFlagSet("add", flag.ExitOnError)
		indexesAddBodyFlag = indexesAddFlags.String("body", "REQUIRED", "")

		indexesRemoveFlags    = flag.NewFlagSet("remove", flag.ExitOnError)
		indexesRemoveBodyFlag = indexesRemoveFlags.String("body", "REQUIRED", "")

		toolsFlags = flag.NewFlagSet("tools", flag.ContinueOnError)

		toolsAvailableFlags = flag.NewFlagSet("available", flag.ExitOnError)

		toolsInstalledFlags = flag.NewFlagSet("installed", flag.ExitOnError)

		toolsInstallFlags    = flag.NewFlagSet("install", flag.ExitOnError)
		toolsInstallBodyFlag = toolsInstallFlags.String("body", "REQUIRED", "")

		toolsRemoveFlags        = flag.NewFlagSet("remove", flag.ExitOnError)
		toolsRemoveBodyFlag     = toolsRemoveFlags.String("body", "REQUIRED", "")
		toolsRemovePackagerFlag = toolsRemoveFlags.String("packager", "REQUIRED", "The packager of the tool")
		toolsRemoveNameFlag     = toolsRemoveFlags.String("name", "REQUIRED", "The name of the tool")
		toolsRemoveVersionFlag  = toolsRemoveFlags.String("version", "REQUIRED", "The version of the tool")
	)
	indexesFlags.Usage = indexesUsage
	indexesListFlags.Usage = indexesListUsage
	indexesAddFlags.Usage = indexesAddUsage
	indexesRemoveFlags.Usage = indexesRemoveUsage

	toolsFlags.Usage = toolsUsage
	toolsAvailableFlags.Usage = toolsAvailableUsage
	toolsInstalledFlags.Usage = toolsInstalledUsage
	toolsInstallFlags.Usage = toolsInstallUsage
	toolsRemoveFlags.Usage = toolsRemoveUsage

	if err := flag.CommandLine.Parse(os.Args[1:]); err != nil {
		return nil, nil, err
	}

	if flag.NArg() < 2 { // two non flag args are required: SERVICE and ENDPOINT (aka COMMAND)
		return nil, nil, fmt.Errorf("not enough arguments")
	}

	var (
		svcn string
		svcf *flag.FlagSet
	)
	{
		svcn = flag.Arg(0)
		switch svcn {
		case "indexes":
			svcf = indexesFlags
		case "tools":
			svcf = toolsFlags
		default:
			return nil, nil, fmt.Errorf("unknown service %q", svcn)
		}
	}
	if err := svcf.Parse(flag.Args()[1:]); err != nil {
		return nil, nil, err
	}

	var (
		epn string
		epf *flag.FlagSet
	)
	{
		epn = svcf.Arg(0)
		switch svcn {
		case "indexes":
			switch epn {
			case "list":
				epf = indexesListFlags

			case "add":
				epf = indexesAddFlags

			case "remove":
				epf = indexesRemoveFlags

			}

		case "tools":
			switch epn {
			case "available":
				epf = toolsAvailableFlags

			case "installed":
				epf = toolsInstalledFlags

			case "install":
				epf = toolsInstallFlags

			case "remove":
				epf = toolsRemoveFlags

			}

		}
	}
	if epf == nil {
		return nil, nil, fmt.Errorf("unknown %q endpoint %q", svcn, epn)
	}

	// Parse endpoint flags if any
	if svcf.NArg() > 1 {
		if err := epf.Parse(svcf.Args()[1:]); err != nil {
			return nil, nil, err
		}
	}

	var (
		data     interface{}
		endpoint goa.Endpoint
		err      error
	)
	{
		switch svcn {
		case "indexes":
			c := indexesc.NewClient(scheme, host, doer, enc, dec, restore)
			switch epn {
			case "list":
				endpoint = c.List()
				data = nil
			case "add":
				endpoint = c.Add()
				data, err = indexesc.BuildAddPayload(*indexesAddBodyFlag)
			case "remove":
				endpoint = c.Remove()
				data, err = indexesc.BuildRemovePayload(*indexesRemoveBodyFlag)
			}
		case "tools":
			c := toolsc.NewClient(scheme, host, doer, enc, dec, restore)
			switch epn {
			case "available":
				endpoint = c.Available()
				data = nil
			case "installed":
				endpoint = c.Installed()
				data = nil
			case "install":
				endpoint = c.Install()
				data, err = toolsc.BuildInstallPayload(*toolsInstallBodyFlag)
			case "remove":
				endpoint = c.Remove()
				data, err = toolsc.BuildRemovePayload(*toolsRemoveBodyFlag, *toolsRemovePackagerFlag, *toolsRemoveNameFlag, *toolsRemoveVersionFlag)
			}
		}
	}
	if err != nil {
		return nil, nil, err
	}

	return endpoint, data, nil
}

// indexesUsage displays the usage of the indexes command and its subcommands.
func indexesUsage() {
	fmt.Fprintf(os.Stderr, `The indexes service manages the package_index files
Usage:
    %s [globalflags] indexes COMMAND [flags]

COMMAND:
    list: List implements list.
    add: Add implements add.
    remove: Remove implements remove.

Additional help:
    %s indexes COMMAND --help
`, os.Args[0], os.Args[0])
}
func indexesListUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] indexes list

List implements list.

Example:
    `+os.Args[0]+` indexes list
`, os.Args[0])
}

func indexesAddUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] indexes add -body JSON

Add implements add.
    -body JSON: 

Example:
    `+os.Args[0]+` indexes add --body '{
      "url": "http://downloads.arduino.cc/packages/package_index.json"
   }'
`, os.Args[0])
}

func indexesRemoveUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] indexes remove -body JSON

Remove implements remove.
    -body JSON: 

Example:
    `+os.Args[0]+` indexes remove --body '{
      "url": "http://downloads.arduino.cc/packages/package_index.json"
   }'
`, os.Args[0])
}

// toolsUsage displays the usage of the tools command and its subcommands.
func toolsUsage() {
	fmt.Fprintf(os.Stderr, `The tools service manages the available and installed tools
Usage:
    %s [globalflags] tools COMMAND [flags]

COMMAND:
    available: Available implements available.
    installed: Installed implements installed.
    install: Install implements install.
    remove: Remove implements remove.

Additional help:
    %s tools COMMAND --help
`, os.Args[0], os.Args[0])
}
func toolsAvailableUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] tools available

Available implements available.

Example:
    `+os.Args[0]+` tools available
`, os.Args[0])
}

func toolsInstalledUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] tools installed

Installed implements installed.

Example:
    `+os.Args[0]+` tools installed
`, os.Args[0])
}

func toolsInstallUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] tools install -body JSON

Install implements install.
    -body JSON: 

Example:
    `+os.Args[0]+` tools install --body '{
      "checksum": "Quam voluptas voluptates expedita rem ipsum.",
      "name": "avrdude",
      "packager": "arduino",
      "url": "Iusto libero explicabo beatae dolor adipisci nulla.",
      "version": "6.3.0-arduino9"
   }'
`, os.Args[0])
}

func toolsRemoveUsage() {
	fmt.Fprintf(os.Stderr, `%s [flags] tools remove -body JSON -packager STRING -name STRING -version STRING

Remove implements remove.
    -body JSON: 
    -packager STRING: The packager of the tool
    -name STRING: The name of the tool
    -version STRING: The version of the tool

Example:
    `+os.Args[0]+` tools remove --body '{
      "url": "http://downloads.arduino.cc/packages/package_index.json"
   }' --packager "arduino" --name "avrdude" --version "6.3.0-arduino9"
`, os.Args[0])
}
