/*
 *
 * Copyright 2019 NXP
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef SSS_AUTH_SE050_OEF_20191211_1809_
#define SSS_AUTH_SE050_OEF_20191211_1809_

/* ************************************************************************** */
/* Includes                                                                   */
/* ************************************************************************** */

/* ************************************************************************** */
/* Defines                                                                    */
/* ************************************************************************** */

/* clang-format off */



/* See https://www.nxp.com/docs/en/application-note/AN12436.pdf */

// Variant           ==> OEF ID
// SE050A1           ==> A204
// SE050A2           ==> A205
// SE050B1           ==> A202
// SE050B2           ==> A203
// SE050C1           ==> A200
// SE050C2           ==> A201
// Development Board ==> A1F4 (DEVKIT)

// SE050A1
#define SSS_AUTH_SE050A1_KEY_ENC \
    {0x34, 0xae, 0x09, 0x67, 0xe3, 0x29, 0xe9, 0x51, 0x8e, 0x72, 0x65, 0xd5, 0xad, 0xcc, 0x01, 0xc2 }
#define SSS_AUTH_SE050A1_KEY_MAC \
    {0x52, 0xb2, 0x53, 0xca, 0xdf, 0x47, 0x2b, 0xdb, 0x3d, 0x0f, 0xb3, 0x8e, 0x09, 0x77, 0x00, 0x99 }
#define SSS_AUTH_SE050A1_KEY_DEK \
    {0xac, 0xc9, 0x14, 0x31, 0xfe, 0x26, 0x81, 0x1b, 0x5e, 0xcb, 0xc8, 0x45, 0x62, 0x0d, 0x83, 0x44 }

// SE050A2
#define SSS_AUTH_SE050A2_KEY_ENC \
    {0x46, 0xa9, 0xc4, 0x8c, 0x34, 0xef, 0xe3, 0x44, 0xa5, 0x22, 0xe6, 0x67, 0x44, 0xf8, 0x99, 0x6a }
#define SSS_AUTH_SE050A2_KEY_MAC \
    {0x12, 0x03, 0xff, 0x61, 0xdf, 0xbc, 0x9c, 0x86, 0x19, 0x6a, 0x22, 0x74, 0xae, 0xf4, 0xed, 0x28 }
#define SSS_AUTH_SE050A2_KEY_DEK \
    {0xf7, 0x56, 0x1c, 0x6f, 0x48, 0x33, 0x61, 0x19, 0xee, 0x39, 0x43, 0x9a, 0xab, 0x34, 0x09, 0x8e }

// SE050B1
#define SSS_AUTH_SE050B1_KEY_ENC \
    {0xd4, 0x99, 0xbc, 0x90, 0xde, 0xa5, 0x42, 0xcf, 0x78, 0xd2, 0x5e, 0x13, 0xd6, 0x4c, 0xbb, 0x1f }
#define SSS_AUTH_SE050B1_KEY_MAC \
    {0x08, 0x15, 0x55, 0x96, 0x43, 0xfb, 0x79, 0xeb, 0x85, 0x01, 0xa0, 0xdc, 0x83, 0x3d, 0x90, 0x1f }
#define SSS_AUTH_SE050B1_KEY_DEK \
    {0xbe, 0x7d, 0xdf, 0xb4, 0x06, 0xe8, 0x1a, 0xe4, 0xe9, 0x66, 0x5a, 0x9f, 0xed, 0x64, 0x26, 0x7c }

// SE050B2
#define SSS_AUTH_SE050B2_KEY_ENC \
    {0x5f, 0xa4, 0x3d, 0x82, 0x02, 0xd2, 0x5e, 0x9a, 0x85, 0xb1, 0xfe, 0x7e, 0x2d, 0x26, 0x47, 0x8d }
#define SSS_AUTH_SE050B2_KEY_MAC \
    {0x10, 0x5c, 0xea, 0x22, 0x19, 0xf5, 0x2b, 0xd1, 0x67, 0xa0, 0x74, 0x63, 0xc6, 0x93, 0x79, 0xc3 }
#define SSS_AUTH_SE050B2_KEY_DEK \
    {0xd7, 0x02, 0x81, 0x57, 0xf2, 0xad, 0x37, 0x2c, 0x74, 0xbe, 0x96, 0x9b, 0xcc, 0x39, 0x06, 0x27 }

// SE050C1
#define SSS_AUTH_SE050C1_KEY_ENC \
    {0x85, 0x2b, 0x59, 0x62, 0xe9, 0xcc, 0xe5, 0xd0, 0xbe, 0x74, 0x6b, 0x83, 0x3b, 0xcc, 0x62, 0x87 }
#define SSS_AUTH_SE050C1_KEY_MAC \
    {0xdb, 0x0a, 0xa3, 0x19, 0xa4, 0x08, 0x69, 0x6c, 0x8e, 0x10, 0x7a, 0xb4, 0xe3, 0xc2, 0x6b, 0x47 }
#define SSS_AUTH_SE050C1_KEY_DEK \
    {0x4c, 0x2f, 0x75, 0xc6, 0xa2, 0x78, 0xa4, 0xae, 0xe5, 0xc9, 0xaf, 0x7c, 0x50, 0xee, 0xa8, 0x0c }

// SE050C2
#define SSS_AUTH_SE050C2_KEY_ENC \
    {0xbd, 0x1d, 0xe2, 0x0a, 0x81, 0xea, 0xb2, 0xbf, 0x3b, 0x70, 0x9a, 0x9d, 0x69, 0xa3, 0x12, 0x54 }
#define SSS_AUTH_SE050C2_KEY_MAC \
    {0x9a, 0x76, 0x1b, 0x8d, 0xba, 0x6b, 0xed, 0xf2, 0x27, 0x41, 0xe4, 0x5d, 0x8d, 0x42, 0x36, 0xf5 }
#define SSS_AUTH_SE050C2_KEY_DEK \
    {0x9b, 0x99, 0x3b, 0x60, 0x0f, 0x1c, 0x64, 0xf5, 0xad, 0xc0, 0x63, 0x19, 0x2a, 0x96, 0xc9, 0x47 }

// SE050_DEVKIT
#define SSS_AUTH_SE050_DEVKIT_KEY_ENC \
    {0x35, 0xc2, 0x56, 0x45, 0x89, 0x58, 0xa3, 0x4f, 0x61, 0x36, 0x15, 0x5f, 0x82, 0x09, 0xd6, 0xcd }
#define SSS_AUTH_SE050_DEVKIT_KEY_MAC \
    {0xaf, 0x17, 0x7d, 0x5d, 0xbd, 0xf7, 0xc0, 0xd5, 0xc1, 0x0a, 0x05, 0xb9, 0xf1, 0x60, 0x7f, 0x78 }
#define SSS_AUTH_SE050_DEVKIT_KEY_DEK \
    {0xa1, 0xbc, 0x84, 0x38, 0xbf, 0x77, 0x93, 0x5b, 0x36, 0x1a, 0x44, 0x25, 0xfe, 0x79, 0xfa, 0x29 }

// SE051A2 
#define SSS_AUTH_SE051A2_KEY_ENC \
    { 0x84, 0x0a, 0x5d, 0x51, 0x79, 0x55, 0x11, 0xc9, 0xce, 0xf0, 0xc9, 0x6f, 0xd2, 0xcb, 0xf0, 0x41 }
#define SSS_AUTH_SE051A2_KEY_MAC \
    { 0x64, 0x6b, 0xc2, 0xb8, 0xc3, 0xa4, 0xd9, 0xc1, 0xfa, 0x8d, 0x71, 0x16, 0xbe, 0x04, 0xfd, 0xfe }
#define SSS_AUTH_SE051A2_KEY_DEK \
    { 0x03, 0xe6, 0x69, 0x9a, 0xca, 0x94, 0x26, 0xd9, 0xc3, 0x89, 0x22, 0xf8, 0x91, 0x4c, 0xe5, 0xf7 }

// SE051C2 
#define SSS_AUTH_SE051C2_KEY_ENC \
    { 0x88, 0xdb, 0xcd, 0x65, 0x82, 0x0d, 0x2a, 0xa0, 0x6f, 0xfa, 0xb9, 0x2a, 0xa8, 0xe7, 0x93, 0x64 }
#define SSS_AUTH_SE051C2_KEY_MAC \
    { 0xa8, 0x64, 0x4e, 0x2a, 0x04, 0xd9, 0xe9, 0xc8, 0xc0, 0xea, 0x60, 0x86, 0x68, 0x29, 0x99, 0xe5 }
#define SSS_AUTH_SE051C2_KEY_DEK \
    { 0x8a, 0x38, 0x72, 0x38, 0x99, 0x88, 0x18, 0x44, 0xe2, 0xc1, 0x51, 0x3d, 0xac, 0xd9, 0xf8, 0x0d }

/* clang-format on */

/* ************************************************************************** */
/* Structures and Typedefs                                                    */
/* ************************************************************************** */

/* ************************************************************************** */
/* Global Variables                                                           */
/* ************************************************************************** */

/* ************************************************************************** */
/* Functions                                                                  */
/* ************************************************************************** */

#endif /* SSS_AUTH_SE050_OEF_20191211_1809_  */