/*
 * Copyright (c) 2022 Syntiant Corp.  All rights reserved.
 * Contact at http://www.syntiant.com
 *
 * This software is available to you under a choice of one of two licenses.
 * You may choose to be licensed under the terms of the GNU General Public
 * License (GPL) Version 2, available from the file LICENSE in the main
 * directory of this source tree, or the OpenIB.org BSD license below.  Any
 * code involving Linux software will require selection of the GNU General
 * Public License (GPL) Version 2.
 *
 * OPENIB.ORG BSD LICENSE
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
#define NDP120_CHIP_CONFIG_SPICTL 0x4000903cU
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_SHIFT 0
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_MASK 0x00000003U
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_MASK) >> NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_DEFAULT 0x00000000U
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_DISABLE 0x0U
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_FOUR_WIRE 0x1U
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_THREE_WIRE 0x2U
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_QUAD 0x3U
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_MAX 0x3U
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_MODE_VALID(v) \
        (v >= 0 && v <= 3)
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_SHIFT 2
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_MASK 0x00000004U
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_READ(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_MASK) >> NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_READ_DEFAULT 0x00000000U
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_SHIFT 3
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_MASK 0x00001ff8U
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_MASK) >> NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MSPI_CLKDIV_DEFAULT 0x00000001U
#define NDP120_CHIP_CONFIG_SPICTL_MODE_SHIFT 13
#define NDP120_CHIP_CONFIG_SPICTL_MODE_MASK 0x00006000U
#define NDP120_CHIP_CONFIG_SPICTL_MODE(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_MODE_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MODE_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MODE_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MODE_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_MODE_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MODE_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MODE_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_MODE_MASK) >> NDP120_CHIP_CONFIG_SPICTL_MODE_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MODE_DEFAULT 0x00000000U
#define NDP120_CHIP_CONFIG_SPICTL_MODE_STANDBY 0x0U
#define NDP120_CHIP_CONFIG_SPICTL_MODE_SS 0x1U
#define NDP120_CHIP_CONFIG_SPICTL_MODE_TRANSFER 0x2U
#define NDP120_CHIP_CONFIG_SPICTL_MODE_UPDATE 0x3U
#define NDP120_CHIP_CONFIG_SPICTL_MODE_MAX 0x3U
#define NDP120_CHIP_CONFIG_SPICTL_MODE_VALID(v) \
        (v >= 0 && v <= 3)
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_SHIFT 15
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_MASK 0x00078000U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_MASK) >> NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_DEFAULT 0x00000000U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_ONE_BYTE 0x0U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_TWO_BYTE 0x1U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_THREE_BYTE 0x2U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_FOUR_BYTE 0x3U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_FIVE_BYTE 0x4U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_SIX_BYTE 0x5U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_SEVEN_BYTE 0x6U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_EIGHT_BYTE 0x7U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_NINE_BYTE 0x8U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_TEN_BYTE 0x9U
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_ELEVEN_BYTE 0xaU
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_TWELVE_BYTE 0xbU
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_THIRTEEN_BYTE 0xcU
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_FOURTEEN_BYTE 0xdU
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_FIFTEEN_BYTE 0xeU
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_SIXTEEN_BYTE 0xfU
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_MAX 0xfU
#define NDP120_CHIP_CONFIG_SPICTL_NUMBYTES_VALID(v) \
        (v >= 0 && v <= 15)
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_SHIFT 19
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_MASK 0x00380000U
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_OE(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_MASK) >> NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_OE_DEFAULT 0x00000000U
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_SHIFT 22
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_MASK 0x00c00000U
#define NDP120_CHIP_CONFIG_SPICTL_MSSB(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_MSSB_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MSSB_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_MSSB_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_MSSB_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_MSSB_MASK) >> NDP120_CHIP_CONFIG_SPICTL_MSSB_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_DEFAULT 0x00000000U
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_MSSB0 0x0U
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_MMSB1 0x1U
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_MMSB2 0x2U
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_MAX 0x2U
#define NDP120_CHIP_CONFIG_SPICTL_MSSB_VALID(v) \
        (v >= 0 && v <= 2)
#define NDP120_CHIP_CONFIG_SPICTL_TYPE_SHIFT 24
#define NDP120_CHIP_CONFIG_SPICTL_TYPE_MASK 0x03000000U
#define NDP120_CHIP_CONFIG_SPICTL_TYPE(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_TYPE_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_TYPE_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_TYPE_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_TYPE_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_TYPE_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_TYPE_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_TYPE_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_TYPE_MASK) >> NDP120_CHIP_CONFIG_SPICTL_TYPE_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_TYPE_DEFAULT 0x00000000U
#define NDP120_CHIP_CONFIG_SPICTL_DONE_SHIFT 26
#define NDP120_CHIP_CONFIG_SPICTL_DONE_MASK 0x04000000U
#define NDP120_CHIP_CONFIG_SPICTL_DONE(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_DONE_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_DONE_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_DONE_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_DONE_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_DONE_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_DONE_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_DONE_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_DONE_MASK) >> NDP120_CHIP_CONFIG_SPICTL_DONE_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_RSTB_SHIFT 27
#define NDP120_CHIP_CONFIG_SPICTL_RSTB_MASK 0x08000000U
#define NDP120_CHIP_CONFIG_SPICTL_RSTB(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_RSTB_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_RSTB_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_RSTB_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_RSTB_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_RSTB_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_RSTB_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_RSTB_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_RSTB_MASK) >> NDP120_CHIP_CONFIG_SPICTL_RSTB_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_RSTB_DEFAULT 0x00000001U
#define NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_SHIFT 28
#define NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_MASK 0x10000000U
#define NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK(v) \
        ((v) << NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_MASK) | ((v) << NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_SHIFT))
#define NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_MASK) >> NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_SHIFT)
#define NDP120_CHIP_CONFIG_SPICTL_FORCE_MSPI_CLK_DEFAULT 0x00000000U
#define NDP120_CHIP_CONFIG_SPICTL_DEFAULT 0x08000008U 
/* register array ndp120.chip_config.spitx[4] */
#define NDP120_CHIP_CONFIG_SPITX(i) (0x40009040U + ((i) << 2))
#define NDP120_CHIP_CONFIG_SPITX_COUNT 4
#define NDP120_CHIP_CONFIG_SPITX_TXBYTES_SHIFT 0
#define NDP120_CHIP_CONFIG_SPITX_TXBYTES_MASK 0xffffffffU
#define NDP120_CHIP_CONFIG_SPITX_TXBYTES(v) \
        ((v) << NDP120_CHIP_CONFIG_SPITX_TXBYTES_SHIFT)
#define NDP120_CHIP_CONFIG_SPITX_TXBYTES_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPITX_TXBYTES_SHIFT))
#define NDP120_CHIP_CONFIG_SPITX_TXBYTES_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPITX_TXBYTES_MASK) | ((v) << NDP120_CHIP_CONFIG_SPITX_TXBYTES_SHIFT))
#define NDP120_CHIP_CONFIG_SPITX_TXBYTES_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPITX_TXBYTES_MASK) >> NDP120_CHIP_CONFIG_SPITX_TXBYTES_SHIFT)
#define NDP120_CHIP_CONFIG_SPITX_TXBYTES_DEFAULT 0x00000000U
#define NDP120_CHIP_CONFIG_SPITX_DEFAULT 0x00000000U 
/* register array ndp120.chip_config.spirx[4] */
#define NDP120_CHIP_CONFIG_SPIRX(i) (0x40009050U + ((i) << 2))
#define NDP120_CHIP_CONFIG_SPIRX_COUNT 4
#define NDP120_CHIP_CONFIG_SPIRX_RXBYTES_SHIFT 0
#define NDP120_CHIP_CONFIG_SPIRX_RXBYTES_MASK 0xffffffffU
#define NDP120_CHIP_CONFIG_SPIRX_RXBYTES(v) \
        ((v) << NDP120_CHIP_CONFIG_SPIRX_RXBYTES_SHIFT)
#define NDP120_CHIP_CONFIG_SPIRX_RXBYTES_INSERT(x, v) \
        ((x) | ((v) << NDP120_CHIP_CONFIG_SPIRX_RXBYTES_SHIFT))
#define NDP120_CHIP_CONFIG_SPIRX_RXBYTES_MASK_INSERT(x, v) \
        (((x) & ~NDP120_CHIP_CONFIG_SPIRX_RXBYTES_MASK) | ((v) << NDP120_CHIP_CONFIG_SPIRX_RXBYTES_SHIFT))
#define NDP120_CHIP_CONFIG_SPIRX_RXBYTES_EXTRACT(x) \
        (((x) & NDP120_CHIP_CONFIG_SPIRX_RXBYTES_MASK) >> NDP120_CHIP_CONFIG_SPIRX_RXBYTES_SHIFT)
