/*
 * mbed SDK
 * Copyright (c) 2017 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Automatically generated configuration file.
// DO NOT EDIT, content will be overwritten.

#ifndef __MBED_CONFIG_DATA__
#define __MBED_CONFIG_DATA__

// Configuration parameters
#define CLOCK_SOURCE                                                      USE_PLL_HSI                                                                                      // set by target:PORTENTA_X8
#define HSE_VALUE                                                         25000000                                                                                         // set by target:PORTENTA_X8
#define LPTICKER_DELAY_TICKS                                              0                                                                                                // set by target:PORTENTA_X8
#define MBED_ALL_STATS_ENABLED                                            1                                                                                                // set by application[*]
#define MBED_CONF_ALT1250_PPP_BAUDRATE                                    115200                                                                                           // set by library:ALT1250_PPP
#define MBED_CONF_ALT1250_PPP_PROVIDE_DEFAULT                             0                                                                                                // set by library:ALT1250_PPP
#define MBED_CONF_ATMEL_RF_ASSUME_SPACED_SPI                              1                                                                                                // set by library:atmel-rf[STM]
#define MBED_CONF_ATMEL_RF_FULL_SPI_SPEED                                 7500000                                                                                          // set by library:atmel-rf
#define MBED_CONF_ATMEL_RF_FULL_SPI_SPEED_BYTE_SPACING                    250                                                                                              // set by library:atmel-rf
#define MBED_CONF_ATMEL_RF_IRQ_THREAD_STACK_SIZE                          1024                                                                                             // set by library:atmel-rf
#define MBED_CONF_ATMEL_RF_LOW_SPI_SPEED                                  3750000                                                                                          // set by library:atmel-rf
#define MBED_CONF_ATMEL_RF_PROVIDE_DEFAULT                                0                                                                                                // set by library:atmel-rf
#define MBED_CONF_ATMEL_RF_USE_SPI_SPACING_API                            0                                                                                                // set by library:atmel-rf
#define MBED_CONF_CELLULAR_AT_HANDLER_BUFFER_SIZE                         32                                                                                               // set by library:cellular
#define MBED_CONF_CELLULAR_CONTROL_PLANE_OPT                              0                                                                                                // set by library:cellular
#define MBED_CONF_CELLULAR_DEBUG_AT                                       0                                                                                                // set by library:cellular
#define MBED_CONF_CELLULAR_MAX_CP_DATA_RECV_LEN                           1358                                                                                             // set by library:cellular
#define MBED_CONF_CELLULAR_PRESENT                                        1                                                                                                // set by library:cellular
#define MBED_CONF_CELLULAR_RANDOM_MAX_START_DELAY                         0                                                                                                // set by library:cellular
#define MBED_CONF_CELLULAR_USE_APN_LOOKUP                                 0                                                                                                // set by library:cellular
#define MBED_CONF_CELLULAR_USE_SMS                                        0                                                                                                // set by library:cellular
#define MBED_CONF_DRIVERS_OSPI_CSN                                        OSPI_FLASH1_CSN                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_OSPI_DQS                                        OSPI_FLASH1_DQS                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_OSPI_IO0                                        OSPI_FLASH1_IO0                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_OSPI_IO1                                        OSPI_FLASH1_IO1                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_OSPI_IO2                                        OSPI_FLASH1_IO2                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_OSPI_IO3                                        OSPI_FLASH1_IO3                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_OSPI_IO4                                        OSPI_FLASH1_IO4                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_OSPI_IO5                                        OSPI_FLASH1_IO5                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_OSPI_IO6                                        OSPI_FLASH1_IO6                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_OSPI_IO7                                        OSPI_FLASH1_IO7                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_OSPI_SCK                                        OSPI_FLASH1_SCK                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_QSPI_CSN                                        QSPI_FLASH1_CSN                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_QSPI_IO0                                        QSPI_FLASH1_IO0                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_QSPI_IO1                                        QSPI_FLASH1_IO1                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_QSPI_IO2                                        QSPI_FLASH1_IO2                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_QSPI_IO3                                        QSPI_FLASH1_IO3                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_QSPI_SCK                                        QSPI_FLASH1_SCK                                                                                  // set by library:drivers
#define MBED_CONF_DRIVERS_UART_SERIAL_RXBUF_SIZE                          256                                                                                              // set by library:drivers
#define MBED_CONF_DRIVERS_UART_SERIAL_TXBUF_SIZE                          256                                                                                              // set by library:drivers
#define MBED_CONF_ESP8266_BUILT_IN_DNS                                    0                                                                                                // set by library:esp8266
#define MBED_CONF_ESP8266_DEBUG                                           0                                                                                                // set by library:esp8266
#define MBED_CONF_ESP8266_POWER_OFF_TIME_MS                               3                                                                                                // set by library:esp8266
#define MBED_CONF_ESP8266_POWER_ON_POLARITY                               0                                                                                                // set by library:esp8266
#define MBED_CONF_ESP8266_POWER_ON_TIME_MS                                3                                                                                                // set by library:esp8266
#define MBED_CONF_ESP8266_PROVIDE_DEFAULT                                 0                                                                                                // set by library:esp8266
#define MBED_CONF_ESP8266_SERIAL_BAUDRATE                                 115200                                                                                           // set by library:esp8266
#define MBED_CONF_ESP8266_SNTP_ENABLE                                     0                                                                                                // set by library:esp8266
#define MBED_CONF_ESP8266_SNTP_SERVER0                                    ""                                                                                               // set by library:esp8266
#define MBED_CONF_ESP8266_SNTP_SERVER1                                    ""                                                                                               // set by library:esp8266
#define MBED_CONF_ESP8266_SNTP_SERVER2                                    ""                                                                                               // set by library:esp8266
#define MBED_CONF_ESP8266_SNTP_TIMEZONE                                   0                                                                                                // set by library:esp8266
#define MBED_CONF_ESP8266_SOCKET_BUFSIZE                                  8192                                                                                             // set by library:esp8266
#define MBED_CONF_EVENTS_PRESENT                                          1                                                                                                // set by library:events
#define MBED_CONF_EVENTS_SHARED_DISPATCH_FROM_APPLICATION                 0                                                                                                // set by library:events
#define MBED_CONF_EVENTS_SHARED_EVENTSIZE                                 768                                                                                              // set by library:events
#define MBED_CONF_EVENTS_SHARED_HIGHPRIO_EVENTSIZE                        256                                                                                              // set by library:events
#define MBED_CONF_EVENTS_SHARED_HIGHPRIO_STACKSIZE                        1024                                                                                             // set by library:events
#define MBED_CONF_EVENTS_SHARED_STACKSIZE                                 2048                                                                                             // set by library:events
#define MBED_CONF_EVENTS_USE_LOWPOWER_TIMER_TICKER                        0                                                                                                // set by library:events
#define MBED_CONF_FAT_CHAN_FFS_DBG                                        0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_CODE_PAGE                                   437                                                                                              // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_EXFAT                                    0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_HEAPBUF                                  1                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_LOCK                                     0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_MINIMIZE                                 0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_NOFSINFO                                 0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_NORTC                                    0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_READONLY                                 0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_REENTRANT                                0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_RPATH                                    1                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_TIMEOUT                                  1000                                                                                             // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_FS_TINY                                     1                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_LFN_BUF                                     255                                                                                              // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_LFN_UNICODE                                 0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_MAX_LFN                                     255                                                                                              // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_MAX_SS                                      4096                                                                                             // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_MIN_SS                                      512                                                                                              // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_MULTI_PARTITION                             0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_NORTC_MDAY                                  1                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_NORTC_MON                                   1                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_NORTC_YEAR                                  2017                                                                                             // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_PRINT_FLOAT                                 0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_PRINT_LLI                                   0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_SFN_BUF                                     12                                                                                               // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_STRF_ENCODE                                 3                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_STR_VOLUME_ID                               0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_SYNC_T                                      HANDLE                                                                                           // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_USE_CHMOD                                   0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_USE_EXPAND                                  0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_USE_FASTSEEK                                0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_USE_FIND                                    0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_USE_FORWARD                                 0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_USE_LABEL                                   0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_USE_LFN                                     3                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_USE_MKFS                                    1                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_USE_STRFUNC                                 0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_USE_TRIM                                    1                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_VOLUMES                                     4                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FF_VOLUME_STRS                                 "RAM","NAND","CF","SD","SD2","USB","USB2","USB3"                                                 // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FLUSH_ON_NEW_CLUSTER                           0                                                                                                // set by library:fat_chan
#define MBED_CONF_FAT_CHAN_FLUSH_ON_NEW_SECTOR                            1                                                                                                // set by library:fat_chan
#define MBED_CONF_FILESYSTEM_PRESENT                                      1                                                                                                // set by library:filesystem
#define MBED_CONF_FLASHIAP_BLOCK_DEVICE_BASE_ADDRESS                      0xFFFFFFFF                                                                                       // set by library:flashiap-block-device
#define MBED_CONF_FLASHIAP_BLOCK_DEVICE_SIZE                              0                                                                                                // set by library:flashiap-block-device
#define MBED_CONF_GEMALTO_CINTERION_BAUDRATE                              115200                                                                                           // set by library:GEMALTO_CINTERION
#define MBED_CONF_GEMALTO_CINTERION_PROVIDE_DEFAULT                       0                                                                                                // set by library:GEMALTO_CINTERION
#define MBED_CONF_GENERIC_AT3GPP_BAUDRATE                                 115200                                                                                           // set by library:GENERIC_AT3GPP
#define MBED_CONF_GENERIC_AT3GPP_PROVIDE_DEFAULT                          0                                                                                                // set by library:GENERIC_AT3GPP
#define MBED_CONF_LORA_ADR_ON                                             1                                                                                                // set by library:lora
#define MBED_CONF_LORA_APPLICATION_EUI                                    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}                                                 // set by library:lora
#define MBED_CONF_LORA_APPLICATION_KEY                                    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00} // set by library:lora
#define MBED_CONF_LORA_APPSKEY                                            {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00} // set by library:lora
#define MBED_CONF_LORA_APP_PORT                                           15                                                                                               // set by library:lora
#define MBED_CONF_LORA_AUTOMATIC_UPLINK_MESSAGE                           1                                                                                                // set by library:lora
#define MBED_CONF_LORA_DEVICE_ADDRESS                                     0x00000000                                                                                       // set by library:lora
#define MBED_CONF_LORA_DEVICE_EUI                                         {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}                                                 // set by library:lora
#define MBED_CONF_LORA_DOWNLINK_PREAMBLE_LENGTH                           5                                                                                                // set by library:lora
#define MBED_CONF_LORA_DUTY_CYCLE_ON                                      1                                                                                                // set by library:lora
#define MBED_CONF_LORA_DUTY_CYCLE_ON_JOIN                                 1                                                                                                // set by library:lora
#define MBED_CONF_LORA_FSB_MASK                                           {0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x00FF}                                                         // set by library:lora
#define MBED_CONF_LORA_FSB_MASK_CHINA                                     {0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF}                                                 // set by library:lora
#define MBED_CONF_LORA_LBT_ON                                             0                                                                                                // set by library:lora
#define MBED_CONF_LORA_MAX_SYS_RX_ERROR                                   5                                                                                                // set by library:lora
#define MBED_CONF_LORA_NB_TRIALS                                          12                                                                                               // set by library:lora
#define MBED_CONF_LORA_NWKSKEY                                            {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00} // set by library:lora
#define MBED_CONF_LORA_OVER_THE_AIR_ACTIVATION                            1                                                                                                // set by library:lora
#define MBED_CONF_LORA_PHY                                                EU868                                                                                            // set by library:lora
#define MBED_CONF_LORA_PHY_AS923_SUB_REGION                               AS1                                                                                              // set by library:lora
#define MBED_CONF_LORA_PUBLIC_NETWORK                                     1                                                                                                // set by library:lora
#define MBED_CONF_LORA_TX_MAX_SIZE                                        64                                                                                               // set by library:lora
#define MBED_CONF_LORA_UPLINK_PREAMBLE_LENGTH                             8                                                                                                // set by library:lora
#define MBED_CONF_LORA_WAKEUP_TIME                                        5                                                                                                // set by library:lora
#define MBED_CONF_LWIP_ADDR_TIMEOUT                                       5                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_ADDR_TIMEOUT_MODE                                  1                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_DEBUG_ENABLED                                      0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_DEFAULT_THREAD_STACKSIZE                           512                                                                                              // set by library:lwip
#define MBED_CONF_LWIP_DHCP_TIMEOUT                                       60                                                                                               // set by library:lwip
#define MBED_CONF_LWIP_ENABLE_PPP_TRACE                                   0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_ETHERNET_ENABLED                                   1                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_IPV4_ENABLED                                       1                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_IPV6_ENABLED                                       0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_IP_VER_PREF                                        4                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_L3IP_ENABLED                                       0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_MBOX_SIZE                                          8                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_MEMP_NUM_TCPIP_MSG_INPKT                           8                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_MEMP_NUM_TCP_SEG                                   16                                                                                               // set by library:lwip
#define MBED_CONF_LWIP_MEM_SIZE                                           2310                                                                                             // set by library:lwip[STM]
#define MBED_CONF_LWIP_ND6_QUEUEING                                       0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_ND6_RDNSS_MAX_DNS_SERVERS                          0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_NETBUF_RECVINFO_ENABLED                            0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_NUM_NETBUF                                         8                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_NUM_PBUF                                           8                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_PBUF_POOL_SIZE                                     5                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_PPP_ENABLED                                        0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_PPP_IPV4_ENABLED                                   0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_PPP_IPV6_ENABLED                                   0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_PPP_THREAD_STACKSIZE                               768                                                                                              // set by library:lwip
#define MBED_CONF_LWIP_PRESENT                                            1                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_RAW_SOCKET_ENABLED                                 0                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_SOCKET_MAX                                         4                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_TCPIP_THREAD_PRIORITY                              osPriorityNormal                                                                                 // set by library:lwip
#define MBED_CONF_LWIP_TCPIP_THREAD_STACKSIZE                             1200                                                                                             // set by library:lwip
#define MBED_CONF_LWIP_TCP_CLOSE_TIMEOUT                                  1000                                                                                             // set by library:lwip
#define MBED_CONF_LWIP_TCP_ENABLED                                        1                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_TCP_MAXRTX                                         6                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_TCP_MSS                                            536                                                                                              // set by library:lwip
#define MBED_CONF_LWIP_TCP_SERVER_MAX                                     4                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_TCP_SND_BUF                                        (2 * TCP_MSS)                                                                                    // set by library:lwip
#define MBED_CONF_LWIP_TCP_SOCKET_MAX                                     4                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_TCP_SYNMAXRTX                                      6                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_TCP_WND                                            (4 * TCP_MSS)                                                                                    // set by library:lwip
#define MBED_CONF_LWIP_UDP_SOCKET_MAX                                     4                                                                                                // set by library:lwip
#define MBED_CONF_LWIP_USE_MBED_TRACE                                     0                                                                                                // set by library:lwip
#define MBED_CONF_MCR20A_PROVIDE_DEFAULT                                  0                                                                                                // set by library:mcr20a
#define MBED_CONF_NANOSTACK_LIBSERVICE_NSDYNMEM_TRACKER_ENABLED           0                                                                                                // set by library:nanostack-libservice
#define MBED_CONF_NANOSTACK_LIBSERVICE_PRESENT                            1                                                                                                // set by library:nanostack-libservice
#define MBED_CONF_NSAPI_ADD_EVENT_LISTENER_RETURN_CHANGE                  0                                                                                                // set by library:nsapi
#define MBED_CONF_NSAPI_DEFAULT_MESH_TYPE                                 THREAD                                                                                           // set by library:nsapi
#define MBED_CONF_NSAPI_DEFAULT_STACK                                     LWIP                                                                                             // set by library:nsapi
#define MBED_CONF_NSAPI_DEFAULT_WIFI_SECURITY                             NONE                                                                                             // set by library:nsapi
#define MBED_CONF_NSAPI_DNS_ADDRESSES_LIMIT                               10                                                                                               // set by library:nsapi
#define MBED_CONF_NSAPI_DNS_CACHE_SIZE                                    3                                                                                                // set by library:nsapi
#define MBED_CONF_NSAPI_DNS_RESPONSE_WAIT_TIME                            10000                                                                                            // set by library:nsapi
#define MBED_CONF_NSAPI_DNS_RETRIES                                       1                                                                                                // set by library:nsapi
#define MBED_CONF_NSAPI_DNS_TOTAL_ATTEMPTS                                10                                                                                               // set by library:nsapi
#define MBED_CONF_NSAPI_PRESENT                                           1                                                                                                // set by library:nsapi
#define MBED_CONF_NSAPI_SOCKET_STATS_ENABLED                              0                                                                                                // set by library:nsapi
#define MBED_CONF_NSAPI_SOCKET_STATS_MAX_COUNT                            10                                                                                               // set by library:nsapi
#define MBED_CONF_PLATFORM_CALLBACK_COMPARABLE                            1                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_CALLBACK_NONTRIVIAL                            1                                                                                                // set by application[*]
#define MBED_CONF_PLATFORM_CRASH_CAPTURE_ENABLED                          0                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_CTHUNK_COUNT_MAX                               8                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_DEEPSLEEP_STATS_VERBOSE                        0                                                                                                // set by library:platform[STM]
#define MBED_CONF_PLATFORM_DEFAULT_SERIAL_BAUD_RATE                       115200                                                                                           // set by application[*]
#define MBED_CONF_PLATFORM_ERROR_ALL_THREADS_INFO                         0                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_ERROR_FILENAME_CAPTURE_ENABLED                 0                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_ERROR_HIST_ENABLED                             0                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_ERROR_HIST_SIZE                                4                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_ERROR_REBOOT_MAX                               1                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_FATAL_ERROR_AUTO_REBOOT_ENABLED                0                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_MAX_ERROR_FILENAME_LEN                         16                                                                                               // set by library:platform
#define MBED_CONF_PLATFORM_MINIMAL_PRINTF_ENABLE_64_BIT                   1                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_MINIMAL_PRINTF_ENABLE_FLOATING_POINT           0                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_MINIMAL_PRINTF_SET_FLOATING_POINT_MAX_DECIMALS 6                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_POLL_USE_LOWPOWER_TIMER                        0                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_STDIO_BAUD_RATE                                115200                                                                                           // set by application[*]
#define MBED_CONF_PLATFORM_STDIO_BUFFERED_SERIAL                          0                                                                                                // set by application[*]
#define MBED_CONF_PLATFORM_STDIO_CONVERT_NEWLINES                         1                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_STDIO_CONVERT_TTY_NEWLINES                     1                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_STDIO_FLUSH_AT_EXIT                            1                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_STDIO_MINIMAL_CONSOLE_ONLY                     0                                                                                                // set by library:platform
#define MBED_CONF_PLATFORM_USE_MPU                                        1                                                                                                // set by library:platform
#define MBED_CONF_PPP_ENABLED                                             0                                                                                                // set by library:ppp
#define MBED_CONF_PPP_ENABLE_TRACE                                        0                                                                                                // set by library:ppp
#define MBED_CONF_PPP_IPV4_ENABLED                                        1                                                                                                // set by library:ppp
#define MBED_CONF_PPP_IPV6_ENABLED                                        0                                                                                                // set by library:ppp
#define MBED_CONF_PPP_MBED_EVENT_QUEUE                                    0                                                                                                // set by library:ppp
#define MBED_CONF_PPP_THREAD_STACKSIZE                                    816                                                                                              // set by library:ppp
#define MBED_CONF_QUECTEL_BC95_BAUDRATE                                   9600                                                                                             // set by library:QUECTEL_BC95
#define MBED_CONF_QUECTEL_BC95_PROVIDE_DEFAULT                            0                                                                                                // set by library:QUECTEL_BC95
#define MBED_CONF_QUECTEL_BG96_BAUDRATE                                   115200                                                                                           // set by library:QUECTEL_BG96
#define MBED_CONF_QUECTEL_BG96_PROVIDE_DEFAULT                            0                                                                                                // set by library:QUECTEL_BG96
#define MBED_CONF_QUECTEL_EC2X_BAUDRATE                                   115200                                                                                           // set by library:QUECTEL_EC2X
#define MBED_CONF_QUECTEL_EC2X_PROVIDE_DEFAULT                            0                                                                                                // set by library:QUECTEL_EC2X
#define MBED_CONF_QUECTEL_EC2X_START_TIMEOUT                              15000                                                                                            // set by library:QUECTEL_EC2X
#define MBED_CONF_QUECTEL_M26_BAUDRATE                                    115200                                                                                           // set by library:QUECTEL_M26
#define MBED_CONF_QUECTEL_M26_PROVIDE_DEFAULT                             0                                                                                                // set by library:QUECTEL_M26
#define MBED_CONF_QUECTEL_UG96_BAUDRATE                                   115200                                                                                           // set by library:QUECTEL_UG96
#define MBED_CONF_QUECTEL_UG96_PROVIDE_DEFAULT                            0                                                                                                // set by library:QUECTEL_UG96
#define MBED_CONF_RM1000_AT_BAUDRATE                                      230400                                                                                           // set by library:RM1000_AT
#define MBED_CONF_RM1000_AT_PROVIDE_DEFAULT                               0                                                                                                // set by library:RM1000_AT
#define MBED_CONF_RTOS_API_PRESENT                                        1                                                                                                // set by library:rtos-api
#define MBED_CONF_RTOS_ENABLE_ALL_RTX_EVENTS                              0                                                                                                // set by library:rtos
#define MBED_CONF_RTOS_EVFLAGS_NUM                                        0                                                                                                // set by library:rtos
#define MBED_CONF_RTOS_IDLE_THREAD_STACK_SIZE                             512                                                                                              // set by library:rtos
#define MBED_CONF_RTOS_IDLE_THREAD_STACK_SIZE_DEBUG_EXTRA                 128                                                                                              // set by library:rtos[STM]
#define MBED_CONF_RTOS_IDLE_THREAD_STACK_SIZE_TICKLESS_EXTRA              256                                                                                              // set by library:rtos
#define MBED_CONF_RTOS_MAIN_THREAD_STACK_SIZE                             32768                                                                                            // set by application[*]
#define MBED_CONF_RTOS_MSGQUEUE_DATA_SIZE                                 0                                                                                                // set by library:rtos
#define MBED_CONF_RTOS_MSGQUEUE_NUM                                       0                                                                                                // set by library:rtos
#define MBED_CONF_RTOS_MUTEX_NUM                                          0                                                                                                // set by library:rtos
#define MBED_CONF_RTOS_PRESENT                                            1                                                                                                // set by library:rtos
#define MBED_CONF_RTOS_SEMAPHORE_NUM                                      0                                                                                                // set by library:rtos
#define MBED_CONF_RTOS_THREAD_NUM                                         0                                                                                                // set by library:rtos
#define MBED_CONF_RTOS_THREAD_STACK_SIZE                                  4096                                                                                             // set by library:rtos
#define MBED_CONF_RTOS_THREAD_USER_STACK_SIZE                             0                                                                                                // set by library:rtos
#define MBED_CONF_RTOS_TIMER_NUM                                          0                                                                                                // set by library:rtos
#define MBED_CONF_RTOS_TIMER_THREAD_STACK_SIZE                            768                                                                                              // set by library:rtos
#define MBED_CONF_S2LP_PROVIDE_DEFAULT                                    0                                                                                                // set by library:s2lp
#define MBED_CONF_SARA4_PPP_BAUDRATE                                      115200                                                                                           // set by library:SARA4_PPP
#define MBED_CONF_SARA4_PPP_PROVIDE_DEFAULT                               0                                                                                                // set by library:SARA4_PPP
#define MBED_CONF_STM32_EMAC_ETH_PHY_ADDRESS                              0                                                                                                // set by library:stm32-emac
#define MBED_CONF_STM32_EMAC_ETH_PHY_AUTONEGOTIATION                      ETH_AUTONEGOTIATION_ENABLE                                                                       // set by library:stm32-emac
#define MBED_CONF_STM32_EMAC_ETH_PHY_DUPLEXMODE                           ETH_MODE_FULLDUPLEX                                                                              // set by library:stm32-emac
#define MBED_CONF_STM32_EMAC_ETH_PHY_DUPLEX_STATUS                        0x0010                                                                                           // set by library:stm32-emac
#define MBED_CONF_STM32_EMAC_ETH_PHY_MEDIA_INTERFACE                      ETH_MEDIA_INTERFACE_RMII                                                                         // set by library:stm32-emac
#define MBED_CONF_STM32_EMAC_ETH_PHY_RESET_DELAY                          500                                                                                              // set by library:stm32-emac
#define MBED_CONF_STM32_EMAC_ETH_PHY_SPEED                                ETH_SPEED_100M                                                                                   // set by library:stm32-emac
#define MBED_CONF_STM32_EMAC_ETH_PHY_SPEED_STATUS                         0x0004                                                                                           // set by library:stm32-emac
#define MBED_CONF_STM32_EMAC_ETH_PHY_STATUS_REGISTER                      31                                                                                               // set by library:stm32-emac
#define MBED_CONF_STM32_EMAC_ETH_RXBUFNB                                  4                                                                                                // set by library:stm32-emac
#define MBED_CONF_STM32_EMAC_ETH_TXBUFNB                                  10                                                                                               // set by library:stm32-emac[STM32H7]
#define MBED_CONF_STM32_EMAC_THREAD_STACKSIZE                             1024                                                                                             // set by library:stm32-emac
#define MBED_CONF_STORAGE_DEFAULT_KV                                      kv                                                                                               // set by library:storage
#define MBED_CONF_STORAGE_FILESYSTEM_BLOCKDEVICE                          default                                                                                          // set by library:storage_filesystem
#define MBED_CONF_STORAGE_FILESYSTEM_EXTERNAL_BASE_ADDRESS                0                                                                                                // set by library:storage_filesystem
#define MBED_CONF_STORAGE_FILESYSTEM_EXTERNAL_SIZE                        0                                                                                                // set by library:storage_filesystem
#define MBED_CONF_STORAGE_FILESYSTEM_FILESYSTEM                           default                                                                                          // set by library:storage_filesystem
#define MBED_CONF_STORAGE_FILESYSTEM_FOLDER_PATH                          kvstore                                                                                          // set by library:storage_filesystem
#define MBED_CONF_STORAGE_FILESYSTEM_INTERNAL_BASE_ADDRESS                0                                                                                                // set by library:storage_filesystem
#define MBED_CONF_STORAGE_FILESYSTEM_MOUNT_POINT                          kv                                                                                               // set by library:storage_filesystem
#define MBED_CONF_STORAGE_FILESYSTEM_NO_RBP_BLOCKDEVICE                   default                                                                                          // set by library:storage_filesystem_no_rbp
#define MBED_CONF_STORAGE_FILESYSTEM_NO_RBP_EXTERNAL_BASE_ADDRESS         0                                                                                                // set by library:storage_filesystem_no_rbp
#define MBED_CONF_STORAGE_FILESYSTEM_NO_RBP_EXTERNAL_SIZE                 0                                                                                                // set by library:storage_filesystem_no_rbp
#define MBED_CONF_STORAGE_FILESYSTEM_NO_RBP_FILESYSTEM                    default                                                                                          // set by library:storage_filesystem_no_rbp
#define MBED_CONF_STORAGE_FILESYSTEM_NO_RBP_FOLDER_PATH                   kvstore                                                                                          // set by library:storage_filesystem_no_rbp
#define MBED_CONF_STORAGE_FILESYSTEM_NO_RBP_MOUNT_POINT                   kv                                                                                               // set by library:storage_filesystem_no_rbp
#define MBED_CONF_STORAGE_FILESYSTEM_RBP_INTERNAL_SIZE                    0                                                                                                // set by library:storage_filesystem
#define MBED_CONF_STORAGE_STORAGE_TYPE                                    default                                                                                          // set by library:storage
#define MBED_CONF_STORAGE_TDB_EXTERNAL_BLOCKDEVICE                        default                                                                                          // set by library:storage_tdb_external
#define MBED_CONF_STORAGE_TDB_EXTERNAL_EXTERNAL_BASE_ADDRESS              0                                                                                                // set by library:storage_tdb_external
#define MBED_CONF_STORAGE_TDB_EXTERNAL_EXTERNAL_SIZE                      0                                                                                                // set by library:storage_tdb_external
#define MBED_CONF_STORAGE_TDB_EXTERNAL_INTERNAL_BASE_ADDRESS              0                                                                                                // set by library:storage_tdb_external
#define MBED_CONF_STORAGE_TDB_EXTERNAL_NO_RBP_BLOCKDEVICE                 default                                                                                          // set by library:storage_tdb_external_no_rbp
#define MBED_CONF_STORAGE_TDB_EXTERNAL_NO_RBP_EXTERNAL_BASE_ADDRESS       0                                                                                                // set by library:storage_tdb_external_no_rbp
#define MBED_CONF_STORAGE_TDB_EXTERNAL_NO_RBP_EXTERNAL_SIZE               0                                                                                                // set by library:storage_tdb_external_no_rbp
#define MBED_CONF_STORAGE_TDB_EXTERNAL_RBP_INTERNAL_SIZE                  0                                                                                                // set by library:storage_tdb_external
#define MBED_CONF_STORAGE_TDB_INTERNAL_INTERNAL_BASE_ADDRESS              0                                                                                                // set by library:storage_tdb_internal
#define MBED_CONF_STORAGE_TDB_INTERNAL_INTERNAL_SIZE                      0                                                                                                // set by library:storage_tdb_internal
#define MBED_CONF_TARGET_BOOT_STACK_SIZE                                  0x400                                                                                            // set by library:rtos[*]
#define MBED_CONF_TARGET_CONSOLE_UART                                     1                                                                                                // set by target:Target
#define MBED_CONF_TARGET_CUSTOM_TICKERS                                   1                                                                                                // set by target:Target
#define MBED_CONF_TARGET_DEEP_SLEEP_LATENCY                               4                                                                                                // set by target:MCU_STM32
#define MBED_CONF_TARGET_DEFAULT_ADC_VREF                                 NAN                                                                                              // set by target:Target
#define MBED_CONF_TARGET_GPIO_RESET_AT_INIT                               0                                                                                                // set by target:MCU_STM32
#define MBED_CONF_TARGET_I2C_TIMING_VALUE_ALGO                            1                                                                                                // set by target:PORTENTA_X8
#define MBED_CONF_TARGET_INIT_US_TICKER_AT_BOOT                           1                                                                                                // set by target:MCU_STM32
#define MBED_CONF_TARGET_INTERNAL_FLASH_UNIFORM_SECTORS                   1                                                                                                // set by target:Target
#define MBED_CONF_TARGET_LPTICKER_LPTIM                                   1                                                                                                // set by target:MCU_STM32H7
#define MBED_CONF_TARGET_LPTICKER_LPTIM_CLOCK                             1                                                                                                // set by target:MCU_STM32
#define MBED_CONF_TARGET_LPUART_CLOCK_SOURCE                              USE_LPUART_CLK_LSE|USE_LPUART_CLK_PCLK1|USE_LPUART_CLK_PCLK3                                     // set by target:MCU_STM32
#define MBED_CONF_TARGET_LSE_AVAILABLE                                    1                                                                                                // set by target:PORTENTA_X8
#define MBED_CONF_TARGET_LSE_BYPASS                                       1                                                                                                // set by target:PORTENTA_X8
#define MBED_CONF_TARGET_LSE_DRIVE_LOAD_LEVEL                             RCC_LSEDRIVE_LOW                                                                                 // set by target:MCU_STM32H7
#define MBED_CONF_TARGET_MPU_ROM_END                                      0x0fffffff                                                                                       // set by target:Target
#define MBED_CONF_TARGET_RTC_CLOCK_SOURCE                                 USE_RTC_CLK_LSE_OR_LSI                                                                           // set by target:MCU_STM32
#define MBED_CONF_TARGET_SYSTEM_POWER_SUPPLY                              PWR_LDO_SUPPLY                                                                                   // set by target:PORTENTA_X8
#define MBED_CONF_TARGET_TICKLESS_FROM_US_TICKER                          0                                                                                                // set by target:Target
#define MBED_CONF_TARGET_USB_SPEED                                        USE_USB_OTG_HS                                                                                   // set by target:PORTENTA_X8
#define MBED_CONF_TARGET_XIP_ENABLE                                       0                                                                                                // set by target:Target
#define MBED_CONF_TELIT_HE910_BAUDRATE                                    115200                                                                                           // set by library:TELIT_HE910
#define MBED_CONF_TELIT_HE910_PROVIDE_DEFAULT                             0                                                                                                // set by library:TELIT_HE910
#define MBED_CONF_TELIT_ME310_BAUDRATE                                    115200                                                                                           // set by library:TELIT_ME310
#define MBED_CONF_TELIT_ME310_PROVIDE_DEFAULT                             0                                                                                                // set by library:TELIT_ME310
#define MBED_CONF_TELIT_ME910_BAUDRATE                                    115200                                                                                           // set by library:TELIT_ME910
#define MBED_CONF_TELIT_ME910_PROVIDE_DEFAULT                             0                                                                                                // set by library:TELIT_ME910
#define MBED_CONF_UBLOX_AT_BAUDRATE                                       115200                                                                                           // set by library:UBLOX_AT
#define MBED_CONF_UBLOX_AT_PROVIDE_DEFAULT                                0                                                                                                // set by library:UBLOX_AT
#define MBED_CONF_UBLOX_N2XX_BAUDRATE                                     9600                                                                                             // set by library:UBLOX_N2XX
#define MBED_CONF_UBLOX_N2XX_PROVIDE_DEFAULT                              0                                                                                                // set by library:UBLOX_N2XX
#define MBED_CONF_UBLOX_PPP_BAUDRATE                                      115200                                                                                           // set by library:UBLOX_PPP
#define MBED_CONF_UBLOX_PPP_PROVIDE_DEFAULT                               0                                                                                                // set by library:UBLOX_PPP
#define MBED_CRC_TABLE_SIZE                                               16                                                                                               // set by library:drivers
#define MBED_LFS2_BLOCK_CYCLES                                            1024                                                                                             // set by library:littlefs2
#define MBED_LFS2_BLOCK_SIZE                                              512                                                                                              // set by library:littlefs2
#define MBED_LFS2_CACHE_SIZE                                              64                                                                                               // set by library:littlefs2
#define MBED_LFS2_ENABLE_INFO                                             0                                                                                                // set by library:littlefs2
#define MBED_LFS2_INTRINSICS                                              1                                                                                                // set by library:littlefs2
#define MBED_LFS2_LOOKAHEAD_SIZE                                          64                                                                                               // set by library:littlefs2
#define MBED_LFS_BLOCK_SIZE                                               512                                                                                              // set by library:littlefs
#define MBED_LFS_ENABLE_INFO                                              0                                                                                                // set by library:littlefs
#define MBED_LFS_INTRINSICS                                               1                                                                                                // set by library:littlefs
#define MBED_LFS_LOOKAHEAD                                                512                                                                                              // set by library:littlefs
#define MBED_LFS_PROG_SIZE                                                64                                                                                               // set by library:littlefs
#define MBED_LFS_READ_SIZE                                                64                                                                                               // set by library:littlefs
#define MBED_MEM_TRACING_ENABLED                                          1                                                                                                // set by application[*]
#define MBED_STACK_DUMP_ENABLED                                           0                                                                                                // set by library:platform
#define MBED_TRACE_COLOR_THEME                                            0                                                                                                // set by library:mbed-trace
#define MEM_ALLOC                                                         malloc                                                                                           // set by library:mbed-trace
#define MEM_FREE                                                          free                                                                                             // set by library:mbed-trace
#define PPP_DEBUG                                                         0                                                                                                // set by library:ppp
// Macros
#define MBEDTLS_CIPHER_MODE_CTR                                                                                                                                            // defined by library:SecureStore
#define NSAPI_PPP_AVAILABLE                                               (MBED_CONF_PPP_ENABLED || MBED_CONF_LWIP_PPP_ENABLED)                                            // defined by library:ppp
#define NSDYNMEM_TRACKER_ENABLED                                          MBED_CONF_NANOSTACK_LIBSERVICE_NSDYNMEM_TRACKER_ENABLED                                          // defined by library:nanostack-libservice
#define UNITY_INCLUDE_CONFIG_H                                                                                                                                             // defined by library:utest
#define _RTE_                                                                                                                                                              // defined by library:rtos

#endif
