/* mbed Microcontroller Library
 * Copyright (c) 2006-2020 ARM Limited
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MBED_BLE_GATT_SERVER_EVENTS_H__
#define MBED_BLE_GATT_SERVER_EVENTS_H__

/**
 * @addtogroup ble
 * @{
 * @addtogroup gatt
 * @{
 * @addtogroup server
 * @{
 */

/**
 * Abstract events generated by a GattServer vendor port.
 *
 * @attention This class is not part of the public API.
 */
class GattServerEvents
{
public:
    /**
     * Enumeration of events, which a GattServer
     * implementation can generate.
     */
    typedef enum gattEvent_e {
        /**
         * Fired when a server event was successfully sent.
         */
        GATT_EVENT_DATA_SENT = 1,

        /**
         * Client has written a server attribute.
         */
        GATT_EVENT_DATA_WRITTEN = 2,

        /**
         * Notification or indication enabled in CCCD.
         */
        GATT_EVENT_UPDATES_ENABLED = 3,

        /**
         * Notification or Indication disabled in CCCD.
         */
        GATT_EVENT_UPDATES_DISABLED = 4,

        /**
         * Response received from Characteristic Value Indication message.
         * @deprecated This event is never used. Indications use GATT_EVENT_DATA_SENT
         * only after confirmation is received.
         */
        GATT_EVENT_CONFIRMATION_RECEIVED = 5,

        /**
         * Request application to authorize read.
         */
        GATT_EVENT_READ_AUTHORIZATION_REQ = 6,

        /**
         * Request application to authorize write.
         */
        GATT_EVENT_WRITE_AUTHORIZATION_REQ = 7,

    } gattEvent_t;
};

/**
 * @}
 * @}
 * @}
 */

#endif /* ifndef MBED_BLE_GATT_SERVER_EVENTS_H__ */
