/*
 *
 * Copyright 2019 NXP
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef __EX_SCP03_PUF_H__
#define __EX_SCP03_PUF_H__

#if defined(SECURE_WORLD)

/**
  * Activation Code to start PUF.
  * This is used only for testing purposes, actual
  * activation code should be stored in PFR and always
  * read from PFR before PUF_Start.
  *
  * AC is different for all PUFs, this code cannot be used
  * on any other board.
  */

#define ACTIVATION_CODE_TESTING_LOCAL                                                                               \
    {                                                                                                               \
        0xA2, 0x7D, 0xF7, 0x38, 0x15, 0x8E, 0x1F, 0xE1, 0x8D, 0x9F, 0x45, 0x6F, 0x8A, 0x2C, 0xA5, 0x8D, 0xC2, 0x15, \
            0xD1, 0x9A, 0x13, 0xFA, 0xD8, 0x5E, 0x36, 0x00, 0x9A, 0xDD, 0x42, 0xB6, 0x4F, 0x6D, 0x08, 0xFB, 0x89,   \
            0x37, 0x3C, 0x1D, 0xAF, 0xD5, 0x63, 0xE1, 0xE8, 0xC8, 0x93, 0x93, 0x5C, 0xD8, 0x49, 0xF3, 0x2D, 0xD1,   \
            0xF9, 0x3D, 0x74, 0x97, 0x37, 0xBD, 0xC5, 0xBE, 0x04, 0x6A, 0x5E, 0xBC, 0xF3, 0x7D, 0xBD, 0xE0, 0xC6,   \
            0x3E, 0x66, 0x5F, 0xC0, 0x5C, 0x57, 0x09, 0x57, 0x8C, 0x45, 0x30, 0x12, 0x6F, 0xFA, 0x3B, 0xDB, 0x40,   \
            0xCE, 0xB8, 0xF2, 0x6E, 0x9B, 0xF1, 0x16, 0x74, 0x2A, 0x34, 0x7A, 0x6F, 0xB6, 0xEF, 0xA3, 0xD3, 0x8C,   \
            0xF0, 0x03, 0xB8, 0xB8, 0x8B, 0x2F, 0x27, 0x16, 0xDD, 0xE0, 0x92, 0xC8, 0xD7, 0x4E, 0x4A, 0x44, 0xBC,   \
            0x4D, 0x7C, 0x7E, 0xA0, 0xE7, 0x8E, 0xA3, 0x5D, 0xFB, 0x53, 0x4D, 0x67, 0x74, 0x4B, 0x65, 0x1E, 0xC1,   \
            0x57, 0x7C, 0x67, 0xB3, 0x58, 0x42, 0x4F, 0x36, 0xF9, 0x0C, 0x77, 0x58, 0x6C, 0x9A, 0x04, 0x15, 0x0D,   \
            0x71, 0x55, 0x3F, 0x8E, 0x69, 0x12, 0x2C, 0xFC, 0xCA, 0x80, 0xD7, 0xC7, 0x27, 0xFE, 0xEA, 0x6E, 0x7D,   \
            0xFC, 0x84, 0x50, 0x0F, 0x00, 0x71, 0x09, 0x8F, 0x2C, 0x91, 0x57, 0xAF, 0xE7, 0xF3, 0x11, 0xA8, 0xA2,   \
            0x76, 0xF2, 0x1D, 0x88, 0xA5, 0x2F, 0x2E, 0x09, 0x02, 0xB3, 0xC4, 0xD5, 0x1D, 0x39, 0x20, 0x3C, 0x36,   \
            0x51, 0x19, 0x9C, 0xFB, 0xC9, 0x33, 0xD6, 0xBE, 0x93, 0xBD, 0x68, 0x6D, 0x51, 0x30, 0xA9, 0x11, 0x98,   \
            0xAD, 0x84, 0xC5, 0x50, 0x9A, 0x7E, 0x11, 0x8E, 0x43, 0x78, 0x79, 0x3A, 0xE2, 0xF0, 0x52, 0xB8, 0xDD,   \
            0x4E, 0xD3, 0xB8, 0xE0, 0xF9, 0xA6, 0x34, 0xF2, 0xE1, 0xA3, 0xEC, 0x92, 0x46, 0xE4, 0xAE, 0x09, 0xFB,   \
            0x2A, 0x1F, 0x6F, 0xD0, 0x23, 0x0F, 0xE8, 0x0D, 0x52, 0x98, 0x88, 0xA3, 0x15, 0xC9, 0x01, 0x94, 0x61,   \
            0x1D, 0xB7, 0x2F, 0x5F, 0xB2, 0x94, 0x5D, 0x01, 0x54, 0x61, 0xB1, 0xF2, 0xB6, 0xF3, 0x79, 0x22, 0x2F,   \
            0x9C, 0x44, 0xAB, 0xD5, 0x0D, 0xC8, 0x42, 0x06, 0x03, 0x33, 0x8E, 0x52, 0xDF, 0xC8, 0xDE, 0x18, 0xF6,   \
            0xD6, 0x73, 0x64, 0x70, 0x94, 0xC5, 0x0F, 0x64, 0x3E, 0x7E, 0x14, 0xE9, 0xF4, 0x4C, 0xF9, 0x5E, 0x5A,   \
            0xC6, 0x39, 0xF7, 0xA9, 0x72, 0xB5, 0x08, 0x51, 0x11, 0x7A, 0xDB, 0x8A, 0x72, 0xF9, 0xF7, 0x23, 0x59,   \
            0xAC, 0x9A, 0x61, 0x2F, 0xA6, 0xDB, 0x84, 0xBD, 0x7C, 0x7E, 0x1A, 0xEA, 0xFB, 0x6B, 0xC8, 0x5E, 0xE3,   \
            0x04, 0xBF, 0x13, 0x05, 0xFA, 0xDA, 0xF7, 0x96, 0x91, 0x6A, 0x40, 0xA8, 0xC7, 0x77, 0xC6, 0xCB, 0xAC,   \
            0x2C, 0xD9, 0xCD, 0x6C, 0x6D, 0xA4, 0x19, 0x50, 0x07, 0x8C, 0x72, 0xEE, 0x0F, 0x33, 0xA2, 0x48, 0x20,   \
            0x24, 0x5E, 0x93, 0xE7, 0xC2, 0x73, 0x02, 0x00, 0x87, 0xFD, 0x11, 0x2A, 0x8F, 0x9F, 0xD9, 0xFB, 0xF7,   \
            0xAC, 0x0D, 0x77, 0xBB, 0x1C, 0xF8, 0x55, 0xE7, 0x10, 0x05, 0x5C, 0x18, 0x23, 0x26, 0xDD, 0x60, 0xDD,   \
            0xFF, 0xAB, 0x8D, 0x68, 0xDE, 0x7E, 0xE8, 0xB3, 0xDE, 0xA2, 0x6D, 0x35, 0x7C, 0x9B, 0x31, 0x11, 0x5E,   \
            0xEC, 0xB5, 0x51, 0x00, 0x1C, 0x5C, 0x65, 0xA3, 0xC7, 0x35, 0xFA, 0x37, 0x1C, 0xDF, 0xD0, 0x26, 0xA0,   \
            0x44, 0x57, 0xD4, 0xC9, 0xCE, 0xE5, 0x2B, 0xB4, 0x06, 0xF6, 0x9B, 0xE9, 0xE5, 0x66, 0x6F, 0x24, 0x30,   \
            0xBF, 0x6D, 0x8E, 0x2E, 0xE7, 0x13, 0x94, 0x0B, 0x6F, 0x1A, 0x7A, 0x77, 0xAB, 0xD9, 0xB4, 0x2D, 0xFF,   \
            0x4F, 0xB4, 0xC7, 0x04, 0x2E, 0xF7, 0x1B, 0xF6, 0x66, 0x2D, 0xA7, 0x59, 0x99, 0x57, 0x5F, 0x2C, 0x1A,   \
            0x75, 0x81, 0xF3, 0xAC, 0x41, 0x7A, 0xFB, 0x47, 0xF3, 0x0E, 0xDC, 0x9E, 0xAB, 0xED, 0x18, 0xA4, 0x43,   \
            0xCC, 0x80, 0xFB, 0x6E, 0x53, 0xD6, 0x91, 0x9F, 0x30, 0x80, 0xEA, 0x04, 0x42, 0x7B, 0x94, 0x62, 0x34,   \
            0x25, 0xEA, 0xA4, 0x9A, 0x72, 0x9B, 0x81, 0x47, 0xA5, 0xA0, 0xE9, 0x07, 0xBB, 0x09, 0xDA, 0x4C, 0x51,   \
            0x61, 0x00, 0xC7, 0x1E, 0x0E, 0x37, 0x7F, 0xF2, 0x2B, 0x82, 0xD0, 0xF6, 0x18, 0xFA, 0x56, 0xC7, 0x2D,   \
            0xEB, 0x22, 0xFC, 0xDC, 0x97, 0xDF, 0x65, 0xBC, 0xB4, 0x2A, 0xB3, 0x10, 0xFF, 0xC5, 0x7A, 0x9F, 0xF8,   \
            0xCD, 0xB9, 0x84, 0x60, 0x9E, 0x92, 0xFD, 0xF9, 0x16, 0x90, 0xB2, 0x81, 0x52, 0x7E, 0x03, 0xBC, 0x91,   \
            0xD8, 0x9A, 0x0C, 0xC1, 0x99, 0x93, 0x42, 0x67, 0x96, 0x3C, 0x01, 0x55, 0x37, 0x86, 0xD2, 0x37, 0xE6,   \
            0x07, 0xC8, 0x74, 0x41, 0xCD, 0x88, 0x93, 0x51, 0xBA, 0x9B, 0xB0, 0x00, 0x6D, 0x14, 0x4F, 0xD8, 0x7F,   \
            0x77, 0x9F, 0x7E, 0x15, 0xE2, 0xA9, 0xA0, 0xC8, 0x7F, 0xD4, 0xFA, 0xCD, 0x60, 0x91, 0xA8, 0x9B, 0xB7,   \
            0x41, 0x6E, 0x07, 0xCB, 0x21, 0xE9, 0x42, 0xC1, 0xB7, 0x6E, 0x63, 0x68, 0x90, 0x0E, 0x29, 0xBB, 0x0D,   \
            0x83, 0x32, 0xD0, 0x71, 0x5A, 0xE1, 0xEC, 0x21, 0x0E, 0x78, 0xC6, 0x60, 0x3D, 0x78, 0xFA, 0x5C, 0xEE,   \
            0xAC, 0x29, 0xC4, 0xE4, 0x0F, 0x92, 0x27, 0xBE, 0xD0, 0xA5, 0x1E, 0xF4, 0xDD, 0xAB, 0xB9, 0x22, 0xA0,   \
            0x7E, 0xFE, 0x47, 0x1D, 0x62, 0x69, 0x9D, 0x8D, 0x01, 0xCF, 0x5D, 0xC1, 0xAD, 0x50, 0x61, 0x77, 0x91,   \
            0x39, 0x0A, 0x97, 0x92, 0x92, 0x66, 0x9F, 0xE5, 0x57, 0x26, 0xD7, 0x01, 0xC3, 0xEF, 0x23, 0xCC, 0x98,   \
            0xB9, 0x39, 0x20, 0x6D, 0xC8, 0x10, 0x2D, 0xB8, 0x18, 0x2E, 0xC2, 0x25, 0x83, 0x88, 0x2A, 0xDF, 0xC7,   \
            0xBF, 0xBC, 0xE8, 0xA9, 0x7B, 0xD4, 0x19, 0x0E, 0xEF, 0x4E, 0xE4, 0xBA, 0x8B, 0x7C, 0xDB, 0x6A, 0x2A,   \
            0xEA, 0xA3, 0xED, 0xDD, 0xCF, 0x00, 0x85, 0x4B, 0xA0, 0xC2, 0xBC, 0x72, 0x39, 0x3D, 0x6A, 0x5C, 0x9D,   \
            0xDA, 0x8C, 0x1C, 0x67, 0x9A, 0xDC, 0x73, 0xF3, 0x9E, 0x2E, 0xA2, 0x0C, 0x42, 0x86, 0xE4, 0xA6, 0x3F,   \
            0x05, 0x57, 0xD0, 0xE4, 0xA7, 0x75, 0x5B, 0xA8, 0xA4, 0xE3, 0x1A, 0x57, 0x02, 0xBD, 0xE7, 0xDA, 0x32,   \
            0xA2, 0x69, 0xAA, 0xEC, 0xEB, 0xAF, 0x42, 0x8C, 0x72, 0xE4, 0xB1, 0x15, 0x26, 0x25, 0x7B, 0x29, 0xF8,   \
            0x97, 0x3F, 0x12, 0x29, 0x4F, 0x0B, 0xA5, 0x2E, 0x74, 0x8F, 0xA9, 0xF4, 0xED, 0x00, 0x42, 0x73, 0x92,   \
            0x59, 0x0B, 0xA8, 0x98, 0xF7, 0x7E, 0xE7, 0x09, 0xEE, 0xA4, 0x91, 0x2F, 0x93, 0xB7, 0x91, 0x1A, 0xBF,   \
            0x94, 0x96, 0xF9, 0xCC, 0xA4, 0x16, 0xDA, 0x01, 0x7C, 0x1A, 0xF9, 0xC3, 0xE5, 0x8A, 0xCC, 0x96, 0x54,   \
            0xC2, 0xDE, 0x1E, 0x04, 0x98, 0xA3, 0x6B, 0x55, 0x61, 0xB8, 0x1C, 0x57, 0x70, 0x9E, 0xAB, 0x48, 0xEA,   \
            0xD7, 0x18, 0x0A, 0xC8, 0x45, 0xB1, 0xC8, 0x6A, 0x5A, 0xAA, 0xB6, 0xDE, 0x76, 0x76, 0x2B, 0x82, 0x45,   \
            0x7E, 0x17, 0x83, 0x51, 0xAA, 0x13, 0xC8, 0xBF, 0x30, 0x62, 0xB9, 0xAE, 0xB7, 0x74, 0x55, 0xC7, 0x24,   \
            0x94, 0x3C, 0x1C, 0xA5, 0x1E, 0x94, 0x70, 0x71, 0xAF, 0x29, 0x5B, 0x79, 0xF1, 0xAF, 0x31, 0x30, 0x82,   \
            0x0F, 0x3C, 0x5A, 0x05, 0x1D, 0x88, 0x7D, 0x63, 0x4C, 0xCE, 0x7D, 0xFD, 0x07, 0x17, 0xB0, 0xC8, 0x13,   \
            0xC4, 0x7B, 0x0F, 0xBD, 0xFC, 0x5E, 0x58, 0x14, 0xD6, 0x17, 0x10, 0x5D, 0xDB, 0x54, 0x60, 0x3C, 0x68,   \
            0x0B, 0x54, 0x84, 0xFA, 0xAB, 0xD0, 0x02, 0xFE, 0x66, 0xB3, 0xEC, 0xDF, 0x06, 0x97, 0xC4, 0x0C, 0xDC,   \
            0xEC, 0x4B, 0x9B, 0x6C, 0x3A, 0x04, 0x72, 0x84, 0xA0, 0x9D, 0xC2, 0x6A, 0xB5, 0x69, 0x81, 0x30, 0x57,   \
            0x5F, 0x40, 0x81, 0x4C, 0x57, 0xA8, 0x0B, 0x41, 0x24, 0x68, 0x36, 0x8E, 0xFD, 0x2A, 0xE0, 0x69, 0xF5,   \
            0x3E, 0x56, 0x52, 0xF4, 0x5A, 0xFF, 0xF6, 0x32, 0xC2, 0xAE, 0xF4, 0xCC, 0x88, 0xA6, 0x5F, 0xFB, 0xFB,   \
            0x6B, 0xD1, 0xFF, 0x65, 0x31, 0xE9, 0x38, 0x1B, 0xCC, 0xA0, 0x47, 0xC0, 0x0D, 0x3C, 0x10, 0x5D, 0xB3,   \
            0x46, 0x63, 0x2A, 0xC4, 0x74, 0xCA, 0xC4, 0x3E, 0x49, 0xEB, 0x0A, 0xE3, 0xD6, 0xF1, 0xE8, 0xF5, 0xC3,   \
            0x9C, 0xD2, 0xE6, 0xEF, 0xCB, 0x29, 0xAF, 0x5D, 0xEA, 0x27, 0x1D, 0x8B, 0x8F, 0xEB, 0x33, 0x9E, 0x57,   \
            0xD4, 0x55, 0xD8, 0xB0, 0x34, 0x43, 0xA4, 0xF6, 0x38, 0x8B, 0x66, 0x1E, 0x30, 0xA1, 0x7D, 0xAF, 0xC2,   \
            0x1E, 0x6B, 0xFD, 0x73, 0x05, 0x39, 0xB5, 0x06, 0xEF, 0x93, 0x1D, 0x7A, 0xF7, 0x15, 0x74, 0x3A, 0x72,   \
            0x06, 0x6F, 0x9F, 0xA8, 0xCF, 0x4D, 0x2A, 0x8C, 0xB4, 0x7F, 0xB9, 0x40, 0xE7, 0x2E, 0x8B, 0xC1, 0xD9,   \
            0x84, 0xFF, 0x5E, 0x78, 0x5D, 0x6C, 0x36, 0xDC, 0xD5, 0x92, 0x94, 0x17, 0x11, 0x0E, 0xE0, 0xE2, 0xFD,   \
            0xC0,                                                                                                   \
    }

#define KEY_CODE_ENC                                                                                                \
    {                                                                                                               \
        0x00, 0x00, 0x00, 0x02, 0xE2, 0x9B, 0x12, 0x4E, 0xF2, 0xDC, 0xA8, 0xE3, 0x2D, 0x7A, 0xB3, 0x98, 0x56, 0x3E, \
            0x0A, 0x0F, 0x66, 0xCF, 0xB2, 0x37, 0x31, 0xBD, 0xD4, 0xD4, 0x42, 0x27, 0x73, 0x92, 0x23, 0xCC, 0xA7,   \
            0xE7, 0x51, 0xA4, 0x99, 0x91, 0x19, 0x68, 0x74, 0x92, 0xC9, 0x9D, 0xF2, 0x9F, 0x5B, 0x6E, 0x5E, 0x81    \
    }

#define KEY_CODE_MAC                                                                                                \
    {                                                                                                               \
        0x00, 0x00, 0x00, 0x02, 0x81, 0x54, 0x3E, 0x5D, 0x47, 0xDE, 0x23, 0x7C, 0x00, 0x1B, 0x16, 0xBE, 0x1B, 0x05, \
            0xED, 0xD2, 0xD5, 0xB2, 0x4D, 0x3C, 0xD3, 0xDD, 0xD5, 0xA9, 0x40, 0x5E, 0x7D, 0x90, 0x73, 0x74, 0xDE,   \
            0x05, 0xAC, 0x76, 0x7D, 0x87, 0xB6, 0x5E, 0x1F, 0x8E, 0xB5, 0x93, 0x53, 0x41, 0x51, 0x27, 0xE9, 0xF9    \
    }

#define KEY_CODE_DEK                                                                                                \
    {                                                                                                               \
        0x00, 0x00, 0x00, 0x02, 0x88, 0xE0, 0x9A, 0x2B, 0x23, 0x77, 0xC3, 0xF5, 0xEE, 0x28, 0x4F, 0x7C, 0x5B, 0xD8, \
            0x9C, 0xF5, 0xA8, 0xC9, 0xE4, 0xE3, 0xDC, 0x8D, 0x34, 0x3C, 0x00, 0x39, 0x7E, 0xA3, 0x35, 0x39, 0xFD,   \
            0xD1, 0xE4, 0x8D, 0xA9, 0x8C, 0x41, 0xAF, 0x8C, 0x8D, 0x50, 0xFE, 0x63, 0x96, 0x46, 0x2E, 0x4D, 0xEB    \
    }

#define EX_SSS_AUTH_SE05X_KEY_ENC KEY_CODE_ENC
#define EX_SSS_AUTH_SE05X_KEY_MAC KEY_CODE_MAC
#define EX_SSS_AUTH_SE05X_KEY_DEK KEY_CODE_DEK

#endif // SECURE_WORLD

#endif // __EX_SCP03_PUF_H__
