/* mbed Microcontroller Library
 * Copyright (c) 2006-2012 ARM Limited
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#ifndef RTOS_HANDLERS_H
#define RTOS_HANDLERS_H

#include "rtos/mbed_rtos_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/** \defgroup rtos-internal-api RTOS
 * \ingroup mbed-os-internal
 */

/**
 * \defgroup rtos_handlers RTOS hook functions
 * \ingroup rtos-internal-api
 * @{
 */
/**
 @note
 Sets the hook function called by thread termination
 @param fptr Hook function pointer.
 */
void rtos_attach_thread_terminate_hook(void (*fptr)(osThreadId_t id));
/** @}*/

#ifdef __cplusplus
}
#endif

#endif
