/*
 * DISCLAIMER
 *
 * Copyright 2018 ArangoDB GmbH, Cologne, Germany
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright holder is ArangoDB GmbH, Cologne, Germany
 */

package com.arangodb.internal.http;

import com.arangodb.Protocol;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.serde.InternalSerde;

import javax.net.ssl.SSLContext;

/**
 * @author Mark Vollmary
 */
public class HttpConnectionFactory implements ConnectionFactory {

    private final HttpConnection.Builder builder;

    public HttpConnectionFactory(final Integer timeout, final String user, final String password, final Boolean useSsl,
                                 final SSLContext sslContext, final Boolean verifyHost,
                                 final InternalSerde util, final Protocol protocol, final Long connectionTtl) {
        super();
        builder = new HttpConnection.Builder().timeout(timeout).user(user).password(password).useSsl(useSsl)
                .sslContext(sslContext).verifyHost(verifyHost).serializationUtil(util).protocol(protocol)
                .ttl(connectionTtl);

    }

    @Override
    public Connection create(final HostDescription host) {
        return builder.host(host).build();
    }

}
